% -------------------------------------------------------------
% VORINIT.m sets the proper parameters for the VOR block in the
% systems APILOT1, APILOT2, and APILOT3. Run this routine be-
% fore starting a new simulation!
% -------------------------------------------------------------

clc
disp(' ');
disp('Initialize the VOR block');
disp('========================');
HVOR  = input('Altitude of VOR antenna above sea level [m] (default 0): ');
if isempty(HVOR)
   HVOR = 0;
end

xVOR  = input('Initial X-distance to VOR antenna [m] (default 0): ');
if isempty(xVOR)
   xVOR = 0;
end
yVOR  = input('Initial Y-distance to VOR antenna [m] (default 0): ');
if isempty(yVOR)
   yVOR = 0;
end
CD    = input('Course Datum [deg] (default 0): ');
if isempty(CD)
   CD = 0;
end

CD    = CD * pi/180;

clc
disp(' ');
disp('VOR parameters initialized');
disp(' ');


%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004.  
%-----------------------------------------------------------------------