function [Ktheta,Kq,Ki_1,Kphi,Kr,dar,drr,Ki_2] = kpahrah(Vref)
% KPAHRAH - sets the gain factors for PAH, RAH, and PAHRAH
%
% This routine defines the gain factors for the pitch and roll 

% attitude hold modes as a function of the airspeed. These systems
% do not contain the complete gain-scheduling functions from the 
% simulation models APILOT1, APILOT2, and APILOT3. The reference
% velocity must be entered as input argument to this function. 
%
% Without input argument, the gains will be determined for an 
% airspeed of 45 m/s.


% The input argument Vref contains the reference velocity for which the
% gains must be computed. If it is empty, the default velocity of 45 m/s
% will be used instead (mean velocity of 'Beaver' flight envelope).
% ----------------------------------------------------------------------
if nargin == 0
   Vref = 45;
end

% Gains for Pitch Attitude Hold mode (no turn-compensation).
% ----------------------------------------------------------
Ktheta = -0.001375*Vref^2 + 0.1575*Vref - 4.8031;
Kq     = -0.000475*Vref^2 + 0.0540*Vref - 1.5931;
Ki_1   =  0.5;

% Gains for Roll Attitude Hold mode.
% ----------------------------------
Kphi   =  0.000975*Vref^2 - 0.108*Vref + 2.335625;
Kr     = -4;
dar    =  0.165;
drr    = -0.000075*Vref^2 + 0.0095*Vref - 0.4606;
Ki_2   =  0.25;


%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------