% The FDC toolbox - Non-linear aircraft models.
% =============================================
% The directory AIRCRAFT contains the non-linear aircraft models and
% the main model-library for the FDC package. The following files are
% included:
%
% BEAVER.MDL   Complete non-linear Simulink model of the De Havilland
%              DHC-2 'Beaver'. When accessing the aircraft model from
%              the Matlab workspace, this system is to be used.
%
% FBUTTONS.MDL Collection of button-blocks from the FDC toolbox.
%
% FDCLIB.MDL   Main FDC library.
%
%    FDCLIB1.MDL   Sublibrary of FDCLIB, contains Airdata blocks.
%    FDCLIB2.MDL   Sublibrary of FDCLIB, contains Aerodynamic model
%                  blocks (currently for the 'Beaver' only).
%    FDCLIB3.MDL   Sublibrary of FDCLIB, contains Engine forces &
%                  moments blocks (currently for the 'Beaver' only).
%    FDCLIB4.MDL   Sublibrary of FDCLIB, contains blocks for forces and
%                  moments due to gravity and non-steady atmosphere.
%    FDCLIB5.MDL   Sublibrary of FDCLIB, contains the general state-
%                  equations of the non-linear aircraft model.
%    FDCLIB6.MDL   Sublibrary of FDCLIB, contains 'additional' output-
%                  equation blocks.
%    FDCLIB7.MDL   Sublibrary of FDCLIB, contains button-blocks for
%                  initializing the non-linear aircraft model.
%    FDCLIB8.MDL   Sublibrary of FDCLIB, contains button-blocks for
%                  starting up trim and linearization routines ACTRIM
%                  and ACLIN.
%    FDCLIB9.MDL   Sublibrary of FDCLIB, contains button-blocks for
%                  post-processing simulation results.
%    FDCLIB10.MDL  Sublibrary of FDCLIB, contains subsystem equivalents
%                  of the system BEAVER.MDL.
%
% MODBUILD.M   Parameter-definition for the Beaver model.
%
% SLBLOCKS.M   Makes the FDC models available in the Simulink library 
%              browser

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------