from docplex.cp.model import logical_and, logical_or



'''Useful functions for z3 equations'''

def rOr(equations:list, pos:int = 0):
    '''Crea un'unica equazione mettendo in Or tra loro tutte le equazione passate.\n
    Args:
        equations (list): lista di equazioni
        pos (int): posizione corrente. Alla prima chiamata deve valere 0.\n
    Returns:
        equazione: equazione data dall'or di tutte le equazioni
    '''
    if pos+1 == len(equations):
        return equations[pos]
    return logical_or(rOr(equations, pos+1), equations[pos])
    
def rAnd(equations:list, pos:int = 0):
    '''Crea un'unica equazione mettendo in And tra loro tutte le equazione passate.\n
    Args:
        equations (list): lista di equazioni
        pos (int): posizione corrente. Alla prima chiamata deve valere 0.\n
    Returns:
        equazione: equazione data dall'and di tutte le equazioni
    '''
    if pos+1 == len(equations):
        return equations[pos]
    return logical_and(rAnd(equations, pos+1), equations[pos])