from customTypes import *
from typing import List, Set, Dict, Tuple

     


class MetaInsegnamento:
    def __init__(self, id:str, ID_INC:str, NumIscritti:int):
        self.id:str = id
        self.ID_INC:str = ID_INC
        self.NumIscritti:int = NumIscritti
    
    def __str__(self):
        return str(self.id) + " - " + str(self.ID_INC)


class Orientamento:
    '''Tiene traccia di tutti gli insegnamenti di un orientamento e del relativo livello di '''
    def __init__(self, orientamento:str, nomeCdl:str, tipoCdl:TipoCdl):
        self.orientamento:str = orientamento
        self.nomeCdl:str = nomeCdl
        self.tipoCdl:TipoCdl = tipoCdl
    
    def __str__(self):
        '''Usato per ricavare un id univoco: orientamento.nomeCdl.tipoCdl
        Compliant con la generazione della chiave in AUX.map_Orientamento_to_IdOrientamento'''
        if self.tipoCdl == TipoCdl.Triennale:
            return self.orientamento + "." + self.nomeCdl + ".Triennale"
        elif self.tipoCdl == TipoCdl.Magistrale:
            return self.orientamento + "." + self.nomeCdl + ".Magistrale"
        return self.orientamento + "." + self.nomeCdl + ".?"
    
    
class Insegnamento:
    '''Contiene i dati di un Insegnamento presi dal db. MetaInsegnamento contiene solo i dati dell'insegnamento
    presi dal file xml in cui è definito l'orario.
    Per ora non carico la tabella Insegnamento_listCodIns'''
    def __init__(self, ID_INC:str, nStudenti:int, nStudentiFreq:int, collegio:str, titolo:str, cfu:str, oreLez:int, 
                 docenteTitolare:str):
        self.ID_INC:str = ID_INC
        self.nStudenti:int = nStudenti
        self.nStudentiFreq:int = nStudentiFreq
        self.collegio:str = collegio
        self.titolo:str = titolo
        self.cfu:str = cfu
        self.oreLez:int = oreLez
        self.docenteTitolare:str = docenteTitolare
        
        self.idDocenteTitolare:int = -1 # settata da AUX
        
    def __str__(self):
        return self.ID_INC + " " + self.titolo