import builder

from Parameter import Parameter
from log import logger


basePath = "D:/Francesco/Scuola/Politecnico/Magistrale/Tesi/tesiAllocatoreCPLEX"
logs = logger()

def computeOptimalSolution():
    '''Abilita tutti i meccanismi di penalità al fine di trovare la soluzione ottima'''
    p1 = Parameter()
    p1.add_folderInsegnamentiXml(basePath + "/data/insegnamenti_xml")
    p1.set_jsonFileDocenti(basePath + "/data/docenti.json")
    p1.set_jsonFileInsegnamenti(basePath + "/data/insegnamenti.json")
    p1.set_fileXmlLocaliAllocati(basePath + "/data/aule.xml")
    p1.set_timeLimitWork(3600*4)
    p1.set_timeLimitTraSolutions(60*5)
    p1.set_nomeSolutions("prova_realloc")
    logs.startCall()
    
    p1.add_optimizeComponent(Parameter.OptimizeComponent.Orientamento)
    p1.add_optimizeComponent(Parameter.OptimizeComponent.Studenti)
    p1.add_optimizeComponent(Parameter.OptimizeComponent.Docenti)
    
    p1.add_additionalModelConfig(Parameter.OptimizeComponent.Docenti)
    p1.add_additionalModelConfig(Parameter.OptimizeComponent.Orientamento)
    p1.add_additionalModelConfig(Parameter.OptimizeComponent.Studenti)    
    
    # debugging        
    # p1.set_sogliaInterestingSol(1.0)
    # p1.nFilesInsegnamenti = 60
    
def computeSubOptimalSolution():
    '''Simile a computeOptimalSolution(). Solo non impongo vincoli ausiliari sulle varie parti di soft constraint (ie non mi interessa
    se la penalità per un Docente sarà superiora alla media, e così via), mi basta puntare a minimizzare la funzione obiettivo.\n
    Potrebbe portare risultati praticamente analoghi a computeOptimalSolution() con meno effort'''  
    p1 = Parameter()
    p1.add_folderInsegnamentiXml(basePath + "/data/insegnamenti_xml")
    p1.set_jsonFileDocenti(basePath + "/data/docenti.json")
    p1.set_jsonFileInsegnamenti(basePath + "/data/insegnamenti.json")
    p1.set_fileXmlLocaliAllocati(basePath + "/data/aule.xml")
    p1.set_timeLimitWork(3600*1)
    p1.set_timeLimitTraSolutions(60*5)
    p1.set_nomeSolutions("prova_subOpt")
    logs.startCall()
    
    p1.set_sabatoEnabled(True)
    p1.set_nSlotSabato(3)
    
    p1.add_optimizeComponent(Parameter.OptimizeComponent.Orientamento)
    p1.add_optimizeComponent(Parameter.OptimizeComponent.Studenti)
    p1.add_optimizeComponent(Parameter.OptimizeComponent.Docenti)    
    
    p1.nFilesInsegnamenti = 60
    p1.set_sogliaInterestingSol(1.0)
    
def checkValiditySolution():
    '''Non viene attivato nessun soft constraint, l'obiettivo è solamente verificare la validità della sol proposta. E' utile in caso
    si voglia mantenere buona parte del modello da una precedente allocazione e predisporre una particolare configurazione per certi 
    Insegnamenti o se si vuole testare la compatibilità di hard constraint diversi'''
    p1 = Parameter()
    p1.add_folderInsegnamentiXml(basePath + "/data/nuovi_XML")
    p1.set_jsonFileDocenti(basePath + "/data/nuovo_docenti.json")
    p1.set_jsonFileInsegnamenti(basePath + "/data/nuovo_insegnamenti.json")
    p1.set_fileXmlLocaliAllocati(basePath + "/data/nuove_aule.xml")
    # p1.set_timeLimitWork(3600*4)
    p1.set_nomeSolutions("test_1")
    logs.startCall()    
    # p1.set_nWorkers(128)
    
    p1.set_sabatoEnabled(True)
    p1.set_nSlotSabato(3)
    
    # no info about penalties
    p1.set_debuggingPenalty(False) # così per default
    p1.set_capienzaAuleExtended(0)
    # p1.nFilesInsegnamenti = 30
    
    # il modellare queste variabili, anche se non verrà applicato nessun constraint su di essi, ha un costo enorme
    # p1.add_additionalModelConfig(Parameter.OptimizeComponent.Docenti)
    # p1.add_additionalModelConfig(Parameter.OptimizeComponent.Orientamento)
    # p1.add_additionalModelConfig(Parameter.OptimizeComponent.Studenti)   
    
    
def keepOldModelWithMinorChanges_optimize():
    '''Uso un piano allocazione precedentemente creato per buona parte degli Insegnamenti, solo alcuni di essi devono essere modificati,
    voglio trovare la soluzione ottima.'''
    p1 = Parameter()
    p1.add_folderInsegnamentiXml(basePath + "/data/insegnamenti_xml")
    p1.set_jsonFileDocenti(basePath + "/data/docenti.json")
    p1.set_jsonFileInsegnamenti(basePath + "/data/insegnamenti.json")
    p1.set_fileXmlLocaliAllocati(basePath + "/data/aule.xml")
    p1.set_timeLimitWork(3600*4)
    p1.set_timeLimitTraSolutions(60*5)
    p1.set_nomeSolutions("prova_realloc")
    logs.startCall()    
    
    p1.add_optimizeComponent(Parameter.OptimizeComponent.Orientamento)
    p1.add_optimizeComponent(Parameter.OptimizeComponent.Studenti)
    p1.add_optimizeComponent(Parameter.OptimizeComponent.Docenti)
    
    p1.add_additionalModelConfig(Parameter.OptimizeComponent.Docenti)
    p1.add_additionalModelConfig(Parameter.OptimizeComponent.Orientamento)
    p1.add_additionalModelConfig(Parameter.OptimizeComponent.Studenti)     
    
    p1.set_usePianoAllocazioneAsBase(True)
    p1.set_pianoAllocazioneBase("callback_prova_8720")
    p1.add_listID_INCToModify([251552,254733,254734,254732])
    
    # debugging        
    p1.set_sogliaInterestingSol(1.0)
    # p1.nFilesInsegnamenti = 60


if __name__ == '__main__':
    checkValiditySolution()
    
    loader = builder.Builder()
    loader.loadModel()
    loader.buildModel()
    loader.solve()
