from datetime import datetime
import sys

from patterns import *
from Parameter import Parameter



class logger(metaclass=SingletonMeta):
    def __init__(self):
        self.PARAM:Parameter = Parameter()
        self.stdout:bool = True
        self.openFiles:bool = False
        self.bufSize:int = 8192
        
    def startCall(self):
        '''Chiamata per aprire i file\n
        DEVE ESSERE FATTA DOPO AVER SETTATO IL NOME DELLA SOLUZIONE'''
        if self.openFiles:
            return
        self.name = self.PARAM.nomeSolutions
        self.log = open(self.name + "_log.txt", mode="w", buffering=self.bufSize, encoding="utf-8")
        self.logRes = open(self.name + "_logRes.txt", mode="w", buffering=self.bufSize, encoding="utf-8")
        self.logProgress = open(self.name + "_logProgress.txt", mode="w", buffering=self.bufSize, encoding="utf-8")
        self.cplexLog = open(self.name + "_logCPLEX.txt", mode="w", buffering=self.bufSize, encoding="utf-8")
        self.logUtils = open(self.name + "_logUtils.txt", mode="w", buffering=self.bufSize, encoding="utf-8")
        self.baseLogRes = open(self.name + "_logBaseRes.txt", mode="w", buffering=self.bufSize, encoding="utf-8")
        self.openFiles = True
        
    def endCall(self):
        '''Chiamata per chiudere i file descriptor dei logs'''
        if not self.openFiles:
            return
        self.log.close()
        self.logRes.close()
        self.logProgress.close()
        self.cplexLog.close()
        self.logUtils.close()
        self.baseLogRes.close()
        self.openFiles = False
    
    def logStdout(self, msg:str):
        '''Chiamata internamente da tutte le chiamate al main logger. Se abilitato fa anche la print su stdout del main logger'''
        if self.stdout:
            print(msg)
            
    def getStr(self, msg) -> str:
        '''ToString()'''
        if type(msg) is str:
            return msg
        return str(msg)
            
    def getTimeLog(self) -> str:
        '''Ritorna il timing di print per il log'''
        now = datetime.now()
        if self.PARAM.modelConfig == Parameter.OptimizeComponent.Nessuno:
            return now.strftime("[%H:%M:%S] ")
        return now.strftime("[%m/%d/%Y, %H:%M:%S] ")
        
    def info_log(self, msg) -> None:
        if not self.openFiles:
            return
        msg = self.getStr(msg)
        self.log.write(self.getTimeLog() + msg + "\n")
        self.log.flush()
        if self.stdout:
            self.logStdout(self.getTimeLog() + msg)
            
    def warning_log(self, msg) -> None:
        if not self.openFiles:
            return
        msg = self.getStr(msg)
        self.log.write(self.getTimeLog() + "WARN " + msg + "\n")
        self.log.flush()
        if self.stdout:
            self.logStdout( self.getTimeLog() + "WARN " + msg)
            
    def error_log(self, msg) -> None:
        if not self.openFiles:
            return
        msg = self.getStr(msg)        
        self.log.write(self.getTimeLog() + "ERR " + msg + "\n")
        self.log.flush()
        if self.stdout:
            self.logStdout(self.getTimeLog() + "ERR " + msg)            
    
    def info_logRes(self, msg) -> None:
        if not self.openFiles:
            return
        msg = self.getStr(msg)        
        self.logRes.write(self.getTimeLog() + msg + "\n")
        self.logRes.flush()
        if self.stdout and (msg.startswith("ERR") or msg.startswith("WARN")):
            self.logStdout(msg)
            
    def info_baseLogRes(self, msg) -> None:
        if not self.openFiles:
            return
        msg = self.getStr(msg)        
        self.baseLogRes.write(self.getTimeLog() + msg + "\n")
        self.baseLogRes.flush()
        if self.stdout and (msg.startswith("ERR") or msg.startswith("WARN")):
            self.logStdout(msg)            
        
    def info_logProgress(self, msg) -> None:
        if not self.openFiles:
            return
        msg = self.getStr(msg)        
        self.logProgress.write(self.getTimeLog() + msg + "\n")
        self.logProgress.flush()
        if self.stdout and (msg.startswith("ERR") or msg.startswith("WARN")):
            self.logStdout(msg)        

    def info_cplexLog(self, msg) -> None:
        if not self.openFiles:
            return
        msg = self.getStr(msg)        
        self.cplexLog.write(self.getTimeLog() + msg + "\n")
        self.cplexLog.flush()
        if self.stdout and (msg.startswith("ERR") or msg.startswith("WARN")):
            self.logStdout(msg)        

    def info_logUtils(self, msg) -> None:
        if not self.openFiles:
            return
        msg = self.getStr(msg)        
        self.logUtils.write(self.getTimeLog() + msg + "\n")
        self.logUtils.flush()
        if self.stdout:
            self.logStdout(self.getTimeLog() + msg)        