import requests
import dbAPI



db = dbAPI.dbAPI()

# Modulo usato per ottenere il numero di studenti iscritti ad un dato Insegnamento

uri = "https://didattica.polito.it/pls/portal30/esami.superi.grafico?p_cod_ins=02GOLOV&p_a_acc=2022"
uri_base = "https://didattica.polito.it/pls/portal30/esami.superi.grafico"


def update_Insegnamenti_addNumStudenti(verbose = False):
    for ins in db.get_Insegnamenti_withListCodIns():
        if ins[1] == '?' or ins[3] != 0:
            continue
        
        payload = {'p_cod_ins': ins[1], 'p_a_acc': '2022'}
        r = requests.get(uri_base, params=payload)
        
        for line in r.text.split('\n'):    
            if "Totale iscritti:" in line:
                # print(line)
                try:
                    docente = line[line.find('<b>')+len('<b>'):line.find('</b>')].title()
                    iscritti = int(line[line.find('Totale iscritti: ')+len('Totale iscritti: '):line.find('(')-1])
                    iscrittiPrimaVolta = int(line[line.find('(')+1:line.find(')')])
                except:
                    # print('error parsing line:')
                    # print(line)
                    try:
                        docente = line[line.find('<b>')+len('<b>'):line.find('</b>')].title()
                        iscritti = int(line[line.find('Totale iscritti: ')+len('Totale iscritti: '):line.find('(',line.find('(')+1)-1])
                        iscrittiPrimaVolta = int(line[line.find('(',line.find('(')+1)+1:line.find(')',line.find(')')+1)])
                    except:
                        print('fatal error')
                        print(line)
                    else:
                        if verbose:
                            print('ID_INC: ' + str(ins[0]) + ' titolo: ' + ins[5] + ' cod_ins: ' + ins[1] + ' nStudenti: ' + str(iscritti) + ' nStudentiFreq: ' + str(iscrittiPrimaVolta))
                        db.update_Insegnamenti_setNStudenti(ins[0], int(iscritti), int(iscrittiPrimaVolta))                        
                else:
                    if verbose:
                        print('ID_INC: ' + str(ins[0]) + ' titolo: ' + ins[5] + ' cod_ins: ' + ins[1] + ' nStudenti: ' + str(iscritti) + ' nStudentiFreq: ' + str(iscrittiPrimaVolta))
                    db.update_Insegnamenti_setNStudenti(ins[0], int(iscritti), int(iscrittiPrimaVolta))