from Types import Insegnamento
from queryReader import QueryReader
from dbAPI import dbAPI
from typing import Dict, List, Set
from customTypes import TipoInsegnamento
from getPolito import update_Insegnamenti_addNumStudenti
from dbToolbox import extractInsegnamentiParallelizzabili, db_updateListInsegnamenitInOrientamento_forAllCdl


'''Il target di questo script è popolare il db predendo in input i file del GOF e i dati dal sito del Poli'''


excelFile:QueryReader = QueryReader("D:/Francesco/Scuola/Politecnico/Magistrale/Tesi/sources/2023/2023_Ins pd1_ICM_ETF_orari_estratto__V3.xlsx")
db:dbAPI = dbAPI()

writeDb:bool = True

if writeDb:
    print("delete all")
    db.delete_ALLForImportFromExcel()

# lettura excel
print("read query")
excelFile.readQuery()

excelFile.filter_PD_1()
excelFile.filter_primoAnnoTriennale()
excelFile.split_ID_INC_duplicates()

if writeDb:
    # Corso di Laurea
    print("insert cdl")
    excelFile.db_insertCdl(True)
    # Orientamenti
    print("insert Orientamenti")
    excelFile.db_insertOrientamenti(True)
    # Docenti
    print("insert Docenti")
    excelFile.db_insertDocenti(True)

# lista filtrata ma con tutti gl Item per ogni ID_INC
listInsegnamenti:List[Insegnamento] = excelFile.listInsegnamenti

if writeDb:
    # Insegnamento 1) (no nStudenti)
    # listNoDupInsegnamenti per insert in Insegnamento
    print("insert Insegnamenti 1)")
    listNoDupInsegnamento:List[Insegnamento] = excelFile.listInsegnamentiNoDup
    for ins in listNoDupInsegnamento:
        db.add_Insegnamento(int(ins.ID_INC),ins.numIscritti,ins.numIscritti,ins.id_collegio,ins.titolo,ins.cfu,0,ins.titolare)
        
    # Insegnamento speciale 1° anno
    db.add_Insegnamento(-1, -1, -1, "", "Insegnamenti Primo Anno", 0, 0, "Docente titolare")
    db.add_Insegnamento(-2, -1, -1, "", "Gestionle", 0, 0, "Docente titolare1")
    db.add_Insegnamento(-3, -1, -1, "", "Data Analisys And Art Int", 0, 0, "Docente titolare2")

        
    # Insegnamento_listCodIns
    print("insert Insegnamento_listCodIns")
    mapID_INC_codIns:Dict[int,Set[str]] = excelFile.createCodInsUnique()
    for ID_INC in mapID_INC_codIns.keys():        
        for codIns in mapID_INC_codIns[ID_INC]:
            db.add_Insegnamento_codIns(ID_INC, codIns)

    # Docente_in_Insegnamento
    print("insert Docente_inInsegnamento")
    for ins in listNoDupInsegnamento:
        for docente in ins.docenti:
            if docente in ["DOCENTE", "Docente"]:
                continue
            db.add_DocenteInInsegnamento(docente, ins.ID_INC)

    # Insegnamento_in_Orientamento 1) (no nStudenti-non ci sono i dati, no tipoInsegnamento)
    print("insert Insegnamento_in_Orientamento 1)")
    listInsOrientamenti:Dict[str,Insegnamento] = excelFile.createOrientamentiUnique()
    for ins in listInsOrientamenti.keys():
        cdl = ins.split('_')[1]
        ID_INC = int(ins.split('_')[0])
        orient = ins.split('_')[2]
        db.add_InsegnamentoInOrientamento(ID_INC, orient, cdl, TipoInsegnamento.Sconosciuto, listInsOrientamenti[ins].tipo_laurea, 
                                        listInsOrientamenti[ins].pd, 0, listInsOrientamenti[ins].numAlfabetica, False)
    db.commit()

    # Insegnamento 2) nStudenti
    print("insert Insegnamenti 2) num studenti")
    update_Insegnamenti_addNumStudenti(False)
    
    # Insegnamento 3) info puntuali
    db.update_Insegnamento_setTitolare(259688, "Colet Cristina")
    db.update_Insegnamento_setTitolare(259401, "Punta Elisabetta")
    db.update_Insegnamento_setTitolare(260109, "Gay Nicoletta")
    db.update_Insegnamento_setTitolare(262447, "Zunino Claudio")
    # 262447 tit: Zunino Claudio || Rottondi Cristina Emma Margherita
    db.update_Insegnamento_setTitolare(260184, "Rizzo Giuseppe")
    

    # Insegnamento_in_Orientamento 2) (+ tipoInsegnamento)
    print("insert InsegnamentoInOrientamento 2) tipoIns")
    db_updateListInsegnamenitInOrientamento_forAllCdl()

# list Insegnamenti obbligatori_a_scelta in oppure
extractInsegnamentiParallelizzabili()

# list Docenti titolari && list titolo Insegnamenti
listInsegnamenti = db.get_Insegnamenti()
s = str(set(map(lambda ins: ins[4], listInsegnamenti)))
s = s.replace("[","")
s = s.replace("]","")
s = s.replace("\'","")
s = s.replace("\n","")
s = s.replace(",","|")
print(s)
s = str(set(map(lambda ins: ins[7], listInsegnamenti)))
s = s.replace("[","")
s = s.replace("]","")
s = s.replace("\'","")
s = s.replace("\n","")
s = s.replace(",","|")
print(s)
