from enum import Enum
from typing import Dict

from log import logger


log = logger()

class TipoPenalty(Enum):
    Studente = 0
    Docente = 1
    Orientamento = 2
    


# DA CONFIGURARE
def getAvgPenaltyDocente(docente:str = "DocenteGlobale") -> float:
    '''Ritorna la penalità media assegnabile ad un Docente specifico (nel caso venga speficicato un nome di docente valido) else
    ritorna una penalità generale'''
    dizPenalty:Dict[str,float] = dict()
    dizPenalty["Docente"] = 5.0 # si riferisce alle penalità media di un singolo docente
    dizPenalty["DocenteGlobale"] = 3.5

    # store data
    dizPenalty["Cumani"] = 0
    
    if docente not in dizPenalty.keys():
        return dizPenalty["Docente"]
    return dizPenalty[docente]
    
def getAvgPenaltyStudente(orientamento:str = "Orientamento") -> float:
    '''Ritorna la penalità media assegnabile alle penalità lato Studente (eg slot consecutivi, buchi nell'Orario, ..) 
    (nel caso venga specificato un nome di Orientamento valido) else ritorna una penalità generale'''
    dizPenalty:Dict[str,float] = dict()
    dizPenalty["Orientamento"] = 3.0
    # store data
    
    if orientamento not in dizPenalty.keys():
        return dizPenalty["Orientamento"]
    return dizPenalty[orientamento]

def getAvgPenaltyOrientamenti() -> float:
    '''La penalità media assegnabile alle penalità dal punto di vista del sovrapporsi di Insegnamenti vari (eg: Crediti Liberi)'''
    return 5.0
    

def getPenaltyConstant(tipoPenalty:TipoPenalty) -> int:
    '''Per definire una gerarchia tra i vari tipi di Penalità. Da chiamare ogni volta si trasforma il valore simbolico della penalità
    in quello numerico di inserire nel modello CPLEX.\n
    Configurare costanti qui dentro'''
    if tipoPenalty == TipoPenalty.Docente:
        return 2
    if tipoPenalty == TipoPenalty.Studente:
        return 1
    if tipoPenalty == TipoPenalty.Orientamento:
        return 3
    log.error_log("rulePenalty.getPenaltyConstant(): TipoPenalty sconosciuto")
    return 0




class LV_Penalties(Enum):
    LV_H = -1
    LV_0 = 0
    LV_1 = 1
    LV_2 = 2
    LV_3 = 3
    LV_4 = 4
    LV_5 = 5
    LV_6 = 6
    LV_MAX = 7
    
def getLV_PenaltiesFromString(lv:str):
    if lv == "LVH":
        return LV_Penalties.LV_H
    if lv == "LV0":
        return LV_Penalties.LV_0
    if lv == "LV1":
        return LV_Penalties.LV_1
    if lv == "LV2":
        return LV_Penalties.LV_2
    if lv == "LV3":
        return LV_Penalties.LV_3
    if lv == "LV4":
        return LV_Penalties.LV_4
    if lv == "LV5":
        return LV_Penalties.LV_5
    if lv == "LV6":
        return LV_Penalties.LV_6
    log.warning_log("rulePenalty.getLV_PenaltiesFromString(): lv sconosciuto")
    return LV_Penalties.LV_MAX
    
def getIntFromLV_Penalties(lv:LV_Penalties, tipoPenalty:TipoPenalty) -> int:
    if lv == LV_Penalties.LV_0:
        return 0*getPenaltyConstant(tipoPenalty)
    if lv == LV_Penalties.LV_1:
        return 1*getPenaltyConstant(tipoPenalty)
    if lv == LV_Penalties.LV_2:
        return 2*getPenaltyConstant(tipoPenalty)
    if lv == LV_Penalties.LV_3:
        return 3*getPenaltyConstant(tipoPenalty)
    if lv == LV_Penalties.LV_4:
        return 4*getPenaltyConstant(tipoPenalty)
    if lv == LV_Penalties.LV_5:
        return 5*getPenaltyConstant(tipoPenalty)
    if lv == LV_Penalties.LV_6:
        return 6*getPenaltyConstant(tipoPenalty)
    if lv == LV_Penalties.LV_MAX:
        return 7*getPenaltyConstant(tipoPenalty)
    log.warning_log("rulePenalty.getIntFromLV_Penalties(): level sconosciuto")
    return 0