from typing import List

from auxiliary import AuxiliaryStruct
from dbAPI import dbAPI
from templates import Orientamento
from customTypes import TipoCdl
from log import logger
from patterns import *



class OrientamentoHandler(metaclass=SingletonMeta):
    '''Carica dal db la lista degli Orientamenti
    
    Params:
        aux (AuxiliaryStruct): classe gestore delle risorse ausiliarie per il modelllo
        dbAPI (dbAPI): classe con le API per leggere il db'''
    def __init__(self, filtering:bool = True):
        self.AUX:AuxiliaryStruct = AuxiliaryStruct()
        self.dbAPI:dbAPI = dbAPI()
        self.log:logger = logger()
        
        self.orientamentiLoaded:bool = False
        self.endLoaded:bool = False
        self.filtering:bool = filtering
        
    def loadOrientamenti(self) -> None:
        '''Caricamento di tutti gli Orientamenti presenti nel db'''
        if self.endLoaded:
            self.log.error_log("OrientamentoHandler.loadOrientamenti(): caricamento già concluso")
            return
        for row in self.dbAPI.get_Orientamenti_withInsegnamenti():
            self.loadOrientamento(row)
        self.AUX.endlist_Orientamenti()
        self.endLoaded = True    
        
    def loadOrientamento(self, rowOrient):
        '''Parsing dell'Orientamento + caricamento in AUX + filtering Orientamenti inutili'''
        # filering degli Orientamenti
        if self.filtering:
            if "Mondovì" in rowOrient[0]: # sono uguali agli Orientamenti normali, solo il primo anno (che non mi interessa) è a Mondovì
                return
            if "Talenti" in rowOrient[0]:
                return
            if "INTRAPRENDENTI" in rowOrient[0]:
                return
            if "Primo anno erogato in italiano" == rowOrient[0]:
                return
            if "Shanghai" in rowOrient[0]:
                return
            if "Introductory year taught in English" == rowOrient[0]:
                return
            if "Eurecom" in rowOrient[0]:
                return
        
        if rowOrient[2] == '1':
            orient = Orientamento(rowOrient[0], rowOrient[1], TipoCdl.Triennale)
        elif rowOrient[2] == 'Z':
            orient = Orientamento(rowOrient[0], rowOrient[1], TipoCdl.Magistrale)
        else:
            self.log.error_log("OrientamentoHandler.loadOrientamento(): tipoCdl sconosciuto")
        self.AUX.add_OrientamentoToList(orient)
        