import glob
import math
import os
import random

import cv2
import datetime
import json

from tqdm import tqdm

class Point():
    def __init__(self, x, y):
        self.x = x
        self.y = y


def GetAreaOfPolyGon(points_x, points_y):
    points = []
    for index in range(len(points_x)):
        points.append(Point(points_x[index], points_y[index]))
    area = 0
    if (len(points) < 3):
        raise Exception("error")

    p1 = points[0]
    for i in range(1, len(points) - 1):
        p2 = points[1]
        p3 = points[2]

        vecp1p2 = Point(p2.x - p1.x, p2.y - p1.y)
        vecp2p3 = Point(p3.x - p2.x, p3.y - p2.y)

        vecMult = vecp1p2.x * vecp2p3.y - vecp1p2.y * vecp2p3.x
        sign = 0
        if (vecMult > 0):
            sign = 1
        elif (vecMult < 0):
            sign = -1

        triArea = GetAreaOfTriangle(p1, p2, p3) * sign
        area += triArea
    return abs(area)


def GetAreaOfTriangle(p1, p2, p3):
    area = 0
    p1p2 = GetLineLength(p1, p2)
    p2p3 = GetLineLength(p2, p3)
    p3p1 = GetLineLength(p3, p1)
    s = (p1p2 + p2p3 + p3p1) / 2
    area = s * (s - p1p2) * (s - p2p3) * (s - p3p1)
    area = math.sqrt(area)
    return area


def GetLineLength(p1, p2):
    length = math.pow((p1.x - p2.x), 2) + math.pow((p1.y - p2.y), 2)
    length = math.sqrt(length)
    return length


def create_image_info(image_id, file_name, image_size,
                      date_captured='',
                      license_id=1, coco_url="", flickr_url=""):
    image_info = {
        "id": image_id,
        "file_name": file_name,
        "width": image_size[0],
        "height": image_size[1],
        "date_captured": date_captured,
        "license": license_id,
        "coco_url": coco_url,
        "flickr_url": flickr_url
    }

    return image_info


def create_annotation_info(annotation_id, image_id, category_id, is_crowd,
                           area, bounding_box, segmentation):
    annotation_info = {
        "id": annotation_id,
        "image_id": image_id,
        "category_id": category_id,
        "iscrowd": is_crowd,
        "area": area,  # float
        "bbox": bounding_box,  # [x,y,width,height]
        "segmentation": segmentation  # [polygon]
    }

    return annotation_info


def get_segmenation(coord_x, coord_y):
    seg = []
    for x, y in zip(coord_x, coord_y):
        seg.append(x)
        seg.append(y)
    return [seg]


def convert(img_ann_dir, sub='train'):
    coco_output = {}
    coco_output['info'] = {
        "description": "coco Dataset",
        "url": "",
        "version": "0.1.0",
        "year": 2017,
        "contributor": "",
        "date_created": ''
    }
    coco_output['licenses'] = [
        {
            "id": 1,
            "name": " ",
            "url": " "
        }
    ]
    coco_output['categories'] = [
        {
            'id': 1,
            'name': 'glass',
            'supercategory': 'bone',
        },
        {
            'id': 2,
            'name': 'metal',
            'supercategory': 'bone',
        },
        {
            'id': 3,
            'name': 'paper',
            'supercategory': 'bone',
        },
        {
            'id': 4,
            'name': 'plastic',
            'supercategory': 'bone',
        },
        {
            'id': 5,
            'name': 'trash',
            'supercategory': 'bone',
        },
        {
            'id': 6,
            'name': 'compost',
            'supercategory': 'bone',
        },
    ]
    coco_output['images'] = []
    coco_output['annotations'] = []

    sub_datas = os.listdir(img_ann_dir)
    ann_id = 0
    cat_ids = []
    save_img_dir = 'datasets/images'
    os.makedirs(save_img_dir,exist_ok=True)

    for dir_name in tqdm(sub_datas, total=len(sub_datas)):
        imgdir = os.path.join(img_ann_dir, dir_name)
        if not os.path.isdir(imgdir):
            continue
        annpath = glob.glob(os.path.join(imgdir, '*.json'))[0]

        annotations = json.load(open(annpath))
        ann = list(annotations.values())[1]
        data_numbers = len(ann)
        train_num = int(data_numbers * 0.8)
        random.seed(12)
        anns = list(ann.keys())
        random.shuffle(anns)

        anns = anns[:train_num] if sub == 'train' else anns[train_num:]
        # annotations id start from zero
        # in VIA annotations, keys are image name
        for img_id, key in enumerate(anns):
            filename = ann[key]['filename']
            file_path = os.path.join(imgdir, filename)
            img = cv2.imread(file_path)
            # make image info and storage it in coco_output['images']
            image_info = create_image_info(img_id, os.path.basename(filename), img.shape[:2])
            coco_output['images'].append(image_info)
            regions = ann[key]["regions"]
            # for one image ,there are many regions,they share the same img id
            for region in regions:
                try:
                    cat_id = int(region['region_attributes']['category_id'])+1
                except:
                    continue
                cat_ids.append(cat_id)
                iscrowd = 0
                points_x = region['shape_attributes']['all_points_x']
                points_y = region['shape_attributes']['all_points_y']
                area = GetAreaOfPolyGon(points_x, points_y)
                min_x = min(points_x)
                max_x = max(points_x)
                min_y = min(points_y)
                max_y = max(points_y)
                box = [min_x, min_y, max_x - min_x, max_y - min_y]
                segmentation = get_segmenation(points_x, points_y)
                # make annotations info and storage it in coco_output['annotations']
                ann_info = create_annotation_info(ann_id, img_id, cat_id, iscrowd, area, box, segmentation)
                coco_output['annotations'].append(ann_info)
                ann_id = ann_id + 1
            cv2.imwrite(os.path.join(save_img_dir,filename),img)

    print(set(cat_ids))
    save_name = os.path.join(os.path.dirname(save_img_dir), 'instances_train2017.json' if sub == 'train' else 'instances_val2017.json')

    with open(save_name, 'w', encoding='utf-8') as f:
        json.dump(coco_output, f)


if __name__ == '__main__':
    img_ann_dir = '../Dataset'
    convert(img_ann_dir, sub='train')
    convert(img_ann_dir, sub='test')
