[#ftl]
/**
 ******************************************************************************
 * @file    custom_tof_conf.h
 * @author  IMG SW Application Team
 * @brief   This file contains definitions of the TOF components bus interfaces
 *          for custom boards
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) ${year} STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

[#assign IpInstance = ""]
[#assign IpName = ""]

[#assign vl53l3cx_i2c_instance = ""]
[#assign vl53l3cx_xshut_port = ""]
[#assign vl53l3cx_xshut_pin = ""]

[#assign vl53l5cx_i2c_instance = ""]
[#assign vl53l5cx_pwr_en_port = ""]
[#assign vl53l5cx_pwr_en_pin = ""]
[#assign vl53l5cx_i2c_rst_port = ""]
[#assign vl53l5cx_i2c_rst_pin = ""]
[#assign vl53l5cx_lpn_port = ""]
[#assign vl53l5cx_lpn_pin = ""]

[#if BspIpDatas??]
  [#list BspIpDatas as SWIP]
    [#if SWIP.defines??]
      [#if SWIP.variables??]
        [#list SWIP.variables as variables]
          [#if variables.name?contains("IpInstance")]
            [#assign IpInstance = variables.value]
          [/#if]
          [#if variables.name?contains("IpName")]
            [#assign IpName = variables.value]
          [/#if]
          [#if variables.value?contains("VL53L3CX BUS IO driver")]
            [#assign vl53l3cx_i2c_instance = IpInstance]
          [/#if]
          [#if variables.value?contains("VL53L5CX BUS IO driver")]
            [#assign vl53l5cx_i2c_instance = IpInstance]
          [/#if]
          [#if variables.value?contains("VL53L3CX_XSHUT")]
            [#assign vl53l3cx_xshut_port = IpName]
            [#assign vl53l3cx_xshut_pin = IpInstance]
          [/#if]
          [#if variables.value?contains("VL53L5CX_PWR_EN")]
            [#assign vl53l5cx_pwr_en_port = IpName]
            [#assign vl53l5cx_pwr_en_pin = IpInstance]
          [/#if]
          [#if variables.value?contains("VL53L5CX_I2C_RST")]
            [#assign vl53l5cx_i2c_rst_port = IpName]
            [#assign vl53l5cx_i2c_rst_pin = IpInstance]
          [/#if]
          [#if variables.value?contains("VL53L5CX_LPn")]
            [#assign vl53l5cx_lpn_port = IpName]
            [#assign vl53l5cx_lpn_pin = IpInstance]
          [/#if]
        [/#list]
      [/#if]
    [/#if]
  [/#list]
[/#if]

[#assign useVL53L3CX = false]
[#assign useVL53L5CX = false]

[#if RTEdatas??]
[#list RTEdatas as define]

[#if define?contains("VL53L3CX")]
[#assign useVL53L3CX = true]
[/#if]
[#if define?contains("VL53L5CX")]
[#assign useVL53L5CX = true]
[/#if]

[/#list]
[/#if]

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __CUSTOM_TOF_CONF_H__
#define __CUSTOM_TOF_CONF_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "${FamilyName?lower_case}xx_hal.h"
#include "${BoardName}_bus.h"
#include "${BoardName}_errno.h"

/* USER CODE BEGIN 1 */

/* USER CODE END 1 */

[#if useVL53L3CX]
#define USE_CUSTOM_RANGING_VL53L3CX (1U)
[/#if]
[#if useVL53L5CX]
#define USE_CUSTOM_RANGING_VL53L5CX (1U)
[/#if]

[#if vl53l3cx_xshut_port != "" && vl53l3cx_xshut_pin != ""]
#define CUSTOM_VL53L3CX_XSHUT_PORT    ${vl53l3cx_xshut_port}
#define CUSTOM_VL53L3CX_XSHUT_PIN     ${vl53l3cx_xshut_pin}
[/#if]

[#if vl53l3cx_i2c_instance != ""]
#define CUSTOM_VL53L3CX_I2C_Init      BSP_${vl53l3cx_i2c_instance}_Init
#define CUSTOM_VL53L3CX_I2C_DeInit    BSP_${vl53l3cx_i2c_instance}_DeInit
#define CUSTOM_VL53L3CX_I2C_WriteReg  BSP_${vl53l3cx_i2c_instance}_Send
#define CUSTOM_VL53L3CX_I2C_ReadReg   BSP_${vl53l3cx_i2c_instance}_Recv
[/#if]

[#if vl53l5cx_pwr_en_port != "" && vl53l5cx_pwr_en_pin != ""]
#define CUSTOM_VL53L5CX_PWR_EN_PORT    ${vl53l5cx_pwr_en_port}
#define CUSTOM_VL53L5CX_PWR_EN_PIN     ${vl53l5cx_pwr_en_pin}
[/#if]

[#if vl53l5cx_i2c_rst_port != "" && vl53l5cx_i2c_rst_pin != ""]
#define CUSTOM_VL53L5CX_I2C_RST_PORT    ${vl53l5cx_i2c_rst_port}
#define CUSTOM_VL53L5CX_I2C_RST_PIN     ${vl53l5cx_i2c_rst_pin}
[/#if]

[#if vl53l5cx_lpn_port != "" && vl53l5cx_lpn_pin != ""]
#define CUSTOM_VL53L5CX_LPn_PORT    ${vl53l5cx_lpn_port}
#define CUSTOM_VL53L5CX_LPn_PIN     ${vl53l5cx_lpn_pin}
[/#if]

[#if vl53l5cx_i2c_instance != ""]
#define CUSTOM_VL53L5CX_I2C_Init      BSP_${vl53l5cx_i2c_instance}_Init
#define CUSTOM_VL53L5CX_I2C_DeInit    BSP_${vl53l5cx_i2c_instance}_DeInit
#define CUSTOM_VL53L5CX_I2C_WriteReg  BSP_${vl53l5cx_i2c_instance}_WriteReg16
#define CUSTOM_VL53L5CX_I2C_ReadReg   BSP_${vl53l5cx_i2c_instance}_ReadReg16
[/#if]

#ifdef __cplusplus
}
#endif

#endif /* __CUSTOM_TOF_CONF_H__*/

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/