[#ftl]
#include "53l5a1_ranging_sensor.h"
#include "app_tof_pin_conf.h"
#include "${BoardName}.h"

/* Private typedef -----------------------------------------------------------*/

/* Private define ------------------------------------------------------------*/
#define POLLING_PERIOD (1000U) /* milliseconds */

/* Private variables ---------------------------------------------------------*/
static RANGING_SENSOR_ProfileConfig_t Profile;
static int32_t status = 0;
static uint8_t ToF_Present[RANGING_SENSOR_INSTANCES_NBR] = {0};
volatile uint8_t ToF_EventDetected = 0;

static const char *TofDevStr[] =
{
  [VL53L5A1_DEV_LEFT] = "LEFT",
  [VL53L5A1_DEV_CENTER] = "CENTER",
  [VL53L5A1_DEV_RIGHT] = "RIGHT"
};

/* Private function prototypes -----------------------------------------------*/
static void MX_53L5A1_MultiSensorRanging_Init(void);
static void MX_53L5A1_MultiSensorRanging_Process(void);

static void print_result(RANGING_SENSOR_Result_t *Result);
static void write_lowpower_pin(uint8_t device, GPIO_PinState pin_state);
static void reset_all_sensors(void);