[#ftl]

[#assign IpInstance = ""]
[#assign IpName = ""]
[#assign VL53L3A2I2CInstance = ""]

[#list BspIpDatas as SWIP]
  [#if SWIP.variables??]
    [#list SWIP.variables as variables]
      [#if variables.name?contains("IpInstance")]
        [#assign IpInstance = variables.value]
      [/#if]
      [#if variables.name?contains("IpName")]
        [#assign IpName = variables.value]
      [/#if]
      [#if variables.value?contains("53L3A2 BUS IO driver")]
        [#assign VL53L3A2I2CInstance = IpInstance]
      [/#if]
    [/#list]
  [/#if]
[/#list]

/**
 ******************************************************************************
 * @file    53l3a2_conf.h
 * @author  IMG SW Application Team
 * @brief   This file contains definitions for the ToF components bus interfaces
 *          when using the X-NUCLEO-53L3A2 expansion board
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) ${year} STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef VL53L3A2_CONF_H
#define VL53L3A2_CONF_H

#include "${FamilyName?lower_case}xx_hal.h"
#include "${BoardName}_bus.h"
#include "${BoardName}_errno.h"

#ifdef __cplusplus
extern "C" {
#endif

/* USER CODE BEGIN 1 */

/* USER CODE END 1 */

/* 
 * the 53L3A2 BSP driver uses this symbol to allocate a structure for each device
 * if you are only using the on-board sensor without break-out boards
 * change its to (1U) in order to save space in RAM memory
 */
#define RANGING_SENSOR_INSTANCES_NBR    (3U)

[#if VL53L3A2I2CInstance != ""]
#define VL53L3A2_hi2c                   (h${VL53L3A2I2CInstance?lower_case})

#define VL53L3A2_I2C_SCL_GPIO_PORT      BUS_${VL53L3A2I2CInstance}_SCL_GPIO_PORT
#define VL53L3A2_I2C_SCL_GPIO_PIN       BUS_${VL53L3A2I2CInstance}_SCL_GPIO_PIN
#define VL53L3A2_I2C_SDA_GPIO_PORT      BUS_${VL53L3A2I2CInstance}_SDA_GPIO_PORT
#define VL53L3A2_I2C_SDA_GPIO_PIN       BUS_${VL53L3A2I2CInstance}_SDA_GPIO_PIN

#define VL53L3A2_I2C_Init               BSP_${VL53L3A2I2CInstance}_Init
#define VL53L3A2_I2C_DeInit             BSP_${VL53L3A2I2CInstance}_DeInit
#define VL53L3A2_I2C_WriteReg           BSP_${VL53L3A2I2CInstance}_Send
#define VL53L3A2_I2C_ReadReg            BSP_${VL53L3A2I2CInstance}_Recv
#define VL53L3A2_GetTick                BSP_GetTick
[/#if]

#ifdef __cplusplus
}
#endif

#endif /* VL53L3A2_CONF_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
