---
pagetitle: Release Notes for X-CUBE-TOF1 Software Pack for STM32
lang: en
header-includes: <link rel="icon" type="image/x-icon" href="_htmresc/favicon.png" />
---

::: {.row}
::: {.col-sm-12 .col-lg-4}

<center>
# Release Notes for <mark>X-CUBE-TOF1</mark> Software Pack for STM32
Copyright &copy; 2021 STMicroelectronics\

[![ST logo](_htmresc/st_logo_2020.png)](https://www.st.com){.logo}
</center>

# License

This software package is licensed by ST under SLA0081, the "License"; You may not use this component except in compliance
with the License. You may obtain a copy of the License at:

[SLA0081: SOFTWARE LICENSE AGREEMENT](https://www.st.com/content/ccc/resource/legal/legal_agreement/license_agreement/group0/66/1f/44/82/6c/95/4f/69/DM00484327/files/DM00484327.pdf/jcr:content/translations/en.DM00484327.pdf)

# Purpose

The **X-CUBE-TOF1** software pack is an expansion software package for **STM32Cube** that aims to ease the development of applications with ST Time-of-Flight sensors. This software gathers ranging sensor drivers for VL53L3CX and VL53L5CX running on STM32. The source code of this package is based on STM32Cube to ease portability and code sharing across different STM32 MCU families.

![The X-CUBE-TOF1 package contents](_htmresc/xcubetof1-arch.png)\

Here is the list of references:

- [X-NUCLEO-53L3A2: Multi-targets ranging sensor expansion board based on VL53L3CX for STM32 Nucleo](https://www.st.com/content/st_com/en/products/ecosystems/stm32-open-development-environment/stm32-nucleo-expansion-boards/stm32-ode-sense-hw/x-nucleo-53l3a2.html)
- [VL53L3CX: Time-of-Flight ranging sensor with multi target detection](https://www.st.com/content/st_com/en/products/imaging-and-photonics-solutions/proximity-sensors/vl53l3cx.html)
- [VL53L3CX-SATEL: Breakout board with VL53L3CX multi-target detection](https://www.st.com/content/st_com/en/products/evaluation-tools/product-evaluation-tools/proximity-sensors-and-imaging-ics-eval-boards/vl53l3cx-satel.html)
- [X-NUCLEO-53L5A1: 8x8 multizone with wide field of view ranging sensor expansion board based on VL53L5CX for STM32 Nucleo](https://www.st.com/content/st_com/en/products/evaluation-tools/product-evaluation-tools/imaging-evaluation-boards/x-nucleo-53l5a1.html)
- [VL53L5CX: Time-of-Flight 8x8 multizone ranging sensor with wide field of view](https://www.st.com/content/st_com/en/products/imaging-and-photonics-solutions/time-of-flight-sensors/vl53l5cx.html)
- [VL53L5CX-SATEL: Breakout board for VL53L5CX](https://www.st.com/content/st_com/en/products/evaluation-tools/product-evaluation-tools/imaging-evaluation-boards/vl53l5cx-satel.html)

:::

::: {.col-sm-12 .col-lg-8}
# Update history

::: {.collapse}
<input type="checkbox" id="collapse-section2" checked aria-hidden="true">
<label for="collapse-section2" aria-hidden="true">__V2.0.0 / July 1st 2021__</label>
<div>

## Main changes

### Product Update

- Add X-NUCLEO-53L5A1 BSP v1.0.0
- Add VL53L5CX BSP Component v1.0.0
- Add 53L5A1_MultiSensorRanging, 53L5A1_SimpleRanging and 53L5A1_ThresholdDetection sample applications

- Update X-NUCLEO-53L3A2 BSP to v2.0.0 
- Update VL53L3CX BSP Component to v2.0.0

## Contents

<small>The components flagged by "[]{.icon-st-update}" have changed since the
previous release. "[]{.icon-st-add}" are new.</small>

Components

  Name                                                        Version                                           License                                                                                                       Release note
  ----------------------------------------------------------- ------------------------------------------------- ------------------------------------------------------------------------------------------------------------- ------------------------------------------------------------------------------------------------------------------------------------------------
  **X-NUCLEO-53L3A2 BSP Driver**                                            V2.0.0[]{.icon-st-update}                        [BSD 3-Clause](https://opensource.org/licenses/BSD-3-Clause)                                                  [release note URL](./Drivers/BSP/53L3A2/Release_notes.html)
  **VL53L3CX BSP Component**                                                V2.0.0[]{.icon-st-update}                        [BSD 3-Clause](https://opensource.org/licenses/BSD-3-Clause)                                                  [release note URL](./Drivers/BSP/Components/vl53l3cx/Release_notes.html)
  **X-NUCLEO-53L5A1 BSP Driver**                                            V1.0.0[]{.icon-st-add}                        [BSD 3-Clause](https://opensource.org/licenses/BSD-3-Clause)                                                  [release note URL](./Drivers/BSP/53L5A1/Release_notes.html)
  **VL53L5CX BSP Component**                                                V1.0.0[]{.icon-st-add}                        [BSD 3-Clause](https://opensource.org/licenses/BSD-3-Clause)                                                  [release note URL](./Drivers/BSP/Components/vl53l5cx/Release_notes.html)
  **53L3A2_MultiSensorRanging Example**                                     V1.0.0[]{.icon-st-update}                        [SLA0044][sla0044]                                                                                       [release note URL](./Projects/NUCLEO-F401RE/Examples/53L3A2/53L3A2_MultiSensorRanging/Release_notes.html)
  **53L3A2_SimpleRanging Example**                                          V1.0.0[]{.icon-st-update}                        [SLA0044][sla0044]                                                                                       [release note URL](./Projects/NUCLEO-F401RE/Examples/53L3A2/53L3A2_SimpleRanging/Release_notes.html)
  **53L5A1_MultiSensorRanging Example**                                     V1.0.0[]{.icon-st-add}                        [SLA0044][sla0044]                                                                                       [release note URL](./Projects/NUCLEO-F401RE/Examples/53L5A1/53L5A1_MultiSensorRanging/Release_notes.html)
  **53L5A1_SimpleRanging Example**                                          V1.0.0[]{.icon-st-add}                        [SLA0044][sla0044]                                                                                       [release note URL](./Projects/NUCLEO-F401RE/Examples/53L5A1/53L5A1_SimpleRanging/Release_notes.html)
  **53L5A1_ThresholdDetection Example**                                     V1.0.0[]{.icon-st-add}                        [SLA0044][sla0044]                                                                                       [release note URL](./Projects/NUCLEO-F401RE/Examples/53L5A1/53L5A1_ThresholdDetection/Release_notes.html)
  **VL53L3CX_SimpleRanging Example**                                        V1.0.0[]{.icon-st-update}                        [SLA0044][sla0044]                                                                                       [release note URL](./Projects/NUCLEO-F401RE/Examples/CUSTOM/VL53L3CX_SimpleRanging/Release_notes.html)
  **VL53L5CX_SimpleRanging Example**                                        V1.0.0[]{.icon-st-add}                        [SLA0044][sla0044]                                                                                       [release note URL](./Projects/NUCLEO-F401RE/Examples/CUSTOM/VL53L5CX_SimpleRanging/Release_notes.html)


Note: in the table above, components **highlighted** have changed since previous release.

[sla0044]: https://www.st.com/content/ccc/resource/legal/legal_agreement/license_agreement/group0/87/0c/3d/ad/0a/ba/44/26/DM00216740/files/DM00216740.pdf/jcr:content/translations/en.DM00216740.pdf

## Known Limitations

  Headline
  ----------------------------------------------------------
  The 53L3A2_MultiSensorRanging sample application doesn't support multi target detection

## Development toolchains and compilers

- IAR System Workbench V8.50.9
- ARM Keil V5.32
- STM32CubeIDE v1.6.1

## Supported devices and boards

- NUCLEO-F401RE MB1136 rev.C
- NUCLEO-L476RG MB1136 rev.C
- VL53L3CX
- VL53L5CX
- X-NUCLEO-53L3A2
- X-NUCLEO-53L5A1
- VL53L3CX-SATEL
- VL53L5CX-SATEL

## Backward compatibility

N/A

## Dependencies

This software release is compatible with:

- STM32CubeHAL F4 V1.7.12
- STM32CubeHAL L4 V1.13.0

</div>
:::

::: {.collapse}
<input type="checkbox" id="collapse-section1" checked aria-hidden="true">
<label for="collapse-section1" aria-hidden="true">__V1.0.0 / March 15th 2021__</label>
<div>

## Main changes

### First release

This is the first release of the **X-CUBE-TOF1**.
This release supports the **X-NUCLEO-53L3A2** and the **VL53L3CX** sensors embedded on it through the BSP ranging sensor class.
The **VL53L3CX-SATEL** board part is also supported through the custom ranging sensor class.

## Contents

<small>The components flagged by "[]{.icon-st-update}" have changed since the
previous release. "[]{.icon-st-add}" are new.</small>

Components

  Name                                                        Version                                           License                                                                                                       Release note
  ----------------------------------------------------------- ------------------------------------------------- ------------------------------------------------------------------------------------------------------------- ------------------------------------------------------------------------------------------------------------------------------------------------
  **X-NUCLEO-53L3A2 BSP Driver**                                            V1.0.0[]{.icon-st-add}                        [BSD 3-Clause](https://opensource.org/licenses/BSD-3-Clause)                                                  [release note URL](./Drivers/BSP/53L3A2/Release_notes.html)
  **VL53L3CX BSP Component**                                                V1.0.0[]{.icon-st-add}                        [BSD 3-Clause](https://opensource.org/licenses/BSD-3-Clause)                                                  [release note URL](./Drivers/BSP/Components/vl53l3cx/Release_notes.html)
  **VL53LX Driver**                                                         V1.2.3[]{.icon-st-add}                        [SLA0081](http://www.st.com/SLA0081)                                                                             [release note URL](.\Release_Notes.html)


Note: in the table above, components **highlighted** have changed since previous release.

## Known Limitations

  Headline
  ----------------------------------------------------------
  No known limitations

## Development toolchains and compilers

- IAR System Workbench V8.50.5
- ARM Keil V5.31
- STM32CubeIDE v1.6.0

## Supported devices and boards

- NUCLEO-F401RE MB1136 rev.C
- NUCLEO-L476RG MB1136 rev.C
- X-NUCLEO-53L3A2
- VL53L3CX-SATEL

## Backward compatibility

N/A

## Dependencies

This software release is compatible with:

- STM32CubeHAL F4 V1.7.11
- STM32CubeHAL L4 V1.13.0

</div>
:::

:::
:::

<footer class="sticky">
::: {.columns}
::: {.column width="95%"}
For complete documentation on **STM32Cube Expansion Packages** ,
visit: [STM32Cube Expansion Packages](https://www.st.com/en/embedded-software/stm32cube-expansion-packages.html)
:::
::: {.column width="5%"}
<abbr title="Based on template cx566953 version 2.0">Info</abbr>
:::
:::
</footer>
