/**
 ******************************************************************************
 * @file    app_tof_pin_conf.h
 * @author  IMG SW Application Team
 * @brief   This file contains definitions for TOF pins
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __APP_TOF_PIN_CONF_H__
#define __APP_TOF_PIN_CONF_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32l4xx_hal.h"

/* Exported symbols ----------------------------------------------------------*/

#define VL53L5A1_PWR_EN_L_PIN   (GPIO_PIN_0)
#define VL53L5A1_PWR_EN_L_PORT  (GPIOA)
#define VL53L5A1_PWR_EN_R_PIN   (GPIO_PIN_0)
#define VL53L5A1_PWR_EN_R_PORT  (GPIOC)
#define VL53L5A1_PWR_EN_C_PIN   (GPIO_PIN_0)
#define VL53L5A1_PWR_EN_C_PORT  (GPIOB)

#define VL53L5A1_LPn_L_PIN   (GPIO_PIN_10)
#define VL53L5A1_LPn_L_PORT  (GPIOB)
#define VL53L5A1_LPn_R_PIN   (GPIO_PIN_5)
#define VL53L5A1_LPn_R_PORT  (GPIOB)
#define VL53L5A1_LPn_C_PIN   (GPIO_PIN_4)
#define VL53L5A1_LPn_C_PORT  (GPIOB)

#define VL53L5A1_I2C_RST_L_PIN   (GPIO_PIN_8)
#define VL53L5A1_I2C_RST_L_PORT  (GPIOA)
#define VL53L5A1_I2C_RST_R_PIN   (GPIO_PIN_9)
#define VL53L5A1_I2C_RST_R_PORT  (GPIOA)
#define VL53L5A1_I2C_RST_C_PIN   (GPIO_PIN_3)
#define VL53L5A1_I2C_RST_C_PORT  (GPIOB)

#ifdef __cplusplus
}
#endif

#endif /* __APP_TOF_PIN_CONF_H__ */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
