/**
  ******************************************************************************
  * @file    53l3a2_conf_template.h
  * @author  IMG SW Application Team
  * @brief   This file contains definitions for the ToF components bus interfaces
  *          when using the X-NUCLEO-53L3A2 expansion board
  *          This file should be copied to the application folder and renamed
  *          to 53l3a2_conf.h.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Replace the header file names with the ones of the target platform */
#include "stm32yyxx_hal.h"
#include "nucleo_xyyyzz_bus.h"
#include "nucleo_xyyyzz_errno.h"

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __53L3A2_CONF_H__
#define __53L3A2_CONF_H__

#ifdef __cplusplus
extern "C" {
#endif

/* USER CODE BEGIN 1 */

/* USER CODE END 1 */
#define RANGING_SENSOR_INSTANCES_NBR    (3U)

#define VL53L3A2_hi2c                   (hi2c1)

#define VL53L3A2_I2C_SCL_GPIO_PORT      BUS_I2C1_SCL_GPIO_PORT
#define VL53L3A2_I2C_SCL_GPIO_PIN       BUS_I2C1_SCL_GPIO_PIN
#define VL53L3A2_I2C_SDA_GPIO_PORT      BUS_I2C1_SDA_GPIO_PORT
#define VL53L3A2_I2C_SDA_GPIO_PIN       BUS_I2C1_SDA_GPIO_PIN

#define VL53L3A2_I2C_Init               BSP_I2C1_Init
#define VL53L3A2_I2C_DeInit             BSP_I2C1_DeInit
#define VL53L3A2_I2C_WriteReg           BSP_I2C1_Send
#define VL53L3A2_I2C_ReadReg            BSP_I2C1_Recv
#define VL53L3A2_GetTick                BSP_GetTick


#ifdef __cplusplus
}
#endif

#endif /* __53L3A2_CONF_H__*/

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/

