# This code is implemented on the top of the pyvicon library and enables easy logging from the Vicon system.
# Author: Vlad Niculescu, vladn@iis.ee.ethz.ch

#from _typeshed import Self
from numpy import array
from pyvicon.pyvicon import *
#from threading import Thread
import math
from datetime import datetime
import sys
import time
import queue
import os
import pickle
from multiprocessing import Process, Queue, Array, Value
import ctypes 
import psutil


#TODO clean Comments 

class ViconLogger(Process):

    time_stamp = Value('i', 0)
    data_logging_en = Value('h', 0)
    latest_pos = Array('d',[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0])  #x,y,z,pos validity flag, qw,qx,qy,qz,quat validity flag
    log_file_name = Array(ctypes.c_char,500 )

    def __init__(self):
        #Thread.__init__(self)
        super(ViconLogger, self).__init__()
        self.ip = "192.168.10.1"
        self.period = 1000/100 #100fps
        self.vicon = []
        self.subjects = ["Drone","Surface",]
        self.data_log = np.array([])
        #self.text = " "
        #self.start()
        #self.position = dict([])
        #self.quaternion = dict([])
        # self.vicon_fifo = queue.Queue()

        #self.t0 = time0
        #self.filename = filename
        # self.time_stamp = 0
        # self.data_ready = 0

    def run(self):
        print("ViconLogger CPUid: "+str(psutil.Process().cpu_num()))
        if(self.connect() == True):
            self.loop() 
        else:
            print("no vicon Data!")
    # def updateTimeStamp(self, time_stamp):
    #     self.time_stamp = time_stamp 

    # def getPosQuat(self):
    #     return [self.position, self.quaternion]

    def connect(self):
        self.vicon = PyVicon()
        print("Vicon Logger Process \tSDK version : {}".format(self.vicon.__version__))
        print(self.vicon.connect(self.ip))
        print("Vicon connection status : {}".format(self.vicon.is_connected()))
        self.vicon.set_stream_mode(StreamMode.ServerPush)
        self.vicon.enable_segment_data()
        self.vicon.enable_marker_data()
        self.vicon.enable_unlabeled_marker_data()
        self.vicon.enable_device_data()
        self.vicon.set_axis_mapping(Direction.Forward, Direction.Left, Direction.Up)
        return self.vicon.is_connected()

    def loop(self):
        while 1:
            if ViconLogger.data_logging_en.value:
                while self.vicon.get_frame() != Result.Success:
                    time.sleep(int(round(self.period / 1000.0)))
                subj_count = self.vicon.get_subject_count()
                for i in range(0, subj_count):
                    name = self.vicon.get_subject_name(i)
                    if name in self.subjects:
                        #timestamp = round(1000 * (datetime.now() - self.t0).total_seconds(), 3)
                        pos = self.vicon.get_segment_global_translation(name, name)
                        quat = self.vicon.get_segment_global_quaternion(name, name)
                        if quat is not None:
                            pos = pos / 1000.0  #trasnform mm to m
                            if name == 'Drone':
                                ViconLogger.latest_pos[0] = pos[0]
                                ViconLogger.latest_pos[1] = pos[1]
                                ViconLogger.latest_pos[2] = pos[2]
                                ViconLogger.latest_pos[3] = 0.0
                                ViconLogger.latest_pos[4] = quat[0]
                                ViconLogger.latest_pos[5] = quat[1]
                                ViconLogger.latest_pos[6] = quat[2]
                                ViconLogger.latest_pos[7] = quat[3]
                                ViconLogger.latest_pos[8] = 0.0


                            # self.position[name] = pos
                            # self.quaternion[name] = quat
                            ViconLogger.save_log([ViconLogger.time_stamp.value,pos,quat,name])
                            # self.vicon_fifo.put([self.time_stamp,pos,quat,name])
                            # self.data_ready += 1
                            # if self.data_logging_en:
                            #     self.log(self.time_stamp, name + "_" + "posx", pos[0])
                            #     self.log(self.time_stamp, name + "_" + "posy", pos[1])
                            #     self.log(self.time_stamp, name + "_" + "posz", pos[2])
                            #     self.log(self.time_stamp, name + "_" + "qw", quat[0])
                            #     self.log(self.time_stamp, name + "_" + "qx", quat[1])
                            #     self.log(self.time_stamp, name + "_" + "qy", quat[2])
                            #     self.log(self.time_stamp, name + "_" + "qz", quat[3])

            time.sleep(int(round(self.period / 1000.0)))

    # def log(self, timestamp, id_var, value):
    #     data_row = np.array([timestamp, id_var, value]).reshape(1, -1)
    #     if self.data_log.shape[0] == 0:
    #         self.data_log = data_row
    #     else:
    #         self.data_log = np.append(self.data_log, data_row, axis=0)
    @staticmethod
    def get_latest_pos():
        return ViconLogger.latest_pos[:]
    @staticmethod
    def save_log(data):
        ts = data[0]
        pos = data[1]
        quat = data[2]
        name = data[3]
        with open(os.path.join((ViconLogger.log_file_name.value.decode()+ ".csv")), 'a') as file_vicon:
            row = ','.join([str(name),
                            str(ts),
                            str(pos[0]),
                            str(pos[1]),
                            str(pos[2]),
                            str(quat[0]),
                            str(quat[1]),
                            str(quat[2]),
                            str(quat[3])])
            row += '\n'
            file_vicon.write(row)
        #save on binary file -- Pickle
        with open(os.path.join(ViconLogger.log_file_name.value.decode() + ".dat"), 'ab') as file_vicon_b:  
            pickle.dump(data, file_vicon_b, protocol=pickle.HIGHEST_PROTOCOL)
        # print(data)
        # print("Vicon Log Saved!")
