import time

import cflib.crtp
import matplotlib.pyplot
import numpy as np
from cflib.crazyflie import Crazyflie
from cflib.positioning.position_hl_commander import PositionHlCommander
from cflib.crazyflie.log import LogConfig
from cflib.crazyflie.syncLogger import SyncLogger
from cflib.crazyflie.syncCrazyflie import SyncCrazyflie
from cflib.crtp.radiodriver import CRTPPacket
from multiprocessing import Process, Queue, Array, Value
from enum import Enum
import numpy.ma as ma
import os
import psutil
import ctypes 

from typing import List
from threading import Thread

from numpy.core.fromnumeric import mean

from lib.CrazyflieController import CrazyflieController, CrazyflieControllerManager
from timeit import default_timer as timer

from cf_test import *

class DatasetLoggerCommand(Enum):
    START_LOGGING = 0
    STOP_LOGGING = 1
    DISCONNECT = 2
    SHUT_DOWN = 3
    CONNECT = 4
    SCAN_INTERFACES = 5
    GET_LOG_TOC = 6


#distances = np.zeros((8, 8))
#targets = np.zeros((8, 8))
#status = np.zeros((8, 8))

class CrazyflieCommunicator:
    latest_drone_pos = Array('d',[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0])  #x,y,z,pos validity flag, qw,qx,qy,qz,quat validity flag
    MoveCommand = Value('i',0)
    array = np.zeros(256)
    dist = Array('i', range(64))
    targ = Array('i', range(64))
    sts = Array('i', range(64))
    ToF_image_timestmap = Value('i', 0)
    total_packets_num = Value('i', 0)
    total_packet_loss_num = Value('i', 0)
    packet_loss_percent = Value('d', 0.0)
    total_images_num = Value('i', 0)
    start = timer()
    front_distance_min_cm= 0

    def __init__(self):
        self.number_of_pakcets = 0
        self.curr_pakcet_index = 0
        self._receive_queue = Queue()
        self._command_queue = Queue()
        self._answer_queue = Queue()
        self._current_answer_id_count = 1
        self._free_answer_id_list = [0]
        self._callbacks_waiting_for_answer = dict()
        self._wait_for_answer_thread = Thread(target=self._check_answer_received, args=())

        self.communication_process = Process(target=CrazyflieCommunicator._communication_task,
                                             args=(self._command_queue,
                                                   self._receive_queue,
                                                   self._answer_queue))
        # self.communication_process.daemon = True
        self.communication_process.start()

    def send_command(self, command: DatasetLoggerCommand, cmd_data=None, answer_callback=None):
        if answer_callback is None:
            self._command_queue.put((None, command, cmd_data))
        else:
            if len(self._free_answer_id_list) > 0:
                answer_id = self._free_answer_id_list[0]
                self._free_answer_id_list = self._free_answer_id_list[1:]
            else:
                answer_id = self._current_answer_id_count
                self._current_answer_id_count += 1

            self._callbacks_waiting_for_answer[answer_id] = answer_callback
            self._command_queue.put((answer_id, command, cmd_data))
            if not self._wait_for_answer_thread.is_alive():
                self._wait_for_answer_thread = Thread(target=self._check_answer_received, args=())
                self._wait_for_answer_thread.start()

    def _check_answer_received(self):
        while len(self._callbacks_waiting_for_answer.keys()) > 0:
            time.sleep(0.2)
            answer_id, answer_data = self._get_next_queue_element(self._answer_queue, nb_elements=2)
            if answer_id is not None:
                callback = self._callbacks_waiting_for_answer.pop(answer_id)
                callback(answer_data)
                self._free_answer_id_list.append(answer_id)

    def get_packet(self) -> CRTPPacket:
        return self._receive_queue.get(block=False) if not self._receive_queue.empty() else None

    @staticmethod
    def _get_next_queue_element(queue, nb_elements=3):
        return queue.get(block=False) if not queue.empty() else ([None] * nb_elements)

    @staticmethod
    def _put_received_packet_to_queue_callback(queue: Queue, packet: CRTPPacket):
        queue.put(packet)
    @staticmethod
    def _put_received_packet_to_queue(queue: Queue, packet: CRTPPacket):
        queue.put(packet)

    @staticmethod
    def new_packet_received(packet):
        data = packet._get_data_l()
        CrazyflieCommunicator.total_packets_num.value = CrazyflieCommunicator.total_packets_num.value + 1
        if data[0] == ord('D'): #data packet
            CrazyflieCommunicator.curr_pakcet_index = CrazyflieCommunicator.curr_pakcet_index +1
            idx = data[1]
            if CrazyflieCommunicator.curr_pakcet_index != idx: # packett los
                CrazyflieCommunicator.total_packet_loss_num.value = CrazyflieCommunicator.total_packet_loss_num.value +1
                if(CrazyflieCommunicator.total_packet_loss_num.value == 0 or CrazyflieCommunicator.total_packets_num.value == 0):
                    CrazyflieCommunicator.packet_loss_percent.value = 0
                else:
                    CrazyflieCommunicator.packet_loss_percent.value =  CrazyflieCommunicator.total_packet_loss_num.value/CrazyflieCommunicator.total_packets_num.value
                print("total: ",CrazyflieCommunicator.total_packets_num.value," loss: ",CrazyflieCommunicator.total_loss_num,"{:.2f}".format((CrazyflieCommunicator.total_loss_num/CrazyflieCommunicator.total_packets_num.value)*100),"%")
                print("pakcet Loss! ","idx:",idx," missed packet:",CrazyflieCommunicator.curr_pakcet_index,"total packets:",CrazyflieCommunicator.number_of_pakcets)
                return
            #print("packet recevied: ",idx," out of:",CrazyflieCommunicator.number_of_pakcets-1)
            for i in range(len(data) - 2):
                CrazyflieCommunicator.array[idx*28 + i] = data[i+2]
            if idx == CrazyflieCommunicator.number_of_pakcets - 1:
                # invalid_mask=np.zeros(64)
                # valid_distances=np.zeros(64)
                for i in range(8):
                    for j in range(8):
                        CrazyflieCommunicator.dist[j+8*i] = int(CrazyflieCommunicator.array[2*(j+8*i)] + 256*CrazyflieCommunicator.array[2*(j+8*i)+1])
                        CrazyflieCommunicator.targ[j+8*i] = int(CrazyflieCommunicator.array[j+8*i+128])
                        CrazyflieCommunicator.sts[j+8*i] = int(CrazyflieCommunicator.array[j+8*i+128+64])
                        # if((CrazyflieCommunicator.sts[j+8*i] != 5 and CrazyflieCommunicator.sts[j+8*i] != 9) or CrazyflieCommunicator.targ[j+8*i]  != 1):
                        #     invalid_mask[8*i+j] = 1
                #print(CrazyflieCommunicator.number_of_pakcets,"Packets received Successfully.")

                # if (np.all(invalid_mask)):
                #     CrazyflieCommunicator.front_distance_min_cm= 350
                # else:
                #     valid_distances =  ma.masked_array(CrazyflieCommunicator.dist, mask=invalid_mask)
                #     CrazyflieCommunicator.front_distance_min_cm= (np.nanmin(valid_distances))/10.0
                #     # if(np.isnan(CrazyflieCommunicator.front_distance_min_cm)):
                #     #     CrazyflieCommunicator.front_distance_min_cm= 350
                # #print(str(CrazyflieCommunicator.front_distance_min_cm))
                CrazyflieCommunicator.total_images_num.value = CrazyflieCommunicator.total_images_num.value + 1
        
        elif data[0] == ord('C') : #command packet
            if data[1] == 1 : #timstmap & number of packets
                CrazyflieCommunicator.number_of_pakcets =data[2]
                CrazyflieCommunicator.curr_pakcet_index = -1
                CrazyflieCommunicator.ToF_image_timestmap.value = int(data[3] + (data[4]<<8) + (data[5]<<16) + (data[6]<<24))
                #print(CrazyflieCommunicator.ToF_image_timestmap.value, "ms, ",CrazyflieCommunicator.number_of_pakcets," Packets will be send") 
    
        else:
            print("Unknown Command: !!!",chr(data[0]))

    @staticmethod
    def _communication_task(command_queue: Queue, receive_queue: Queue, answer_queue: Queue):
        print("CrazyflieCommunicator CPUid: "+str(psutil.Process().cpu_num()))
        cflib.crtp.init_drivers()
        log_configs = []
        el_id, command, cmd_data = CrazyflieCommunicator._get_next_queue_element(command_queue)
        while command != DatasetLoggerCommand.SHUT_DOWN:
            time.sleep(0.2)
            el_id, command, cmd_data = CrazyflieCommunicator._get_next_queue_element(command_queue)
            if command == DatasetLoggerCommand.CONNECT:
                with SyncCrazyflie(link_uri=cmd_data["link_uri"], cf=Crazyflie(rw_cache='./cache')) as scf:  # Open Crazyflie synchronously
                    answer_queue.put((el_id, None))
                    packet_callback = lambda packet: CrazyflieCommunicator._put_received_packet_to_queue_callback(receive_queue, packet)
                    scf.cf.packet_received.add_callback(packet_callback)

                    print("ToF Callback added.")
                    scf.cf.add_port_callback(1, CrazyflieCommunicator.new_packet_received)#port 1 --> ToF packet

                    # =================== Controller input =========================
                    CrazyflieControllerManager.set_selected_controller_by_id(cmd_data["selected_controller_id"])
                    cf_controller = CrazyflieController(cmd_data["input_controller_map"])
                    if CrazyflieControllerManager.get_selected_controller() is not None:
                        CrazyflieControllerManager.add_queue_to_read_process(cf_controller.event_queue)
                    # =================== Controller input =========================
                    while command != DatasetLoggerCommand.DISCONNECT:
                        time.sleep(0.02)
                        # =================== update drone pos with vicon data if available =========================
                        if(CrazyflieCommunicator.latest_drone_pos[3] > 0.0):
                            if(CrazyflieCommunicator.latest_drone_pos[8] > 0.0): #update both pos and angle
                                scf.cf.extpos.send_extpos(CrazyflieCommunicator.latest_drone_pos[0], #px
                                                          CrazyflieCommunicator.latest_drone_pos[1], #py 
                                                          CrazyflieCommunicator.latest_drone_pos[2], #pz
                                                          CrazyflieCommunicator.latest_drone_pos[5], #qx
                                                          CrazyflieCommunicator.latest_drone_pos[6], #qy
                                                          CrazyflieCommunicator.latest_drone_pos[7], #qz
                                                          CrazyflieCommunicator.latest_drone_pos[4]) #qw
                                CrazyflieCommunicator.latest_drone_pos[3]=0.0
                                CrazyflieCommunicator.latest_drone_pos[8]=0.0
                            else: #update only pos
                                scf.cf.extpos.send_extpos(CrazyflieCommunicator.latest_drone_pos[0], #px 
                                                          CrazyflieCommunicator.latest_drone_pos[1], #py 
                                                          CrazyflieCommunicator.latest_drone_pos[2]) #pz
                                CrazyflieCommunicator.latest_drone_pos[3]=0.0
                        # =================== update drone pos with vicon data if available END =========================
                        el_id, command, cmd_data = CrazyflieCommunicator._get_next_queue_element(command_queue)
                        if command == DatasetLoggerCommand.DISCONNECT or command == DatasetLoggerCommand.STOP_LOGGING:
                            if log_configs is not None:
                                for log_config in log_configs:
                                    log_config.stop()
                        elif command == DatasetLoggerCommand.START_LOGGING:
                            log_configs = cmd_data["log_configs"]  # type: List[LogConfig]
                            log_config_ids = []
                            for log_config in log_configs:
                                scf.cf.log.add_config(log_config)
                                log_config_ids.append((log_config.name, log_config.id))
                                log_config.start()
                            answer_queue.put((el_id, log_config_ids))
                        elif command == DatasetLoggerCommand.GET_LOG_TOC:
                            answer_queue.put((el_id, scf.cf.log.toc.toc))
                        # As long as we are connected to the crazyflie it is controlled by the controller
                        # =================== Controller input =========================
                        cf_controller.control_task(scf.cf,CrazyflieCommunicator.MoveCommand.value)
                        # =================== Controller input =========================
                    # Remove callback before we disconnect
                    scf.cf.packet_received.remove_callback(packet_callback)
                    if CrazyflieControllerManager.get_selected_controller() is not None:
                        CrazyflieControllerManager.remove_queue_from_read_process(cf_controller.event_queue, False)

                        # packet = scf.cf.link.receive_packet(0)  # do not block if receive queue is empty
            elif command == DatasetLoggerCommand.SCAN_INTERFACES:
                interfaces = cflib.crtp.scan_interfaces()
                answer_queue.put((el_id, interfaces))

    def quit(self):
        self._callbacks_waiting_for_answer.clear()
        self._wait_for_answer_thread.join()
        self._command_queue.put((None, DatasetLoggerCommand.DISCONNECT, None))
        self._command_queue.put((None, DatasetLoggerCommand.SHUT_DOWN, None))
        # self.communication_process.join()
        # self.communication_process.close()


if __name__ == "__main__":
    cflib.crtp.init_drivers()

    # lg_stab = LogConfig(name='Stabilizer', period_in_ms=10)
    # lg_stab.add_variable('stabilizer.roll', 'float')
    # lg_stab.add_variable('stabilizer.pitch', 'float')
    # lg_stab.add_variable('stabilizer.yaw', 'float')
    cf_ds_logger = CrazyflieCommunicator()








