from threading import Thread
import math
from cflib.crazyflie.log import LogConfig
from cflib.crazyflie import Crazyflie
from cflib.crazyflie import Console
import cflib.crtp
import sys
import time
from cflib.crtp.crtpstack import CRTPPort
import numpy as np
from timeit import default_timer as timer


class CrazyFlieCommander(Thread):
    def __init__(self, uri):
        Thread.__init__(self)
        self.t = timer()
        self.uri = uri
        self.text = " "
        self.cf = Crazyflie(rw_cache='./cache')
        self.is_connected = False
        self.start()

        self.array = np.zeros(256)
        self.counter = 0

        self.distances = np.zeros((8, 8))
        self.targets = np.zeros((8, 8))
        self.status = np.zeros((8, 8))

    def run(self):
        self.connect_tocf()
        while self.is_connected == False:
            time.sleep(0.01)
        self.config()

    def connect_tocf(self):
        # Connect some callbacks from the Crazyflie API
        self.cf.connected.add_callback(self._connected)
        self.cf.disconnected.add_callback(self._disconnected)
        self.cf.connection_failed.add_callback(self._connection_failed)
        self.cf.connection_lost.add_callback(self._connection_lost)

        print('Connecting to %s' % self.uri)

        # Try to connect to the Crazyflie
        self.cf.open_link(self.uri)


    def _connected(self, link_uri):
        print('Connected to %s' % link_uri)
        self.is_connected = True

    def config(self):
        time.sleep(0.2)
        self.cf.param.set_value('stabilizer.estimator', '2')
        # self.cf.param.set_value('locSrv.extQuatStdDev', 0.05)
        # self.cf.param.set_value('stabilizer.controller', '2')
        self.cf.param.set_value('commander.enHighLevel', '1')
        print("CF configured!")
        print("Reset estimator")
        self.cf.param.set_value('kalman.resetEstimation', '1')
        time.sleep(0.1)
        self.cf.param.set_value('kalman.resetEstimation', '0')


    def _connection_failed(self, link_uri, msg):
        print('Connection to %s failed: %s' % (link_uri, msg))
        self.is_connected = False

    def _connection_lost(self, link_uri, msg):
        print('Connection to %s lost: %s' % (link_uri, msg))

    def _disconnected(self, link_uri):
        print('Disconnected from %s' % link_uri)
        self.is_connected = False

    def receive(self):
        self.cf.add_port_callback(1, self.packet_received)

    def packet_received(self, packet):
        # console_text = packet.data.decode('UTF-8')
        data = packet._get_data_l()
        # print(data)
        if data[0] == 68:
            idx = data[1]
            for i in range(len(data) - 2):
                self.array[idx*28 + i] = data[i+2]
            if idx == 9:
                for i in range(8):
                    for j in range(8):
                        self.distances[i, j] = self.array[2*(j+8*i)] + 256*self.array[2*(j+8*i)+1]
                        self.targets[i, j] = self.array[j+8*i+128]
                        self.status[i, j] = self.array[j+8*i+128+64]
                print(1000*(timer() - self.t))
                self.t = timer()


        # if data[0] == 67:
        #     print(data[0])


# cflib.crtp.init_drivers(enable_debug_driver=False)
# drones = cflib.crtp.scan_interfaces()
# cf0 = CrazyFlieCommander(drones[0][0])
# while(cf0.is_connected != True):
#     wait = 1

# cf0.receive()