import sys, os
import cv2
from PIL import Image  
import pickle
import numpy as np
from numpy.core.fromnumeric import size, transpose
from numpy.lib.function_base import flip



def refine_image(input_image):

    img_arr=np.reshape(input_image,(8,8))
    #refine image
    #img_arr =transpose(img_arr)
    #Effective zone orientation
    #img_arr = flip(img_arr, axis=0) 
    #img_arr = flip(img_arr, axis=1) 

    #normilize
    #img_arr = cv2.normalize(img_arr, None, 255, 0, norm_type=cv2.NORM_MINMAX, dtype=cv2.CV_8U)
    if(img_arr.max()!=0):
        img_arr = np.round(img_arr/(img_arr.max()/255.0))
    img_arr= 255 -img_arr
    #
    image = Image.fromarray(img_arr.astype(np.uint8) , 'P')  #L (8-bit pixels, black and white) --- P (8-bit pixels, mapped to any other mode using a color palette)
    #img  = Image.new( mode = "RGB", size = (width, height) )
    image = image.resize((width, height), Image.ANTIALIAS)
    #image.save(address+"test/img"+str(index)+".png")
    return np.asarray(image)



def make_video(address,address2save):
    ts = []
    dis = []
    tar = []
    sts = []
    try:
        with open(os.path.join(address+"state_ToF.dat"), 'rb') as f:
            while True:
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                ts.append(o)
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                dis.append(o)
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                tar.append(o)
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                sts.append(o)
            print(str(len(ts))+" images has been read succesfully. FR:"+str(round((1000*len(ts))/(ts[-1]-ts[0]),2)))
    except :
        print("file not found!")

    distances = np.array(dis)
    targets = np.array(tar)
    status = np.array(sts) 
    timestamps= np.array(ts)
    #
    
    #real_distances = np.reshape(distances.flatten(),(width,height,int(distances.size/64)),order='A')
    
    #clear invalid pixels
    max_dis = distances.max()
    for i in range(len(distances)):
        for j in range(len(distances[0])):
            if((status[i,j] != 5 and status[i,j] != 9) or targets[i,j] != 1):
                distances[i,j] = max_dis
                #print(str(i)+" "+str(j)+" "+str(status[i,j]))
                # invalid_pixel_num += 1
    # 
    video = cv2.VideoWriter(address2save+folder_name+".avi", 0, 15, (width,height),False)

    for i in range(len(distances)):
        real_image =refine_image(distances[i,:])
        video.write(real_image)

    cv2.destroyAllWindows()
    video.release()

if __name__ == "__main__":
    folder_names = ["Aproach by face", 
                "Fly near to walls and rotate",
                "Land & Take off 1", 
                "Land & Take off 2", 
                "Get near the wall by 45 degree", 
                "Get near the wall by -45 degree", 
                "Get near the wall by -90 degree"]
    width = 800
    height = 800
    for i in range(len(folder_names)):
        folder_name = folder_names[i]
        address = "../../../Data Log/ToF Distance Test/Onflight State + Tof/"+folder_name+"/" 
        address2save = "../../../Data Log/LogResults/On flight test/"
        make_video(address,address2save)


   