from math import nan
import math
from re import I
import sys, os
import cv2
from PIL import Image  
import pickle
import numpy as np
from numpy.core.fromnumeric import size, transpose
from numpy.lib.function_base import flip
import matplotlib.pyplot as plt
from numpy.lib.type_check import real
import seaborn as sns

from ToF_Validator import set_box_color; sns.set_theme()


def refine_image(input_image,invalid_mask,index):
    
    #refine image
    img_arr = input_image /1.0
    for i in range(len(input_image)):
        if (invalid_mask[i]):
            img_arr[i] = nan
    img_arr = np.around(img_arr)
    img_arr=np.reshape(img_arr,(8,8))
    # img_arr =transpose(img_arr)
    #Effective zone orientation
    # img_arr = flip(img_arr, axis=0) 
    img_arr = flip(img_arr, axis=1) 

    angles = np.zeros(28)
    p_index = 0

    # for i in range(8):
    #     for j in range(i+1,8):
    for i in range(1,8):
        for j in range(0,7-i+1):
            # print(j+i,j)
            res = angle_calculator(np.nanmean(img_arr[:,j+i]), j+i, np.nanmean(img_arr[:,j]), j)
            angles[p_index] = res
            p_index +=1
    
    # average_angle = sum(np.multiply(range(28), angles)) / sum(range(28))
    # print(average_angle)

    #normilize
    #img_arr = cv2.normalize(img_arr, None, 255, 0, norm_type=cv2.NORM_MINMAX, dtype=cv2.CV_8U)
    # if(img_arr.max()!=0):
    #     img_arr = np.round(img_arr/(img_arr.max()/255.0))
    # img_arr= 255 -img_arr
    # #export QT_DEBUG_PLUGINS
    # image = Image.fromarray(img_arr.astype(np.uint8) , 'P',)  #L (8-bit pixels, black and white) --- P (8-bit pixels, mapped to any other mode using a color palette)
    # #img  = Image.new( mode = "RGB", size = (width, height) )
    # image = image.resize((width, height), Image.ANTIALIAS)
    # image.save("/home/im/Desktop/ETH_repo/iman-ostovar/Data Log/LogResults/On flight test/pic_test"+"img"+str(index)+".png")
    # index +=1

    #save picturs
    # fig3, ax = plt.subplots(figsize=(8, 8))
    # cmap = sns.diverging_palette(
    #     10, 133, 100, 60, center='light', as_cmap=True)
    # sns.heatmap(img_arr, annot=True, fmt=".0f",
    #             cmap=cmap, annot_kws={"size": 18})
    # sns.set(font_scale=1.9)
    # # for i in range(8):
    # #     for j in range(8):
    # #         value = round(input_image[j+8*i],1)
    # #         plt.text(i+0.16, j+0.25, "(" + str(value) + ")", fontsize=9, color='orange')
    # plt.text(8+0.25, 8+0.4, "(cm)", fontsize=15, color='orange')
    # ax.set_ylabel('Pixel Row', fontsize=25)
    # ax.set_xlabel('Pixel Column', fontsize=25)
    # fig3.savefig((address2save +folder_name +"_N"+str(index)+".png"), format="png",dpi=500)
    # print(address2save +folder_name +"_N"+str(index)+".png")
    # plt.close(fig3)
    
    return angles



def save_angle_plots(angles):
    fig2, ax = plt.subplots(figsize=(28, 10), dpi=500)
    major_ticks = np.arange(28)
    # minor_ticks = np.arange(10, 310, 20)
    # ax.set_facecolor('white')
    for index in range(28):
        bp1 = ax.boxplot(angles[:, index], positions=[index],
                         widths=0.5)  # , showfliers=False
        # ax.plot([], c='#D7191C', label=str(index))
        # set_box_color(bp1, '#D7191C')

    # ax.set_title("Distance Measurments")
    ax.set_ylabel('angle(degree)', fontsize=30)
    ax.set_xlabel('Reference angle(degree)', fontsize=30)
    #ax.boxplot(measured_dis[1:3],valid_distances_mid_d,labels="Dark")
    # ax.set_xticks(np.arange(0, len(major_ticks) * 4, 4), labels= major_ticks)
    # ax.set_xticks(np.arange(0, len(minor_ticks) * 4, 4), labels= minor_ticks, minor=True)

    for axis in ['top', 'bottom', 'left', 'right']:
        ax.spines[axis].set_linewidth(4)
        ax.spines[axis].set_color('black')

    # plt.xticks(np.arange(0, len(major_ticks) * 4, 4), labels = major_ticks )
    # plt.xticks(np.arange(0, len(minor_ticks) * 4, 4), labels = minor_ticks, minor=True)
    #ax.yaxis.grid(True, which='minor')

    #  plt.grid(which='minor', alpha=0.9,color='black',linestyle = '--')
    # plt.grid(which='major', alpha=0.1,color='black',linestyle = '--')

    ax.tick_params(labelsize=22)

    # plt.legend(prop={'size': 20})
    fig2.savefig(os.path.join(
        "../../../Data Log/LogResults/Angle Validator/Statistics/"+folder_name+".png"), format="png")
    # fig2.savefig(os.path.join("../../../Data Log/LogResults/VD.svg"))
    plt.close(fig2)


def angle_calculator(dis1, index1, dis2, index2):
    fov_deg = 45
    fov_h = math.radians(fov_deg/2)
    alpha1 = math.atan((7-2*index1)/7 * math.tan(fov_h))
    alpha2 = math.atan((7-2*index2)/7 * math.tan(fov_h))
    
    # if alpha1 <0:
    #     alpha1 = 2*math.pi +alpha1
    # if alpha2 <0:
    #     alpha2 = 2*math.pi +alpha2
    # print("disff:" + str(round(math.degrees(alpha2-alpha1))))

    #another assumption
    # alpha1= ((7-2*index1)/7)*fov_h
    # alpha2= ((7-2*index2)/7)*fov_h
    # iman Algorithm
    # Length1 = dis1 / math.cos(alpha1)
    # Length2 = dis2 / math.cos(alpha2)
    # Length3 = math.sqrt(Length1**2 + Length2**2 - 2 *Length1*Length2*math.cos(alpha1-alpha2))
    # angle = math.asin((Length1/Length3) * math.sin(alpha1-alpha2))
    # real_angle = angle - alpha2


    beta = math.atan((math.tan(alpha1)*dis1 - math.tan(alpha2)*dis2)/(dis2-dis1))
    # print("beta:" + str(round(math.degrees(beta))))
    round_angle = (round(math.degrees(beta),1))
    # if(round_angle < 0):
    #     round_angle = 360 +round_angle
    return round_angle


def ProcessImages(address, address2save):
    ts = []
    dis = []
    tar = []
    sts = []
    try:
        with open(os.path.join(address+"state_ToF.dat"), 'rb') as f:
            while True:
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                ts.append(o)
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                dis.append(o)
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                tar.append(o)
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                sts.append(o)
            print(str(len(ts))+" images has been read succesfully. FR:" +
                  str(round((1000*len(ts))/(ts[-1]-ts[0]), 2)))
    except:
        print("file not found!")

    distances = np.array(dis)
    targets = np.array(tar)
    status = np.array(sts)
    timestamps = np.array(ts)
    #

    #real_distances = np.reshape(distances.flatten(),(width,height,int(distances.size/64)),order='A')

    #clear invalid pixels
    invalid_mask = np.zeros((len(distances), len(distances[0])))
    for i in range(len(distances)):
        for j in range(len(distances[0])):
            if((status[i, j] != 5 and status[i, j] != 9) or targets[i, j] != 1):
                invalid_mask[i, j] = 1

    all_angless = np.zeros((len(distances), 28))
    for i in range(len(distances)):
    #for i in [428,126,311]:
        angles = refine_image(distances[i, :], invalid_mask[i, :], i)
        all_angless[i] = angles
    save_angle_plots(all_angless)



if __name__ == "__main__":
    # folder_names = ["Aproach by face", 
    #             "Fly near to walls and rotate",
    #             "Land & Take off 1", 
    #             "Land & Take off 2", 
    #             "Get near the wall by 45 degree", 
    #             "Get near the wall by -45 degree", 
    #             "Get near the wall by -90 degree"]
    folder_names = ["30 exact wood",
                    "45 exact at 67 wall _ PP 54",
                    "45 exact at 161 wall_ PP 126",
                    "45 Exact wood",
                    "60 exct 64 wall __60"]
    width = 800
    height = 800
    for i in range(len(folder_names)):
        folder_name = folder_names[i]
        print(str(i)+"_"+folder_name)

        address = "../../../Data Log/Angle validator/"+folder_name+"/" 
        address2save = "../../../Data Log/LogResults/Angle Validator/all pictures/"
        ProcessImages(address,address2save)


   
