import os.path
from matplotlib.pyplot import boxplot, close, figure, legend, plot
from matplotlib.ticker import AutoMinorLocator, MultipleLocator
import numpy as np
import numpy.ma as ma
import pickle
import matplotlib.pyplot as plt
from numpy.lib.function_base import average
import sys, os
from sklearn import preprocessing
import seaborn as sns; sns.set_theme()

import warnings
warnings.filterwarnings("ignore")



def process_log(m_distance,state,wall):
    ts = []
    dis = []
    tar = []
    sts = []
    try:
        with open(os.path.join("../../../Data Log/Stationary Test/"+wall+"W"+state+"_"+str(m_distance)+"cm/state_ToF.dat"), 'rb') as f:
            while True:
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                ts.append(o)
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                dis.append(o)
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                tar.append(o)
                try:
                    o = pickle.load(f)
                except EOFError:
                    break
                sts.append(o)
            print(str(len(ts))+" images has been read succesfully. FR:"+str((1000*len(ts))/(ts[-1]-ts[0])))
    except :
        print("file not found!")

    distances = np.array(dis)
    targets = np.array(tar)
    status = np.array(sts) 

    #remove invalid pixels
    invalid_mask = np.zeros((len(distances),len(distances[0])))
    invalid_pixel_num = 0
    for i in range(len(distances)):
        for j in range(len(distances[0])):
            if((status[i,j] != 5 and status[i,j] != 9) or targets[i,j] != 1):
                invalid_mask[i,j] = 1
                #print(str(i)+" "+str(j)+" "+str(status[i,j]))
                invalid_pixel_num += 1
    if (invalid_pixel_num >0):
        valid_distances =  ma.masked_array(distances, mask=invalid_mask)
        #print("invalid_pixel_num: "+str(invalid_pixel_num))
        distances_cm = ma.masked_array(distances/10, mask=invalid_mask)
        distances_percent = ma.masked_array((10/m_distance)*distances, mask=invalid_mask)
        distances_cm_flat=distances_cm.compressed()

    else:
        valid_distances = distances
        distances_cm = (valid_distances/10)
        distances_percent = (100/m_distance)* distances_cm
        distances_cm_flat=distances_cm.flatten()
    
    distances_flat_percent=(100/m_distance)*distances_cm_flat


    # process data
    # pixels_avg =np.zeros(len(distances[0]))
    # pixels_min =np.zeros(len(distances[0]))
    # pixels_max =np.zeros(len(distances[0]))
    pixels_mean =np.zeros(len(distances[0]))
    pixels_offsets =np.zeros(len(distances[0]))
    # pixels_variance = np.zeros(len(distances[0]))
    pixels_stdvar = np.zeros(len(distances[0]))


    for i in range(len(distances[0])):
        # pixels_avg[i] = average( valid_distances[:,i])
        # pixels_min[i] = min( valid_distances[:,i])
        # pixels_max[i] = max( valid_distances[:,i])
        pixels_mean[i] = np.mean( valid_distances[:,i])
        # pixels_variance[i] = np.var( valid_distances[:,i])
        pixels_stdvar[i] = np.std(valid_distances[:,i])

    pixels_offsets = pixels_mean - (m_distance * 10) #instead of avg
    #all_pixels_variance = np.var(valid_distances)

    # fig1 = figure()    
    # boxplot(distances_cm_flat)
    # boxplot(preprocessing.normalize([x_array]))
    # plt.title(str(m_distance)+"_"+d_w)
    # fig1.savefig(os.path.join("../../../Data Log/LogResults/one_"+d_w+"_"+str(m_distance)+"cm.png"), format="png")
    # close(fig1)

    # fig2 = figure()    
    # boxplot(distances_cm)
    # plt.title(str(m_distance)+"_"+d_w)
    # fig2.savefig(os.path.join("../../../Data Log/LogResults/all_"+d_w+"_"+str(m_distance)+"cm.png"), format="png")



    # fig1, ax1 = plt.subplots(figsize=(10, 10))
    # #ax.boxplot(distances_cm_flat, 1, 'gD')
    # boxplot(np.array(distances_flat_percent), 1, 'gD')
    # plt.title("real ditsnace: "+str(m_distance)+"cm_"+d_w)
    # #ax1.set_xlabel('treatment')
    # ax1.set_ylabel('Measured ditanace(%)')
    # fig1.savefig(os.path.join("../../../Data Log/LogResults/one_"+d_w+"_"+str(m_distance)+"cm.png"), format="png",dpi=500)
    # fig1.savefig(os.path.join("../../../Data Log/LogResults/one_"+d_w+"_"+str(m_distance)+"cm.svg"))
    # close(fig1)

    # fig2, ax = plt.subplots(figsize=(30, 10))   
    # boxplot(distances_percent, 1, 'rD')
    # #boxplot(preprocessing.normalize([distances_cm]), 1, 'rD')
    # plt.title("real ditsnace:"+str(m_distance)+"cm_"+d_w)
    # ax.set_xlabel('pixel number')
    # ax.set_ylabel('Measured ditsnace(%)')
    # fig2.savefig(os.path.join("../../../Data Log/LogResults/all_"+d_w+"_"+str(m_distance)+"cm.png"), format="png",dpi=500)
    # fig2.savefig(os.path.join("../../../Data Log/LogResults/all_"+d_w+"_"+str(m_distance)+"cm.svg"))
    # close(fig2)

    fig3, ax = plt.subplots(figsize=(8, 8))
    sns.heatmap(np.reshape(pixels_offsets,(8,8)).transpose(),annot=True, fmt=".2f",cmap="YlGnBu",annot_kws={"size":13})
    for i in range(8):
            for j in range(8):
                value = round(pixels_stdvar[j+8*i],1)
                plt.text(i+0.13, j+0.85, "(" + str(value) + ")", fontsize=13, color='red')
    # for i in range(8):
    #     for j in range(8):
    #         value = round(pixels_mean[j+8*i],1)
    #         plt.text(i+0.16, j+0.25, "(" + str(value) + ")", fontsize=13, color='orange')
    plt.text(8+0.25, 8+0.4, "(cm)", fontsize=15, color='orange')
    # ax.set_title("Distance: "+str(m_distance)+"cm_"+wall+'_'+state)
    ax.set_ylabel('Pixel Row',fontsize=25)
    ax.set_xlabel('Pixel Column',fontsize=25)
    # fig3.savefig(os.path.join("../../../Data Log/LogResults/heatmap_"+wall+state+"_"+str(m_distance)+"cm.png"), format="png",dpi=500)
    # fig3.savefig(os.path.join("../../../Data Log/LogResults/heatmap_"+wall+state+"_"+str(m_distance)+"cm.svg"))
    close(fig3)

    #print("AVG: "+str(average(pixels_avg[~np.isnan(pixels_avg)])))
    #print("variance: ",pixels_var)
    #print("all variance:"+str(all_pixels_variance))

    return [(invalid_pixel_num/distances.size)*100,
            average(pixels_offsets[~np.isnan(pixels_offsets)]),
            valid_distances[:,3+8*3]/10-m_distance]


def set_box_color(bp, color):
    plt.setp(bp['boxes'], color=color)
    plt.setp(bp['whiskers'], color=color)
    plt.setp(bp['caps'], color=color)
    plt.setp(bp['medians'], color=color)


if __name__ == "__main__":
    measured_dis=[21,40,60,80,100,120,140,160,180,200,220,240,260,280,300]
    # measured_dis=[21,60,100,140,180,220,260,300]

    log_stats = ['D','L']
    wall_stats = ['W','D']

    invalid_pixels =[[]]
    offsets =[[]]
    valid_distances_mid = [[]]

    index = 0
    for dis in measured_dis:
        print("\t\t\tdistance:" + str(dis))
        print("\t\t\t\tWhite Wall Light:")
        try:
            [invp, po, vd]=process_log(dis, log_stats[1], wall_stats[0]) # white wall light
            invalid_pixels[0].append(invp)
            offsets[0].append(po)
            valid_distances_mid[0].append(vd)
        except Exception as e:
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print(exc_type, fname, exc_tb.tb_lineno)
            print("Error")
        
        print("\t\t\t\tWhite Wall Dark:")
        try:
            [invp, po, vd]=process_log(dis, log_stats[0], wall_stats[0]) # white wall dark
            invalid_pixels.append([])
            invalid_pixels[1].append(invp)
            offsets.append([])
            offsets[1].append(po)
            valid_distances_mid.append([])
            valid_distances_mid[1].append(vd)
        except Exception as e:
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print(exc_type, fname, exc_tb.tb_lineno)
            print("Error")
        print("\t\t\t\tDark Wall Light:")
        try:
            [invp, po, vd]=process_log(dis, log_stats[1], wall_stats[1]) # Dark wall light
            invalid_pixels.append([])
            invalid_pixels[2].append(invp)
            offsets.append([])
            offsets[2].append(po)
            valid_distances_mid.append([])
            valid_distances_mid[2].append(vd)
        except Exception as e:
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print(exc_type, fname, exc_tb.tb_lineno)
            print("Error")
        print("\t\t\t\tDark Wall Dark:")
        try:
            [invp, po, vd]=process_log(dis, log_stats[0], wall_stats[1]) # Dark wall dark
            invalid_pixels.append([])
            invalid_pixels[3].append(invp)
            offsets.append([])
            offsets[3].append(po)
            valid_distances_mid.append([])
            valid_distances_mid[3].append(vd)
        except Exception as e:
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print(exc_type, fname, exc_tb.tb_lineno)
            print("Error")
    
    # fig1, ax = plt.subplots(2,figsize=(20, 10), dpi=300)
    # ax[0].plot(measured_dis,invalid_pixels_l,label="Light")
    # ax[0].set_title("Invalid pixels:")
    # ax[0].set_xlabel('Distance(cm)')
    # ax[0].set_ylabel('number of invalid pixels light & dark(%)')
    # ax[0].plot(measured_dis,invalid_pixels_d,label="Dark")
    # ax[0].legend()

    # ax[1].plot(np.array(measured_dis).flatten(),np.array(([offsets_l])).flatten(),label="Light")
    # ax[1].set_title("Offset:")
    # ax[1].set_xlabel('Distance(cm)')
    # ax[1].set_ylabel('Distance Offset light & dark(cm)')
    # ax[1].plot(np.array(measured_dis).flatten(),np.array(([offsets_d])).flatten(),label="Dark")
    # ax[1].legend()

    
    # fig1.savefig(os.path.join("../../../Data Log/LogResults/IP.png"), format="png")
    # fig1.savefig(os.path.join("../../../Data Log/LogResults/IP.svg"))
    # close(fig1)
    
    fig1, ax = plt.subplots(figsize=(20, 10), dpi=300)
    ax.plot(measured_dis,invalid_pixels[0],'X--',label="White Wall / Ambient Light",linewidth = 3,markersize = 10)
    ax.plot(measured_dis,invalid_pixels[1],'X--',label="White Wall / Darkness",linewidth = 3,markersize = 10)
    ax.plot(measured_dis,invalid_pixels[2],'X--',label="Brown Wall / Ambient Light",linewidth = 3,markersize = 10)
    ax.plot(measured_dis,invalid_pixels[3],'X--',label="Brown Wall / Darkness",linewidth = 3,markersize = 10)
    print(invalid_pixels[0][9])
    print(invalid_pixels[1][9])
    print(invalid_pixels[2][9])
    print(invalid_pixels[3][9])
    # ax.set_title("Invalid pixels:")
    ax.set_xlabel('Distance(cm)',fontsize=30)
    ax.set_ylabel('Invalid Pixels(%)',fontsize=30)
    ax.set_facecolor('white')
    ax.legend(prop={'size': 20})
    ax.grid(color='black',linestyle = '--',alpha = .7)
    for axis in ['top','bottom','left','right']:
        ax.spines[axis].set_linewidth(4)
        ax.spines[axis].set_color('black')
    ax.set_xticks(np.arange(20, 320, 20))
    ax.tick_params(labelsize = 22)
    fig1.savefig(os.path.join("../../../Data Log/LogResults/IP.png"), format="png")
    fig1.savefig(os.path.join("../../../Data Log/LogResults/IP.svg"))
    close(fig1)


    fig2, ax = plt.subplots(figsize=(20, 10), dpi=300)
    major_ticks = np.arange(20, 320, 20)
    # minor_ticks = np.arange(10, 310, 20)
    ax.set_facecolor('white')

    bp1 = ax.boxplot(valid_distances_mid[0],positions=np.array(np.arange(len(valid_distances_mid[0])))*4.0-0.4, widths = 0.5, showfliers=False)
    ax.plot([], c='#D7191C', label='White Wall / Ambient Light')
    set_box_color(bp1, '#D7191C')
    bp2=ax.boxplot(valid_distances_mid[1], positions=np.array(np.arange(len(valid_distances_mid[1])))*4.0-1.2, widths = 0.5, showfliers=False)
    set_box_color(bp2, '#2C7BB6')
    ax.plot([], c='#2C7BB6', label='White Wall / Darkness')
    bp3=ax.boxplot(valid_distances_mid[2], positions=np.array(np.arange(len(valid_distances_mid[1])))*4.0+0.4, widths = 0.5, showfliers=False)
    set_box_color(bp3, '#21C22e')
    ax.plot([], c='#21C22E', label='Brown Wall / Ambient Light')
    bp4=ax.boxplot(valid_distances_mid[3], positions=np.array(np.arange(len(valid_distances_mid[1])))*4.0+1.2, widths = 0.5, showfliers=False)
    set_box_color(bp4, '#CE14E3')
    ax.plot([], c='#CE14E3', label='Brown Wall / Darkness')
    
    # ax.set_title("Distance Measurments")
    ax.set_ylabel('Distance error(cm)',fontsize=30)
    ax.set_xlabel('Reference Distance(cm)',fontsize=30)
    #ax.boxplot(measured_dis[1:3],valid_distances_mid_d,labels="Dark")
    # ax.set_xticks(np.arange(0, len(major_ticks) * 4, 4), labels= major_ticks)
    # ax.set_xticks(np.arange(0, len(minor_ticks) * 4, 4), labels= minor_ticks, minor=True)

    for axis in ['top','bottom','left','right']:
        ax.spines[axis].set_linewidth(4)
        ax.spines[axis].set_color('black')

    plt.xticks(np.arange(0, len(major_ticks) * 4, 4), labels = major_ticks )
    # plt.xticks(np.arange(0, len(minor_ticks) * 4, 4), labels = minor_ticks, minor=True)
    #ax.yaxis.grid(True, which='minor')

    #  plt.grid(which='minor', alpha=0.9,color='black',linestyle = '--')
    # plt.grid(which='major', alpha=0.1,color='black',linestyle = '--')

    ax.tick_params(labelsize = 22)

    plt.legend(prop={'size': 20})
    fig2.savefig(os.path.join("../../../Data Log/LogResults/VD.png"), format="png")
    fig2.savefig(os.path.join("../../../Data Log/LogResults/VD.svg"))
    close(fig2)
    
