
#include "ToF_process.h"
#include "commander.h"
#include "param.h"

// using namespace std;
//Parametrs
// zones and position parameters
zone_t DRONE_ZONE = {{3.0f, 3.0f}, {5.0f, 4.0f}};
zone_t CARE_ZONE = {{2.0f, 2.0f}, {5.0f, 5.0f}};
const pos_t MIDDLE_POS = {3.0f, 3.5f};
const uint8_t GROUND_BORDER = 6;
const uint8_t CELLING_BORDER = 2;
const uint8_t MIN_PIXEL_NUMBER = 1 ;
// Decision Parameters
const uint16_t ground_min_dis = 400; // mm
const uint16_t celling_min_dis = 600; // mm

uint16_t forward_reaction_distance = 1400; // mm
uint16_t FORWARD_SLOW_DIS = 700; // mm
uint16_t forward_stop_dis = 400; // mm


//
// #define IMAGE_PROCESS_DEBUG_PRINT

#ifdef IMAGE_PROCESS_DEBUG_PRINT
#include "debug.h"

//  bool Test_Ground_matrix[ROW][COL] = { { 0, 0, 0, 0, 0, 0, 0, 0},
//                                        { 0, 0, 0, 0, 0, 0, 0, 0},
//                                        { 0, 0, 0, 0, 0, 0, 0, 0},
//                                        { 0, 0, 0, 0, 0, 0, 0, 0},
//                                        { 0, 0, 0, 0, 0, 0, 0, 0},
//                                        { 0, 0, 0, 0, 0, 0, 0, 0},
//                                        { 0, 0, 0, 0, 1, 1, 1, 1},
//                                        { 0, 0, 0, 0, 1, 1, 1, 1} };
#endif
// C++ Program to count islands in boolean 2D matrix
// A function to check if a given cell (row, col) can be included in DFS
bool isSafe(bool M[][COL], uint8_t row, uint8_t col, bool visited[][COL])
{
    // row number is in range, column number is in range and value is 1 and not yet visited
    return (row >= 0) && (row < ROW) && (col >= 0) && (col < COL) && (M[row][col] && !visited[row][col]);
}

// A utility function to do DFS for a 2D boolean matrix. It only considers the 8 neighbours as adjacent vertices
void DFS(bool M[][COL], uint8_t row, uint8_t col, bool visited[][COL])
{
    // These arrays are used to get row and column numbers of 8 neighbours of a given cell
    const static uint8_t neighbour_num = 8;
    const static int8_t rowNbr[] = { -1, -1, -1, 0, 0, 1, 1, 1 };
    const static int8_t colNbr[] = { -1, 0, 1, -1, 1, -1, 0, 1 };

    // Mark this cell as visited
    visited[row][col] = true;

    // Recur for all connected neighbours
    for (int k = 0; k < neighbour_num; ++k)
        if (isSafe(M, row   + rowNbr[k], col + colNbr[k], visited))
            DFS(M, row + rowNbr[k], col + colNbr[k], visited);
}

// The main function that returns count of islands in a given boolean 2D matrix
uint8_t countIslands(bool M[][COL], bool objects[][ROW][COL])
{
    // Make a bool array to mark visited cells.
    // Initially all cells are unvisited
    bool visited[ROW][COL];
    bool old_visited[ROW][COL];

    memset(visited, 0, ROW*COL); //sizeof(visited)
    // memset(old_visited, 0, sizeof(old_visited));

    // memset(objects, 0, MAX_TARGET_NUM*COL*ROW); //sizeof(objects)
    // Initialize count as 0 and traverse through the all cells of given matrix
    int count = 0;
    for (int i = 0; i < ROW; ++i)
        for (int j = 0; j < COL; ++j)
            if (M[i][j] && !visited[i][j]) {
                //save old visited status
                memcpy(old_visited,visited,sizeof(visited));

                // If a cell with value 1 is not visited yet, then new island found Visit all cells in this island.
                DFS(M, i, j, visited);

                //save new Island positions
                if (count < MAX_TARGET_NUM)
                {   
                    for (int x = 0; x<ROW; ++x)
                        for (int y = 0; y<COL; ++y)
                            objects[count][x][y]= old_visited[x][y] ^ visited[x][y];
                }

                // and increment island count
                ++count;

            }

    return count;
}

// // Driver code
// uint8_t ToF_process_test(void)
// {
//     int M[][COL] = { { 1, 1, 0, 0, 0 },
//                      { 0, 1, 0, 0, 1 },
//                      { 1, 0, 0, 1, 1 },
//                      { 0, 0, 0, 0, 0 },
//                      { 1, 1, 1, 0, 1 } };
    
//     int IslandNum =countIslands(M);
//     // std:cout << "Number of islands is: " << ;
//     return IslandNum;
// }



FlyCommand_t Process_ToF_Image(VL53L5CX_ResultsData* p_tof_results)
{
    // decode results
    uint16_t ToF_distances[ToF_DISTANCES_LEN/2]; 
    uint8_t ToF_targets[ToF_TARGETS_DETECTED_LEN]; 
    uint8_t ToF_status[ToF_TARGETS_STATUS_LEN]; 
    memcpy(ToF_distances, (uint8_t *)(&p_tof_results->distance_mm[0]), ToF_DISTANCES_LEN);
    memcpy(ToF_targets, (uint8_t *)(&p_tof_results->nb_target_detected[0]), ToF_TARGETS_DETECTED_LEN);
    memcpy(ToF_status, (uint8_t *)(&p_tof_results->target_status[0]), ToF_TARGETS_STATUS_LEN);
    
    // found invalid pixels and binerize the 
    volatile bool invalid_mask[ROW*COL];
    for (int i= 0; i<ROW*COL; ++i)
        invalid_mask[i] = (ToF_status[i] != 5 && ToF_status[i] != 9) || ToF_targets[i] != 1;
    
    
    // binerize the image
    volatile bool binery_matrix[ROW][COL];
    volatile uint16_t ToF_distances_matrix[ROW][COL]; 

    for (int i= 0; i<ROW; ++i)
        for (int j= 0; j<COL; ++j)
        {
            if(! invalid_mask[j+COL*i]) // check if the pixel is valid
            {
                // ToF_distances_matrix[i][j] = (uint16_t) ToF_distances[2*(j+COL*i)] + (uint16_t) ToF_distances[2*(j+COL*i)+1] <<8 ;
                ToF_distances_matrix[i][j] = ToF_distances[j+COL*i];
                binery_matrix[i][j] = (ToF_distances_matrix[i][j] <= MAX_DISTANCE_TO_PROCESS);
            }
            else
            {
                ToF_distances_matrix[i][j] = UINT16_MAX; //this is invalid Value;  should care about not to be used later
                binery_matrix[i][j] = false;
            }
        }

    //filter the image
    // m_kernel_t x;
    // memcpy(binery_matrix, Test_Ground_matrix, ROW*COL);  //for test only

    

    // detect objects
    static bool objects_matrixes[MAX_TARGET_NUM][ROW][COL];
    volatile uint8_t object_num = countIslands(binery_matrix, objects_matrixes);

    // objects feature extraction
    target_t targets[MAX_TARGET_NUM] ;
    for (int k= 0; k<object_num; ++k)
    {
        uint16_t dis_max = 0;
        uint16_t dis_min = UINT16_MAX;
        uint16_t dis_sum = 0;
        uint16_t x_sum = 0;
        uint16_t y_sum = 0;
        uint8_t ones_count = 0;
        borders_t tar_borders = {INT8_MAX, INT8_MAX, INT8_MIN, INT8_MIN}; //top left right bottom

        for (int i= 0; i<ROW; ++i)
            for (int j= 0; j<COL; ++j)
            {
                if (objects_matrixes[k][i][j])
                {
                    if(ToF_distances_matrix[i][j] < dis_min)
                        dis_min = ToF_distances_matrix[i][j];
                    // if(ToF_distances_matrix[i][j] > dis_max)
                    //     dis_max = ToF_distances_matrix[i][j];
                    // dis_sum += ToF_distances_matrix[i][j];
                    x_sum += i;
                    y_sum += j;
                    ones_count ++;

                    //update borders 
                    if (i < tar_borders.top) //min i
                        tar_borders.top = i;
                    if (i > tar_borders.bottom) // max i
                        tar_borders.bottom = i;
                    if (j < tar_borders.left) // min j
                        tar_borders.left = j;
                    if (j > tar_borders.right) // max j
                        tar_borders.right = j;
                }
            }
        // targets[k].avg_distance = dis_sum /ones_count;
        // targets[k].max_distance = dis_max;
        targets[k].min_distance = dis_min;
        targets[k].position.x = (float)x_sum/ones_count;
        targets[k].position.y = (float)y_sum/ones_count;
        targets[k].pixels_number = ones_count;
        targets[k].borders = tar_borders; 
    }
    
    #ifdef IMAGE_PROCESS_DEBUG_PRINT
        // DEBUG_PRINT("ToFDeck P.I. N.Targets: %d\n",object_num); 
    #endif
    return Decision_Making(targets, object_num);

}


FlyCommand_t Decision_Making(target_t* targets, uint8_t object_num)
{  
    // find the highest priority target 
    uint16_t dis_global_min = UINT16_MAX;
    int8_t selected_target = -1;
    uint8_t in_danger_targets = 0;
    // uint8_t in_danger_targets_inxedes[MAX_TARGET_NUM];
    for (int k= 0; k<object_num; ++k)
    {
        if (targets[k].min_distance <= forward_stop_dis)
        {
            // in_danger_targets_inxedes[in_danger_targets] = k;
            in_danger_targets++;
        }
        if (targets[k].min_distance < dis_global_min && targets[k].pixels_number > MIN_PIXEL_NUMBER )
        {
            dis_global_min = targets[k].min_distance;
            selected_target = k;
        }
    }

    if (selected_target < 0) // no big target in front
        return (FlyCommand_t){forward,1.0f};
    //TODO

    // start the Decision Tree
/*    
    // check for objects area
    enum Region danger_targets_regions[MAX_TARGET_NUM] = {RegionError} ;
    for (int i= 0; i<in_danger_targets; ++i)
    {
        if (in_danger_targets_inxedes[i] == selected_target)
            continue;

        if (targets[in_danger_targets_inxedes[i]].position.x >= MIDDLE_POS.x &&
            targets[in_danger_targets_inxedes[i]].position.y >= MIDDLE_POS.y)
            danger_targets_regions[i] = LowerRight;
        if (targets[in_danger_targets_inxedes[i]].position.x < MIDDLE_POS.x &&
            targets[in_danger_targets_inxedes[i]].position.y >= MIDDLE_POS.y)
            danger_targets_regions[i] = UpperRight;
        if (targets[in_danger_targets_inxedes[i]].position.x >= MIDDLE_POS.x &&
            targets[in_danger_targets_inxedes[i]].position.y < MIDDLE_POS.y)
            danger_targets_regions[i] = LowerLeft;
        if (targets[in_danger_targets_inxedes[i]].position.x < MIDDLE_POS.x &&
            targets[in_danger_targets_inxedes[i]].position.y < MIDDLE_POS.y)
            danger_targets_regions[i] = UpperLeft;

        if (danger_targets_regions[i] < 0) // error  never should reach here
            return (FlyCommand_t){CommandError,0.0f};


    }
*/

    enum Region selected_target_region = RegionError ;
    if (targets[selected_target].position.x >= MIDDLE_POS.x &&
        targets[selected_target].position.y >= MIDDLE_POS.y)
        selected_target_region = LowerRight;
    if (targets[selected_target].position.x < MIDDLE_POS.x &&
        targets[selected_target].position.y >= MIDDLE_POS.y)
        selected_target_region = UpperRight;
    if (targets[selected_target].position.x >= MIDDLE_POS.x &&
        targets[selected_target].position.y < MIDDLE_POS.y)
        selected_target_region = LowerLeft;
    if (targets[selected_target].position.x < MIDDLE_POS.x &&
        targets[selected_target].position.y < MIDDLE_POS.y)
        selected_target_region = UpperLeft;

    if (selected_target_region < 0) // error  never should reach here
        return (FlyCommand_t){CommandError,0.0f};



    enum MoveCommand command = CommandError;
    float danger_severity = 0.0f ; // 0-1    0--> most severe   1--> ignoring

    if (targets[selected_target].borders.top >= GROUND_BORDER &&   
        targets[selected_target].min_distance < ground_min_dis && 
        ( selected_target_region == LowerRight ||  selected_target_region == LowerLeft )
        )//check for ground lower
    {
        //ground should be avoided
        // decision--> "/increase height"
        // target-->  '-G'
        command = increase_altitude;
    }
    else if (targets[selected_target].borders.bottom <= CELLING_BORDER &&
        targets[selected_target].min_distance < celling_min_dis &&
        (selected_target_region == UpperRight ||  selected_target_region == UpperLeft )
        ) //check for celling upper
    {
        // celling should be avoided
        // decision--> "/Decrease height"
        // target-->  '-C'
        command = decrease_altitude;
    }
    else if (targets[selected_target].min_distance < forward_reaction_distance) //check for front object
    {
        // objects which should be Considred
        if (selected_target_region == UpperLeft)
        {
            // target-->  '-ul'
            if (targets[selected_target].borders.right >= DRONE_ZONE.top_left.y  &&
                targets[selected_target].borders.bottom >= DRONE_ZONE.top_left.x ) // object is in free zone
            {
                if (targets[selected_target].min_distance <= forward_stop_dis)
                    // decision--> "/stop and roatet to Right"
                    command = Right;
                else if (targets[selected_target].min_distance <= FORWARD_SLOW_DIS ) 
                    // decision--> "/slow Forward and roatet to Right"
                    command = slow_forward_and_right;
                else
                    // decision--> "/forward and slow roatet to Right"
                    command = care_forward_and_slow_right;
            }
            else if (targets[selected_target].borders.right >= CARE_ZONE.top_left.y  &&
                     targets[selected_target].borders.bottom >= CARE_ZONE.top_left.x ) // object is in care zone
            {
                if (targets[selected_target].min_distance <= forward_stop_dis)
                    // decision--> "/slow Forward and roatet to Right"
                    command = slow_forward_and_right;
                else
                    // decision--> "/forward and slow roatet to Right"
                    command = care_forward_and_slow_right;
            }
            else
                // decision--> "/forward and slow roatet to Right"
                command = care_forward;
        }
        else if ( selected_target_region == UpperRight)
        {
            // target-->  '-ur'
            if (targets[selected_target].borders.left <= DRONE_ZONE.bottom_righ.y &&
                targets[selected_target].borders.bottom >= DRONE_ZONE.top_left.x )// object is in free zone
            {
                if (targets[selected_target].min_distance <= forward_stop_dis)
                    // decision--> "/stop and roatet to Left"
                    command = left;
                else if (targets[selected_target].min_distance <= FORWARD_SLOW_DIS )  
                    // decision--> "/slow Forward and roatet to Left"
                    command = slow_forward_and_left ;
                else
                    // decision--> "/forward and slow roatet to Left"
                    command = care_forward_and_slow_left;
            }
            else if (targets[selected_target].borders.left <= CARE_ZONE.bottom_righ.y &&
                     targets[selected_target].borders.bottom >= CARE_ZONE.top_left.x ) // object is in care zone
            {
                if (targets[selected_target].min_distance <= forward_stop_dis)
                    // decision--> "/slow Forward and roatet to Left"
                    command = slow_forward_and_left ;
                else
                    // decision--> "/forward and slow roatet to Left"
                    command = care_forward_and_slow_left;
            }
            else
                // decision--> "/forward and slow roatet to Left"
                command = care_forward;
        }
        else if (selected_target_region == LowerLeft)
        {
            // target-->  '-ll'
            if (targets[selected_target].borders.right >= DRONE_ZONE.top_left.y &&
                targets[selected_target].borders.top <= DRONE_ZONE.bottom_righ.x )// object is in free zone /////////!!!
            {
                if (targets[selected_target].min_distance<forward_stop_dis)
                    // decision--> "/stop and roatet to Right"
                    command = Right;
                else if (targets[selected_target].min_distance< FORWARD_SLOW_DIS )  
                    // decision--> "/slow Forward and roatet to Right"
                    command = slow_forward_and_right;
                else
                    // decision--> "/forward and slow roatet to Right"
                    command = care_forward_and_slow_right;
            }
            else if (targets[selected_target].borders.right >= CARE_ZONE.top_left.y &&
                     targets[selected_target].borders.top <= CARE_ZONE.bottom_righ.x ) // object is in care zone
            {
                if (targets[selected_target].min_distance<forward_stop_dis)
                    // decision--> "/slow Forward and roatet to Right"
                    command = slow_forward_and_right;
                else
                    // decision--> "/forward and slow roatet to Right"
                    command = care_forward_and_slow_right;
            }
            else
                // decision--> "/forward and slow roatet to Right"
                command = care_forward;
        }
        else if (selected_target_region == LowerRight)
        {
            // target-->  '-lr'
            if (targets[selected_target].borders.left <= DRONE_ZONE.bottom_righ.y &&
                targets[selected_target].borders.top <= DRONE_ZONE.bottom_righ.x )// object is in free zone ////!!!!!!!!!!!!
            {
                if (targets[selected_target].min_distance<forward_stop_dis)
                    // decision--> "/stop and roatet to Left"
                    command = left;
                else if (targets[selected_target].min_distance<FORWARD_SLOW_DIS)
                    // decision--> "/slow Forward and roatet to Left"
                    command = slow_forward_and_left;
                else
                    // decision--> "/forward and slow roatet to Left"
                    command = care_forward_and_slow_left;
            }
            else if (targets[selected_target].borders.left <= CARE_ZONE.bottom_righ.y &&
                     targets[selected_target].borders.top <= CARE_ZONE.bottom_righ.x ) // object is in care zone
            {
                if (targets[selected_target].min_distance<forward_stop_dis)
                    // decision--> "/slow Forward and roatet to Left"
                    command = slow_forward_and_left;
                else
                    // decision--> "/forward and slow roatet to Left"
                    command = care_forward_and_slow_left;
            }
            else
                // decision--> "/forward and slow roatet to Left"
                command = care_forward;
        }
        else
            // target-->  '-err'
            // decision--> 'stop'
            command = Stop;           
    }
    else
        // object is out of range
        // decision--> "/slow Forward"
        // target-->  '-sf'
        command = care_forward;   


    //severity param
    // 0-1    0--> most severe   1--> ignoring
    if (targets[selected_target].min_distance <=forward_stop_dis )
        danger_severity = 0.0f;
    else if (targets[selected_target].min_distance <=FORWARD_SLOW_DIS )
        danger_severity = (float)(targets[selected_target].min_distance - forward_stop_dis)/(float)(FORWARD_SLOW_DIS - forward_stop_dis);
    else if (targets[selected_target].min_distance <= forward_reaction_distance )
        danger_severity = (float)(targets[selected_target].min_distance - FORWARD_SLOW_DIS)/(float)(forward_reaction_distance - FORWARD_SLOW_DIS);
    else
        danger_severity = 1.0;

    // Check for special situations
    enum MoveCommand r_command = Handle_Exception_Commands(command);
    //
    #ifdef IMAGE_PROCESS_DEBUG_PRINT

        DEBUG_PRINT("ToFDeck P.I. targets: %d_%d\t%d_%d_%d\n", object_num,in_danger_targets, selected_target,selected_target_region, targets[selected_target].min_distance);

        // DEBUG_PRINT("ToFDeck P.I. tar_borders: %d\t%d\t%d\t%d\n", targets[selected_target].borders.right,
        //                                                             targets[selected_target].borders.left,
        //                                                             targets[selected_target].borders.top,
        //                                                             targets[selected_target].borders.bottom); 
        switch (r_command)
        {
        case CommandError:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"CommandError"); 
            break;
        case Stop:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"Stop"); 
            break;
        case Fast_Right:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"Fast_Right"); 
            break;
        case Right:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"Right"); 
            break;
        case care_forward_and_slow_right:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"care_forward_and_slow_right"); 
            break;
        case slow_forward_and_right:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"slow_forward_and_right"); 
            break;
        case Fast_Left:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"Fast_Left"); 
            break;
        case left:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"left"); 
            break;
        case care_forward_and_slow_left:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"care_forward_and_slow_left"); 
            break;
        case slow_forward_and_left:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"slow_forward_and_left"); 
            break;
        case increase_altitude:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"increase_altitude"); 
            break;
        case decrease_altitude:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"decrease_altitude"); 
            break;
        case slow_forward:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"slow_forward"); 
            break;
        case care_forward:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"care_forward"); 
            break;
        case forward:
            DEBUG_PRINT("ToFDeck P.I. : %d/%s\n",r_command,"forward"); 
            break;
        default:
            DEBUG_PRINT("ToFDeck P.I. : %s\n","Should't be here!!"); 
            break;
        }    
    #endif    

    FlyCommand_t fly_command = {r_command, danger_severity};
    return fly_command;
}

enum MoveCommand Handle_Exception_Commands(enum MoveCommand current_command)
{
    enum MoveCommand refine_command = current_command;
    #define History_Length 5
    static enum MoveCommand previous_command[History_Length] = {CommandError} ;
    static uint8_t previous_command_index = 0;
    uint8_t left_commands = 0, right_commands=0;
    
    //hanlde convex situation
    for (int i =0; i< History_Length; i++)
    {
        if (previous_command[i] == Right)
            right_commands++;
        else if (previous_command[i]==left)
            left_commands++; 
    }
    if ((current_command == Right || current_command == left) 
        && right_commands+left_commands >= (0.75f* History_Length) ) 
    {
        if (right_commands > left_commands)
            refine_command = Fast_Right;
        else
            refine_command = Fast_Left;
    }
    // Check for table stuck situation
    //
    previous_command[previous_command_index++] = current_command;
    if (previous_command_index >= History_Length)
        previous_command_index = 0;
    //
    return refine_command;
}

PARAM_GROUP_START(ToF_FLY_PARAMS)
PARAM_ADD(PARAM_UINT16, React_dis, &forward_reaction_distance)
PARAM_ADD(PARAM_UINT16, SLOW_DIS, &FORWARD_SLOW_DIS)
PARAM_ADD(PARAM_UINT16, Stop_dis, &forward_stop_dis)
// PARAM_ADD(PARAM_FLOAT, FZ_minX, &DRONE_ZONE.top_left.x)
// PARAM_ADD(PARAM_FLOAT, FZ_minY, &DRONE_ZONE.top_left.y)
// PARAM_ADD(PARAM_FLOAT, FZ_maxX, &DRONE_ZONE.bottom_righ.x)
// PARAM_ADD(PARAM_FLOAT, FZ_maxY, &DRONE_ZONE.bottom_righ.y)
PARAM_GROUP_STOP(ToF_FLY_PARAMS)
