#ifndef FLY_CONTROL // include guard
#define FLY_CONTROL

// #include <string.h>
#include <stdint.h>
#include <stdbool.h>
// #include "deck.h"
// #include "debug.h"
// #include <string.h>
// #include <math.h>

#include "ToF_process.h"
// #include "param.h"
// #include "config_params.h"



#define COMMAND_VALID_TIME 4000

// #define START_TAKE_OFF_HEIGHT 0.6f
#define END_LANDING_HEIGHT 0.07f
#define MAX_HEIGHT 1.2f
#define MIN_HEIGHT 0.2f
#define MAX_YAW_RATE 60.0f
// #define MAX_VX 0.9f
#define MAX_VY 0.5f
#define MAX_VZ 0.5f
#define SLOW_VZ 0.05f
#define DELAY_TO_LAUNCH 500  //ms
#define DELAY_AFTER_LAUNCH 300  //ms
// #define MAX_AX 1.0f  //m/s^2  increasing accelartion limit
#define SLOW_VX_COEFF 0.4f
#define CARE_VX_COEFF 0.9f
#define FAST_ROT_COEFF 4.0f
#define SLOW_ROT_COEFF 0.7f
#define ROT_COEFF 1.0f
#define ALTITUDE_CHANGE_COEFF .5f
#define MAX_FLIGHT_DURATION 1000 //ms


bool fly_task(FlyCommand_t command);
void TakeOff(float height);
void Land(void);
void headToSetpoint(float x, float y, float z, float yaw);
setpoint_t CreateSetpoint(float x_vel, float y_vel, float z, float yaw_rate);
void setHoverSetPoint(float x_vel, float y_vel, float z_vel, float yaw_rate);
void positionSet(setpoint_t *setpoint, float x, float y, float z, float yaw);
uint32_t get_time_stamp();
void flight_test(void);


#endif /* FLY_CONTROL */
