
#include "system.h"
#include "FreeRTOS.h"
#include "task.h"
#include "motors.h"
#include "estimator_kalman.h"
#include "commander.h"
#include "deck.h"
#include "Fly_control.h"
#include <math.h>

#include "debug.h"
#include "log.h"
#include "param.h"
#include "pm.h"



uint32_t last_time = 0;
// static uint32_t delta_time = 0;
//flight parameters
volatile float current_height = 0.0;
//param
float MAX_VX = 1.0f;
float MAX_AX = 1.0f;
float MANOUVER_RATE = 1.0f;
float START_TAKE_OFF_HEIGHT= 0.6f;

//
extern uint16_t ToFly;
void flight_test(void)
{
    current_height = 0.6f;
    TakeOff(current_height);
    vTaskDelay(1000);
    // int i ;
    // for (i = 0; i<4;i++)
    // {
    //     fly_task(Right);
    //     vTaskDelay(1000);
    // }
    // for (i = 0; i<4;i++)
    // {
    //     fly_task(left);
    //     vTaskDelay(1000);
    // }
    // for (i = 0; i<1;i++)
    // {
    //     fly_task(forward);
    //     vTaskDelay(1000);
    // }
    // for (i = 0; i<4;i++)
    // {
    //     fly_task(decrease_altitude);
    //     vTaskDelay(500);
    // }
    // for (i = 0; i<7;i++)
    // {
    //     fly_task(increase_altitude);
    //     vTaskDelay(500);
    // }
    // for (i = 0; i<5;i++)
    // {
    //     fly_task(decrease_altitude);
    //     vTaskDelay(500);
    // }
    // for (i = 0; i<10;i++)
    // {
    //     fly_task(increase_altitude);
    //     vTaskDelay(500);
    // }
    Land();


}
bool fly_task(FlyCommand_t fly_command)
{
    static bool isFlying = false;
    //update time
    if (last_time == 0)
    {
        // delta_time = 0;
        last_time = get_time_stamp();
    }
    uint32_t delta =  get_time_stamp();
    if(
        (delta - last_time >= ToFly * MAX_FLIGHT_DURATION && isFlying == true) ||
        pmIsBatteryLow()
      )
    {
        // setHoverSetPoint(0.0f, 0.0f, 0.0f, 0.0f);
        // vTaskDelay(100);
        Land();
        commanderNotifySetpointsStop(50);
        // DEBUG_PRINT("Landed\n"); 
        isFlying = false;
        return isFlying;
    }

    // else
    // {
    //     // delta_time = get_time_stamp() - last_time;
    //     // last_time += delta_time;
    // }
    if ((isFlying == false && fly_command.command != take_off) || pmIsChargerConnected())
    {
        // commanderNotifySetpointsStop(50);
        return isFlying;
    }

    float Vx = 0; 
    float Vy = 0;
    float Vz = 0;
    float yaw_rate = 0 ;


    // Define start target point
    switch (fly_command.command)
    {
        case CommandError:
            if(isFlying)
            {
                isFlying = false;
                // Landing
                Land();
            }
            break;
        case Stop:
            Vx = 0; Vy = 0; Vz=0; yaw_rate= 0;
            break;
        case Fast_Right:
            yaw_rate = -1 * FAST_ROT_COEFF * MANOUVER_RATE  * MAX_YAW_RATE;
            break;
        case Right:
            yaw_rate = -1 *  ROT_COEFF * MANOUVER_RATE * MAX_YAW_RATE;
            break;
        case care_forward_and_slow_right:
            yaw_rate = -1 * SLOW_ROT_COEFF  * MANOUVER_RATE * MAX_YAW_RATE;
            Vx = ((fly_command.severity * (CARE_VX_COEFF - SLOW_VX_COEFF)) + SLOW_VX_COEFF) * MAX_VX;
            break;
        case slow_forward_and_right:
            yaw_rate = -1 * ROT_COEFF * MANOUVER_RATE * MAX_YAW_RATE;
            Vx = fly_command.severity * SLOW_VX_COEFF * MAX_VX;
            break;
        case Fast_Left:
            yaw_rate = FAST_ROT_COEFF * MANOUVER_RATE * MAX_YAW_RATE;
            break;
        case left:
            yaw_rate = ROT_COEFF * MANOUVER_RATE * MAX_YAW_RATE;
            break;
        case care_forward_and_slow_left:
            yaw_rate = SLOW_ROT_COEFF * MANOUVER_RATE * MAX_YAW_RATE;
            Vx =  ((fly_command.severity * (CARE_VX_COEFF - SLOW_VX_COEFF)) + SLOW_VX_COEFF) * MAX_VX;
            break;
        case slow_forward_and_left:
            yaw_rate = ROT_COEFF * MANOUVER_RATE * MAX_YAW_RATE;
            Vx = fly_command.severity * SLOW_VX_COEFF * MAX_VX;
            break;
        case increase_altitude:
            Vz = ALTITUDE_CHANGE_COEFF *  MAX_VZ;
            break;
        case decrease_altitude:
            Vz = -1 * ALTITUDE_CHANGE_COEFF *  MAX_VZ;
            break;
        case slow_forward:
            Vx = fly_command.severity * SLOW_VX_COEFF * MAX_VX;
            break;
        case care_forward:
            Vx =  ((fly_command.severity * (CARE_VX_COEFF - SLOW_VX_COEFF)) + SLOW_VX_COEFF)* MAX_VX;
            break;
        case forward:
            Vx = fly_command.severity * MAX_VX;
            break;
        case take_off:
            if(!isFlying)
            {
                isFlying = true;
                // Reset estimator
                estimatorKalmanInit();
                // Take off
                TakeOff(START_TAKE_OFF_HEIGHT);
                return isFlying;
            }
            break;
        case land:
            if(isFlying)
            {
                isFlying = false;
                // Landing
                Land();
                return isFlying;
            }
            break;
        default:
            break;
    }  
    // DEBUG_PRINT("ToFDeck F.C. Vx: %.2f\n",Vx); 
    setHoverSetPoint(Vx, Vy, Vz, yaw_rate);
    return isFlying;
}

// void flyCircle(point_t center, float radius, float phase, uint32_t duration_ms){
//     uint32_t step_delay_ms = 40;
//     uint32_t steps = duration_ms / step_delay_ms;
//     float loop_progress;
//     phase = phase * (float)M_PI / 180.0f;
//     for (uint32_t i = 0; i < steps; i++) {
//         loop_progress = (float)i / (float)steps;
//         float angle = loop_progress * 2 * (float)M_PI + phase;
//         float x = (float)cos(angle) * radius + center.x;
//         float y = (float)sin(angle) * radius + center.y;
//         headToSetpoint(x, y, center.z, 0);
//         DEBUG_PRINT("%.2f, %.2f \n", x, y);
//         vTaskDelay(step_delay_ms);
//     }
// }

void TakeOff(float height) {
    vTaskDelay(DELAY_TO_LAUNCH);
    point_t pos;
    memset(&pos, 0, sizeof(pos));
    estimatorKalmanGetEstimatedPos(&pos);

    uint32_t endheight = (uint32_t)(100 * (height - 0.3f));
    for(uint32_t i=0; i<endheight; i++) {
        headToSetpoint(pos.x, pos.y, 0.3f + (float)i / 100.0f, 0);
        vTaskDelay(30);
    }

    current_height = height;
    vTaskDelay(DELAY_AFTER_LAUNCH); // wait for being stablize
    // memset(&pos, 0, sizeof(pos));
    // estimatorKalmanGetEstimatedPos(&pos);
    // current_height = pos.z;


}

void Land(void) {
    point_t pos;
    memset(&pos, 0, sizeof(pos));
    estimatorKalmanGetEstimatedPos(&pos);

    float height = pos.z;
    float current_yaw = logGetFloat(logGetVarId("stateEstimate", "yaw"));

    for(int i=(int)100*height; i>100*END_LANDING_HEIGHT; i--) {
        // setHoverAltitude((float)i / 100.0f);
        headToSetpoint(pos.x, pos.y, (float)i / 100.0f, current_yaw);
        vTaskDelay(40);
    }
    current_height = 0;
    vTaskDelay(300);
    motorsSetRatio(MOTOR_M1, 0);
    motorsSetRatio(MOTOR_M2, 0);
    motorsSetRatio(MOTOR_M3, 0);
    motorsSetRatio(MOTOR_M4, 0);
    vTaskDelay(200);
}

// void flyToPoint(point_t targetPos){
//     float avg_vel = 0.5f;
//     uint32_t step_delay_ms = 40;

//     point_t startPos;
//     memset(&startPos, 0, sizeof(startPos));
//     estimatorKalmanGetEstimatedPos(&startPos);

//     float distX = targetPos.x - startP[pos.x;
//     float distY = targetPos.y - startPos.y;
//     float distance = sqrtf(powf(distX, 2) + powf(distY, 2));

//     float avg_time = 1000.0f * distance / avg_vel;

//     uint32_t steps = (uint32_t)(avg_time / (float) step_delay_ms);
//     for (uint32_t i = 0; i < steps; i++) {
//         headToSetpoint(startPos.x + i * distX / steps, startPos.y + i * distY / steps, targetPos.z, 0);
//         vTaskDelay(step_delay_ms);
//     }
//     for (uint32_t i = 0; i < 20; i++) {
//         headToSetpoint(targetPos.x, targetPos.y, targetPos.z, 0);
//         vTaskDelay(step_delay_ms);
//     }
// }

void headToSetpoint(float x, float y, float z, float yaw)
{
    setpoint_t setpoint;
    positionSet(&setpoint, x, y, z, yaw);
    commanderSetSetpoint(&setpoint, 3);
}

void setHoverAltitude(float z)
{
    setpoint_t setpoint = CreateSetpoint(0.0f, 0.0f, z, 0.0f);
    commanderSetSetpoint(&setpoint, 3);
}


void setHoverSetPoint(float x_vel, float y_vel, float z_vel, float yaw_rate)
{
    // point_t current_pos;
    // memset(&current_pos, 0, sizeof(current_pos));
    // estimatorKalmanGetEstimatedPos(&current_pos);
    // current_height = current_pos.z;

    //keep drone height at min level
    // if (current_height >MIN_HEIGHT  && current_height < MAX_HEIGHT)
    current_height += z_vel * (75.0f/1000.0f);

    if((float)fabs(z_vel - 0.0f) < 0.01f && (float)fabs(current_height - START_TAKE_OFF_HEIGHT) > 0.05f )
    {
        if (current_height > START_TAKE_OFF_HEIGHT)
            current_height -= SLOW_VZ * TOF_PERIOD;
        else
            current_height += SLOW_VZ * TOF_PERIOD;
    }

    // current_height = z;
    //control values and send 
    if (current_height < MIN_HEIGHT)
        current_height = MIN_HEIGHT;
    else if (current_height > MAX_HEIGHT)
        current_height= MAX_HEIGHT;
    
    // check for accelerations
    static float previous_vx = 0;

    if ((x_vel > previous_vx) && ((x_vel - previous_vx) > (MAX_AX*TOF_PERIOD)))
    {
        x_vel = previous_vx + (MAX_AX*TOF_PERIOD);
    }
    previous_vx = x_vel ;


    setpoint_t setpoint = CreateSetpoint(x_vel, y_vel, current_height, yaw_rate);
    commanderSetSetpoint(&setpoint, 3);

}


void positionSet(setpoint_t *setpoint, float x, float y, float z, float yaw)
{
    memset(setpoint, 0, sizeof(setpoint_t));

    setpoint->mode.x = modeAbs;
    setpoint->mode.y = modeAbs;
    setpoint->mode.z = modeAbs;

    setpoint->position.x = x;
    setpoint->position.y = y;
    setpoint->position.z = z;

    setpoint->mode.yaw = modeAbs;

    setpoint->attitude.yaw = yaw;

    setpoint->mode.roll = modeDisable;
    setpoint->mode.pitch = modeDisable;
    setpoint->mode.quat = modeDisable;
}


// PARAM_GROUP_START(UWB_COMMANDS)
// PARAM_ADD(PARAM_UINT8, start_flying, &start)
// PARAM_GROUP_STOP(UWB_COMMANDS)

setpoint_t CreateSetpoint(float x_vel, float y_vel, float z, float yaw_rate)
{
	setpoint_t setpoint;	
	memset(&setpoint, 0, sizeof(setpoint_t));
	setpoint.mode.x = modeVelocity;
	setpoint.mode.y = modeVelocity;
	setpoint.mode.z = modeAbs;
	setpoint.mode.yaw = modeVelocity;

	setpoint.velocity.x	= x_vel;
	setpoint.velocity.y	= y_vel;
	setpoint.position.z = z;
	setpoint.attitudeRate.yaw = yaw_rate;
	setpoint.velocity_body = true;
	return setpoint;
}

// void headToPosition(float x, float y, float z, float yaw)
// {
// 	setpoint_t setpoint;
// 	memset(&setpoint, 0, sizeof(setpoint_t));

// 	setpoint.mode.x = modeAbs;
// 	setpoint.mode.y = modeAbs;
// 	setpoint.mode.z = modeAbs;
// 	setpoint.mode.yaw = modeAbs;

// 	setpoint.position.x = x;
// 	setpoint.position.y = y;
// 	setpoint.position.z = z;
// 	setpoint.attitude.yaw = yaw;
// 	commanderSetSetpoint(&setpoint, 3);
// }

uint32_t get_time_stamp()
{
  uint32_t timestamp = ((long long)xTaskGetTickCount())/portTICK_RATE_MS;
  //DEBUG_PRINT("ToFDeck timestamp: %d (size: %d)\n", timestamp,sizeof(timestamp));
  return timestamp;
}




PARAM_GROUP_START(ToF_FLY_PARAMS)
PARAM_ADD(PARAM_FLOAT, MAX_VX, &MAX_VX)
PARAM_ADD(PARAM_FLOAT, MAX_AX, &MAX_AX)
PARAM_ADD(PARAM_FLOAT, ManouverR, &MANOUVER_RATE)
PARAM_ADD(PARAM_FLOAT, defaultH, &START_TAKE_OFF_HEIGHT)
PARAM_GROUP_STOP(ToF_FLY_PARAMS)