/* PMSIS includes */
#include "pmsis.h"
#include "bsp/ram.h"
#include "bsp/ram/hyperram.h"
//#include "testimage.h"
//#include "frame411_equalized.h"
#include "ImgIO.h"
#include "pulp_gmm.h"
#include "pulp_morph.h"
#include "equalize_hist.h"
#include "morph.h"
#include <string.h>


/* Image size */
#define FRAME411_HEIGHT 240
#define FRAME411_WIDTH 320

#define DATASET_S	34

#define PRINT_IMG

#define PARALLEL


//dmesg | grep tty
//minicom -s
#ifdef PRINT_IMG
uint8_t img_out[FRAME411_HEIGHT*FRAME411_WIDTH];
#define MAKEBN()	do{for (int t = 0; t < (width*height);t++){if (image[t]){img_out[t] = 255;}else{img_out[t] = 0;}}}while(0)
#endif
//source ~/gap_sdk/sourceme.sh
//cd ~/Desktop/spi_demo/
// make clean all run

static struct pi_device ram;
static struct pi_hyperram_conf conf;
static struct pi_device dma_device;
static GMM_Settings set;

// Operators
pulp_Hist_Operator * pulpHistop;
pulp_GMM_Operator * pulpGMMop;
pulp_morph_Operator * pulpMorphop;
m_kernel_t * Kl2;
#define GMM_HISTORY	2
#define GMM_MIX 3


void OpenCV_test(void)
{
	printf("Entering main controller\n");

	uint32_t errors = 0;
	unsigned int width, height;
	unsigned int image_size;
	unsigned int IsRGB;
	char name[100];
	int i;

	/* Init & open ram. */
	pi_hyperram_conf_init(&conf);
	pi_open_from_conf(&ram, &conf);
	if (pi_ram_open(&ram))
	{
		printf("Error ram open !\n");
		pmsis_exit(-3);
	}


	// GMM Inialization
	pulpGMMop = (pulp_GMM_Operator *) pmsis_l2_malloc(sizeof(pulp_GMM_Operator));
	pulpCV_fc_GMMInit(pulpGMMop, FRAME411_WIDTH, FRAME411_HEIGHT,
			GMM_HISTORY, GMM_MIX, &ram);


#ifdef PARALLEL
	// Open the Cluster
	struct pi_device cluster_dev;
	struct pi_cluster_conf conf;
	struct pi_cluster_task cluster_task;
	pi_cluster_conf_init(&conf);
	pi_open_from_conf(&cluster_dev, (void *)&conf);
	pi_cluster_open(&cluster_dev);
#endif

	pulpHistop = (pulp_Hist_Operator *) pmsis_l2_malloc(sizeof(pulp_Hist_Operator));
	pulpMorphop = (pulp_morph_Operator *) pmsis_l2_malloc(sizeof(pulp_morph_Operator));
	Kl2 = (m_kernel_t *) pmsis_l2_malloc(sizeof(m_kernel_t));

	// loop here
	for (i=0;i</*DATASET_S*/2;i++){

		// First read input image
		sprintf(name,"../../../pgm/i%d.pgm",i);
		unsigned char *image = ReadImageFromFile(name, &width, &height, NULL, &image_size);
		if (image == NULL) return;

		printf("New Img - W: %d, H: %d S: %d \r\n",width,height,image_size);

		printf("Eq. Hist. Start\r\n");
		//equalizeHist(image, image, width, height,0);

		// Hist Inialization
		pulpHistop->input_frame = image;
		pulpHistop->output_frame = image;
		pulpHistop->W_IMG = width;
		pulpHistop->H_IMG = height;
		pulpHistop->hist_sz = 0;
#ifdef PARALLEL
		//pi_cluster_send_task_to_cl(&cluster_dev,
		//		pi_cluster_task(&cluster_task, (void *)pulpCV_cl_Hist_Eq, pulpHistop));
#else
		pulpCV_fc_Hist_Eq(pulpHistop);
#endif
#ifdef PRINT_IMG
		//sprintf(name,"../../Eq%d.pgm",i);
		//WriteImageToFile(name, width, height, image);
#endif
		printf("GMM Start\r\n");
		pulpGMMop->input_frame = image;
		pulpGMMop->output_frame = image;	// inplace operation
#ifdef PARALLEL
		pi_cluster_send_task_to_cl(&cluster_dev,
				pi_cluster_task(&cluster_task, (void *)pulpCV_cl_GMMSubtract, pulpGMMop));
#else
		pulpCV_fc_GMMSubtract(pulpGMMop);
#endif
#ifdef PRINT_IMG
		MAKEBN();
		sprintf(name,"../../BG%d.pgm",i);
		WriteImageToFile(name, width, height, img_out);
#endif

		printf("Morph Start\r\n");
		*Kl2 = ConfigDefaultKernel(K_STAR_3);
		pulpMorphop->input_frame = image;
		pulpMorphop->output_frame = image;
		pulpMorphop->W_IMG = width;
		pulpMorphop->H_IMG = height;
		pulpMorphop->K = Kl2;
		pulpMorphop->mode = MORPH_CLOSING;
#ifdef PARALLEL
		//Closing(image, height, width, &dma_device, *Kl2 );
		pi_cluster_send_task_to_cl(&cluster_dev,
						pi_cluster_task(&cluster_task, (void *)pulpCV_cl_morph, pulpMorphop));
		pulpMorphop->mode = MORPH_OPENING;
		pi_cluster_send_task_to_cl(&cluster_dev,
								pi_cluster_task(&cluster_task, (void *)pulpCV_cl_morph, pulpMorphop));
		//Opening(image, height, width, &dma_device, KK );
#else
		pulpCV_fc_morph(pulpMorphop);
#endif
		ClearDefaultKernel(Kl2);
#ifdef PRINT_IMG
		MAKEBN();
		sprintf(name,"../../Morph%d.pgm",i);
		WriteImageToFile(name, width, height, img_out);
#endif

		pmsis_l2_malloc_free(image, image_size);

	}

	pi_ram_close(&ram);

	pmsis_exit(errors);
}

/* Program Entry. */
int main(void)
{

	printf("\n\n\t *** OPENCV Test ***\n\n");
	return pmsis_kickoff((void *) OpenCV_test);
}
