/*
 * pulp_morph.c
 * Tommaso Polonelli - tommaso.polonelli2@unibo.it
 *
 * Copyright (C) 2020 University of Bologna, Greenwaves Technolgies
 *
 * This software may be modified and distributed under the terms
 * of the MIT license.  See the LICENSE file for details.
 *
 * Created on: January 24, 2021
 *
 */

#ifndef LIB_PULP_MORPH_H_
#define LIB_PULP_MORPH_H_

#include "morph.h"

typedef enum e_morph_mod {
	MORPH_EROSION,
	MORPH_DILATION,
	MORPH_OPENING,
	MORPH_CLOSING
}e_morph_mod_e;

typedef struct{
	uint8_t * in;
	uint8_t * out;
	m_kernel_t K;
} pulp_morph_Operator_cl;

typedef struct{
	// IO L2 arrays
	uint8_t * input_frame;
	uint8_t * output_frame;
	int W_IMG;
	int H_IMG;
	m_kernel_t * K;
	e_morph_mod_e mode;
	//internal
	pulp_morph_Operator_cl * Kl1;
} pulp_morph_Operator;



void pulpCV_fc_morph(
		pulp_morph_Operator * pulpMorpop
);

void pulpCV_cl_morph(
		pulp_morph_Operator * pulpMorpop
);

#endif /* LIB_PULP_MORPH_H_ */
