#include "frame_diff.h"

uint8_t FrameDifference(
	uint8_t * input_frame, 			// input frame in L1 memory
	uint8_t * bckg_frame, 			// input frame in L1 memory	
	uint8_t * output_frame, 		// input frame in L1 memory
	FD_Settings * 	FDconf			// FD configuration structure
)
{
	uint8_t Threshold;
	int Iter, Remaining;
	v4u VecThr;
	int BlockSize 	= FDconf->BlockSize;
	int Mode 		= FDconf->Mode; 		//	FD_MODE_UPDATE_BKG || FD_MODE_NO_UPDATE_BKG

	if ((Mode == FD_MODE_UPDATE_BINTHR) || (Mode == FD_MODE_NO_UPDATE_BINTHR)){
		Threshold 	= FDconf->Threshold;
		VecThr 		= __builtin_pulp_pack4(
			(uint8_t)Threshold,(uint8_t)Threshold,
			(uint8_t)Threshold,(uint8_t)Threshold);
	}

	v4u * VecIn  = (v4u *) input_frame ;
	v4u * VecBckg= (v4u *) bckg_frame ;
	v4u * VecOut = (v4u *) output_frame ;
	Iter = BlockSize >> 2;
	Remaining = BlockSize & 0x03;

	switch(Mode){
		
		case FD_MODE_UPDATE_NOBIN:
			for (int i=0;i<Iter;i++){
				v4u VecMin	= __builtin_pulp_minu4(VecIn[i], VecBckg[i]);
				v4u VecMax 	= __builtin_pulp_maxu4(VecIn[i], VecBckg[i]);
				v4u VecDiff = VecMax - VecMin;
				VecBckg[i] 	= VecIn[i];
				VecOut[i] 	= VecDiff ;
			}
			for (int i=(Iter<<2); i<BlockSize; i++){
				uint8_t temp =  (uint8_t) __builtin_pulp_abs(input_frame[i]-bckg_frame[i]);
				bckg_frame[i] = input_frame[i];
				output_frame[i] = temp;
			}			
			break;
		
		case FD_MODE_NO_UPDATE_NOBIN:
			for (int i=0;i<Iter;i++){
				v4u VecMin 	= __builtin_pulp_minu4(VecIn[i], VecBckg[i]);
				v4u VecMax 	= __builtin_pulp_maxu4(VecIn[i], VecBckg[i]);
				v4u VecDiff = VecMax - VecMin;
				VecOut[i] 	= VecDiff;
			}
			for (int i=(Iter<<2); i<BlockSize; i++){
				output_frame[i] = (uint8_t) __builtin_pulp_abs(input_frame[i]-bckg_frame[i]) ;
			}
			break;
		
		case FD_MODE_UPDATE_BINTHR:	// OK
			for (int i=0;i<Iter;i++){
				v4u VecMin 	= __builtin_pulp_minu4(VecIn[i], VecBckg[i]);
				v4u VecMax 	= __builtin_pulp_maxu4(VecIn[i], VecBckg[i]);
				v4u VecDiff = VecMax - VecMin;
				VecBckg[i] 	= VecIn[i];
				VecOut[i] 	= (VecDiff > VecThr) ;
			}
			for (int i=(Iter<<2); i<BlockSize; i++){
				uint8_t temp = (__builtin_pulp_abs(input_frame[i]-bckg_frame[i]) > Threshold)? 255 : 0;
				bckg_frame[i] = input_frame[i];
				output_frame[i] = temp;
			}
			break;

		case FD_MODE_NO_UPDATE_BINTHR:	//OK
			for (int i=0;i<Iter;i++){
				v4u VecMin 	= __builtin_pulp_minu4(VecIn[i], VecBckg[i]);
				v4u VecMax 	= __builtin_pulp_maxu4(VecIn[i], VecBckg[i]);
				v4u VecDiff = VecMax - VecMin;
				VecOut[i] 	= (VecDiff > VecThr) ;
			}
			for (int i=(Iter<<2); i<BlockSize; i++){
				output_frame[i] = (__builtin_pulp_abs(input_frame[i]-bckg_frame[i]) > Threshold)? 255 : 0;
			}
			break;
	}


}


