/*
 * gmm.h
 *
 *  Created on: May 25, 2020
 *      Author: tp
 */

#ifndef GMM_H_
#define GMM_H_

/* PMSIS includes */
#include "pmsis.h"
#include "bsp/ram.h"
#include "bsp/ram/hyperram.h"

#include "fixed_p.h"

#define SILENT

#ifdef SILENT
#define PRINTF(...) ((void) 0)
#else
#define PRINTF printf
#endif  /* DEBUG */


typedef struct{
	unsigned short sigma;
	unsigned short mu;
	unsigned short weight;
}GMM;


typedef struct{
	/* image size */
	int ImgHeight;
	int ImgWidth;
	int ImgSize;
	int MaxModes;

	/* fixed point values */
	Fixed alpha;
	Fixed prune;
	Fixed one_minus_alpha;
	uint32_t Threshold;
	Fixed variance;
	Fixed max_variance;
	Fixed min_variance;
	Fixed complexity_prior;
	Fixed BG_Th;
} GMM_Settings;

uint8_t SubtractPixel(
	uint8_t pixel, 					// pixel value
	int pIdx,						// pixel index within the tile
	GMM *Gauss, 					// L2 address of the GMM tile
	GMM_Settings * 	GMMconf			// GMM configuration structure
);

#endif /* GMM_H_ */
