/*
 * equalize_hist.h
 * Tommaso Polonelli
 *
 * Copyright (C) 2016 ETH Zurich, University of Bologna
 * Copyright (C) 2018 Tommaso Polonelli
 *
 * This software may be modified and distributed under the terms
 * of the MIT license.  See the LICENSE file for details.
 *
 * Created on: May 25, 2020
 *
 */

#ifndef EQUALIZE_HIST_H_
#define EQUALIZE_HIST_H_


/* PMSIS includes */
#include "pmsis.h"
#include "bsp/ram.h"
#include "bsp/ram/hyperram.h"


typedef struct{
	// IO L2 arrays
	uint8_t * input_frame;
	uint8_t * output_frame;
	int * hist_tot;
	int * lut_tot;
	int W_IMG;
	int H_IMG;
	int hist_sz;
} pulp_Hist_Operator;

void pulpCV_cl_Hist_Eq(
		pulp_Hist_Operator * pulpHistop
);

void pulpCV_fc_Hist_Eq(
		pulp_Hist_Operator * pulpHistop
);


void equalizeHist(uint8_t* src, uint8_t* dst, int width, int height, int hist_sz);
void EqualizeHistLut_Run(int* lut, unsigned char* src, unsigned char* dst, int total);
void EqualizeScale_Run(int* lut, int* hist, int hist_sz, int total, int i);
void EqualizeHistCalcHist_Run (unsigned char *src, int* histogram, int total);



#endif /* EQUALIZE_HIST_H_ */
