
void timer_setup(void) {

  TIMER4_BASE->CR1 = TIMER_CR1_CEN | TIMER_CR1_ARPE;             // enable the timer counter
  TIMER4_BASE->CR2 = 0;                                          // set the unused register as zero
  TIMER4_BASE->SMCR = 0;                                         // set the unused register as zero
  TIMER4_BASE->DIER = 0;
  TIMER4_BASE->EGR = 0;
  TIMER4_BASE->CCMR1 = (0b110 << 4) | TIMER_CCMR1_OC1PE | (0b110 << 12) | TIMER_CCMR1_OC2PE;   //
  TIMER4_BASE->CCMR2 = (0b110 << 4) | TIMER_CCMR2_OC3PE | (0b110 << 12) | TIMER_CCMR2_OC4PE;
  TIMER4_BASE->CCER = TIMER_CCER_CC1E | TIMER_CCER_CC2E | TIMER_CCER_CC3E | TIMER_CCER_CC4E;   // enable the trigger on the rising edge
  TIMER4_BASE->PSC = 71;                                         // set the pre scale
  TIMER4_BASE->ARR = 5000;                                       // set the auto-reload register
  TIMER4_BASE->DCR = 0;                                          // set the unused register as zero

  TIMER4_BASE->CCR1 = 1000;                                      // set the compare register
  TIMER4_BASE->CCR2 = 1000;
  TIMER4_BASE->CCR3 = 1000;
  TIMER4_BASE->CCR4 = 1000;

  Timer2.attachCompare1Interrupt(handler_channel_1); // every time an interrupt occurs, the sub-rutine is executed
  TIMER2_BASE->CR1 = TIMER_CR1_CEN;                  // enable the timer counter
  TIMER2_BASE->CR2 = 0;                              // set the unused register as zeros
  TIMER2_BASE->SMCR = 0;                             // set the unused register as zeros
  TIMER2_BASE->DIER = TIMER_DIER_CC1IE;              // enables the timer to trigger an interrupt when a capture occurs
  TIMER2_BASE->EGR = 0;                              // set the unused register as zeros
  TIMER2_BASE->CCMR1 = TIMER_CCMR1_CC1S_INPUT_TI1;   // connect the input to the edge detector
  TIMER2_BASE->CCMR2 = 0;                            // set the unused register as zeros
  TIMER2_BASE->CCER = TIMER_CCER_CC1E;               // enable the trigger on the rising edge
  TIMER2_BASE->PSC = 71;                             // set the pre-scalar
  TIMER2_BASE->ARR = 0xFFFF;                         // set the auto-reload register
  TIMER2_BASE->DCR = 0;                              // set the unused register to zero

  pinMode(PB6, PWM);
  pinMode(PB7, PWM);
  pinMode(PB8, PWM);
  pinMode(PB9, PWM);

  delay(250);
}
