

void start_stop_takeoff(void) {

  // starting the motors: throttle low and yaw left
  if (drone_status == stopped && channel_3_new < 1050 && channel_4 < 1050) {
    drone_status = starting;
  }

  // motor started: throttle low and yaw middle
  if (drone_status == starting && channel_3_new < 1050 && channel_4 > 1450) {
    drone_status = started;
    throttle = motor_idle_speed;
    

    // after the motor is started, the drone take off automatically (flight_mode = 2) or manually (flight_mode = 1)
    // if the drone is in manually control mode
    if (flight_mode < 2) {
      takeoff_detected = 1;

      // reset the LQR attitude controller for a smooth take-off

    }
  }

  // when the drone is in automatic takeoff mode
  if (drone_status == started && takeoff_detected == 0) {
    throttle_increase_counter++;
    
    if (throttle < 1500 && throttle_increase_counter == 5) {
      throttle++;
      throttle_increase_counter = 0;
    }

    if (throttle >= 1500) {
      takeoff_detected = 1;
      setpoint_altitude = -3;
    }
  }


  // stop the motors: throttle low and yaw right
  if (drone_status == started && channel_3_new < 1050 && channel_4 > 1950) {
    drone_status = stopped;
    takeoff_detected = 0;
  }

}
