#include <SPI.h>
#include <SD.h>
#include <Wire.h>                                                                        //Include the Wire.h library to use I2C functionality so we can communicate with the gyro.TwoWire myWire(I2_C2, PB11, PB10);   
#include <SimpleKalmanFilter.h>
#include <BasicLinearAlgebra.h>                                                          //Include the  library BasicLinearAlgebra.h library to operate with matrix 
using namespace BLA;                                                                     //Necessary to use BasicLinearAlgebra.h

#define compass_address 0x0D
#define gyro_address 0x68
#define MS5611_address 0x77
#define stopped  0
#define starting 1
#define started  2

File myFile;
SimpleKalmanFilter KalmanFilter(0.1, 0.85, 0.01);

// some constant variables
const float rad2degree = 57.29578, degree2rad = 0.01745;
const float dist_per_lat_degree = 111195.0;


//LQR MATRIX AND VECTORS
//BLA::Matrix<3, 6> K_LQR = {223.6068, 0, 0, 61.2782, 0, 0,
//                           0, 264.5751, 0, 0, 70.4871, 0,
//                           0, 0, 316.2278, 0, 0, 580.2563};



//
//BLA::Matrix<3, 6> K_LQR = {223.6068, 0, 0, 63.4863, 0, 0,
//                           0, 264.5751, 0, 0, 73.2480, 0,
//                           0, 0, 316.2278, 0, 0, 600.3059};



// New LQR matrix with inertia moment multiply a scale factor and Q = diag[0.08 0.07 0.1 0.001 0.001 0.1]
//BLA::Matrix<3, 6> K_LQR = {282.8427, 0, 0, 69.5222, 0, 0,
//                           0, 264.5751, 0, 0, 73.2480, 0,
//                           0, 0, 316.2278, 0, 0, 600.3059};


// New LQR matrix with inertia moment multiply a scale factor and Q = diag[0.09 0.07 0.1 0.001 0.001 0.1]
BLA::Matrix<3, 6> K_LQR = {300.0000, 0, 0, 71.1749, 0, 0,
                           0, 264.5751, 0, 0, 73.2480, 0,
                           0, 0, 316.2278, 0, 0, 600.3059};





//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BLA::Matrix<6, 1> error_state = {0,
                                 0,
                                 0,
                                 0,
                                 0,
                                 0};

BLA::Matrix<3, 1> delta_PWM = {0,
                               0,
                               0};

// LQR controller for the position control
// X and Y position error state
BLA::Matrix<4, 1> error_position = {0,
                                    0,
                                    0,
                                    0};

BLA::Matrix<2, 4> K_position = { -0.1732, 0, -0.1932, 0,
                                 0, 0.1732, 0, 0.1932};
BLA::Matrix<2, 1> roll_pitch_desired = {0,
                                        0};
float x_error, x_error_previous, x_axis_velocity, x_error_adjust;
float y_error, y_error_previous, y_axis_velocity, y_error_adjust;
float roll_angle_desired, pitch_angle_desired;


//RECEIVER GLOBAL VARIABLES
int32_t channel_1 = 1500;
int32_t channel_2 = 1500;
int32_t channel_3 = 1000;
int32_t channel_4 = 1500;
int32_t channel_5;
int32_t channel_6;
int32_t channel_7;
int32_t channel_8;
int32_t measured_time, measured_time_start;
uint8_t channel_select_counter;


//IMU GLOBAL VARIABLES
int16_t gyro_x, gyro_y, gyro_z;
int32_t gyro_x_cal, gyro_y_cal, gyro_z_cal;
int16_t acc_x, acc_y, acc_z;
const int16_t acc_x_manual_cal_value = 191, acc_y_manual_cal_value = 54;                   // bias of the acc x and y output data
int16_t cal_gyro_int;
int32_t acc_total_vector;
float angle_roll_acc, angle_pitch_acc;
float angle_pitch = -1.0, angle_roll = 2.0, angle_yaw;
int16_t temperature;

// compass variable
const float declination = 2.87;
int16_t compass_x, compass_y, compass_z;
int16_t _vRaw[3] = {0, 0, 0};
float compass_x_horizontal, compass_y_horizontal, actual_compass_heading;
float course_a, course_b, course_c, base_course_mirrored, actual_course_mirrored;

//ATTITUDE CONTROLLER GLOBAL VARIABLES
float roll_sp, pitch_sp, yaw_sp;
int16_t esc_1, esc_2, esc_3, esc_4, channel_3_new;
float delta_PWM_x, delta_PWM_y, delta_PWM_z;

// GPS GLOBAL VARIABLES
uint8_t read_serial_byte, incomming_message[100], number_used_sats;
uint8_t waypoint_set;
uint16_t message_counter;
int16_t gps_add_counter;
int32_t l_lat_gps, l_lon_gps, lat_gps_previous, lon_gps_previous;
int32_t lat_gps_actual, lon_gps_actual, l_lat_waypoint, l_lon_waypoint;
float lat_gps_loop_add, lon_gps_loop_add, lat_gps_add, lon_gps_add;
uint8_t new_line_found, new_gps_data_available, new_gps_data_counter;
//uint8_t gps_rotating_mem_location, return_to_home_step;
//int32_t gps_lat_total_avarage, gps_lon_total_avarage;
//int32_t gps_lat_rotating_mem[40], gps_lon_rotating_mem[40];
//int32_t gps_lat_error, gps_lon_error;
//int32_t gps_lat_error_previous, gps_lon_error_previous;
uint32_t gps_watchdog_timer;
float l_lon_gps_float_adjust, l_lat_gps_float_adjust, gps_man_adjust_heading;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
uint8_t ii, MS5611_count;
uint16_t C[7];
//uint8_t temperature_counter, average_temperature_mem_location = 0;
//uint32_t raw_temperature_rotating_memory[6], raw_average_temperature_total;
uint8_t barometer_counter;
int64_t OFF, OFF_T1, SENS, SENS_T1;
uint32_t raw_pressure, raw_temperature;
//float actual_pressure, actual_pressure_slow, actual_pressure_fast, actual_pressure_diff;
//int32_t pressure_rotating_mem[25], pressure_total_avarage;
//uint8_t pressure_rotating_mem_location = 0;
int32_t dT, TEMP, P;
float T2 = 0, OFF2 = 0, SENS2 = 0;

// LQR controller for the altitude control
int16_t motor_idle_speed = 1000, max_throttle = 1700;;                                                   // the minimum throttle pulse of the motors
const float sea_level_pressure = 101325.0;
float z_setpoint, z_actual, z_error;
float actual_altitude, actual_altitude_estimated, ground_altitude, setpoint_altitude = 0, previous_altitude_estimated;
float velocity_buffer[25], velocity_total_average, z_axis_velocity;
uint8_t velocity_rotating_mem_location = 0;
//float return_to_home_decrease;
BLA::Matrix<1, 2> K_altitude = {31.6228, 12.5506};
float thrust_cmd;
int16_t throttle, throttle_LQR;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


// FLY WAYPOINTS GLOBAL VARIABLE
uint8_t fly_to_new_waypoint;


//OTHER VARIABLES
uint8_t flight_mode, takeoff_detected = 0, drone_status = stopped, throttle_increase_counter = 0;
uint8_t telemetry_loop_counter, loop_counter = 0, error, log_starting = 0;
int16_t receiver_watchdog;
uint32_t loop_timer;

uint32_t now_time, last_time;
float dt;

void setup() {
  pinMode(PC13, OUTPUT);
  digitalWrite(PC13, HIGH);                            // turn off the LED
  delay(50);

  Serial.begin(9600);                                  // the default baud rate of the telemetry is 9600
  delay(50);

  timer_setup();
  delay(50);

  gps_setup();
  delay(50);

  Wire.setClock(400000);                                  // set the I2C clock speed to 400kHz, needs to be called before the wire.begin() function
  Wire.begin();                                           // Start the I2C as master

  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  //  check the response of all sensors
  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  // check the respond of the IMU
  Wire.beginTransmission(gyro_address);                                                //Start communication with the MPU-6050.
  error = Wire.endTransmission();                                                      //End the transmission and register the exit status.
  while (error != 0) {                                                                  //Stay in this loop because the MPU-6050 did not responde.                                                                        //Set the error status to 1.
    Serial.println("Errore IMU non risponde");                                          //Show the error via serial.
    delay(4);
  }

  // check the respond of the compass
  Wire.beginTransmission(compass_address);
  error = Wire.endTransmission();
  while (error != 0) {
    Serial.println("Errore compass non risponde");
    delay(4);
  }

  // check the MS5611 barometer is responding
//  Wire.beginTransmission(MS5611_address);
//  error = Wire.endTransmission();
//  while (error != 0) {
//    Serial.println("Errore barometer non risponde");
//    delay(4);
//  }

  // set up and configure the MPU6050
  gyro_setup();

  // calibrate the gyro x, y, z offset
  calibrate_gyro();
  delay(50);

  // the following section calculate the initial roll, pitch, and heading of the quadcopter
  // read the acc_x, acc_y, and acc_z, calculate the initial roll and pitch angles by using the accelerometer output
  gyro_signalen();
  angle_roll = asin((float)acc_y / sqrt((acc_x * acc_x) + (acc_y * acc_y) + (acc_z * acc_z))) * rad2degree;
  angle_pitch = asin((float)acc_x / sqrt((acc_x * acc_x) + (acc_y * acc_y) + (acc_z * acc_z))) * rad2degree;

  // configure the QMC5883L compass module
  setup_compass();
  // read data and calculate initial heading
  read_compass();
  Azimuth_calc();
  angle_yaw = actual_compass_heading;                                             // the initial yaw angle is the angle calculated by the compass

  // read the constant calibration values from the memory of the barometer
  // these 2 byte values are stored in the memory location 0xA2 and up
  for (ii = 1; ii <= 6; ii++) {
    Wire.beginTransmission(MS5611_address);
    Wire.write(0xA0 + ii * 2);
    Wire.endTransmission();
    Wire.requestFrom(MS5611_address, 2);
    C[ii] = Wire.read() << 8 | Wire.read();
  }

  OFF_T1 = C[2] * pow(2, 16);
  SENS_T1 = C[1] * pow(2, 15);

  // the MS5611 needs a few readings to stabilize
  for (MS5611_count = 0; MS5611_count < 100; MS5611_count++) {
    read_barometer();
    delay(4);
  }
  // after the barometer reading is stable, record the initial ground altitude (the altitude of the points where the drone start take off)
  ground_altitude = actual_altitude_estimated;

  

  // file name: FlightTest              (test with old LQR matrix)
  //            FlightTest2             (test with new LQR matrix)

//  if (!SD.begin()) {
//    Serial.println("SD initialization failed!");
//    while(1);
//  }
//  myFile = SD.open("DATI.txt", FILE_WRITE);




  loop_timer = micros();
}


void loop() {
  now_time = micros();
  dt = (now_time - last_time) / 1000000.0;
  last_time = now_time;

  // define the flight mode of the quadcopter
  flight_mode = 1;                                       // the default setting of the drone is in manual control mode                                                           
  // channel 5 (Switch D) is used to change the flight mode of the drone, switch from 1000 to 2000
  if (channel_5 > 1500) flight_mode = 2;                 // switch the drone to autonomous flight mode


  gyro_signalen();                                       // Provide gyro and acceletrometer data and subtract calibration value form gyro
  angle_calc();                                          // Calcute angle from gyro and accelerometer data

  read_barometer();
  // read compass data and calculate heading angle
  read_compass();
  Azimuth_calc();

  gps_man_adjust_heading = angle_yaw;
  if (gps_add_counter >= 0) gps_add_counter--;
  read_gps();


  // calculate the roll, pitch, yaw setpoint, in autonomous flight mode, the roll pitch setpoints are calculated by the position controller
  // in manually controlled mode, the roll,pitch,yaw setpoint is given by the radio controller
  // if the drone is in autonomous flight mode and the waypoint is already set
  if (flight_mode >= 2 && waypoint_set == 1) {
    roll_sp = roll_angle_desired;
    pitch_sp = pitch_angle_desired;
    yaw_sp = 0;
  }
  else {
    if (channel_2 <= 1508 && channel_2 >= 1492) pitch_sp = 0;
    else if (channel_2 > 1508 || channel_2 < 1492) pitch_sp = map(channel_2, 1000, 2000, 15, -15);

    if (channel_1 <= 1508 && channel_1 >= 1492) roll_sp = 0;
    else if (channel_1 > 1508 || channel_1 < 1492) roll_sp = map(channel_1, 1000, 2000, -15, 15);

    if (channel_4 <= 1508 && channel_4 >= 1492) yaw_sp = 0;
    else if (channel_4 > 1508 || channel_4 < 1492) yaw_sp = map(channel_4, 1000, 2000, -100, 100);
  }

  // inner loop attitude LQR controller
  LQR_attitude();

  start_stop_takeoff();

  // limit the throttle input given by the stick from 1000~2000 to 1000~1700,
  channel_3_new = map(channel_3, 1000, 2000, 1000, max_throttle);                   // We map channel_3 to limit maximum throttle sent to motors
  if (channel_3_new < 1050) {                                                       // We need a dead band for throttle
    esc_1 = 1000;
    esc_2 = 1000;
    esc_3 = 1000;
    esc_4 = 1000;
  }

  // if the motor is started and the drone is flying
  if (drone_status == started && takeoff_detected == 1) {
    // if the drone is in autonomous flight mode
    if (flight_mode >= 2) {
      throttle = 1500 + throttle_LQR;
    }
    else {                                                                         // if the drone is in manually contrlled mode
      throttle = channel_3_new;
    }
  }

  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  //   calculate the esc
  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  // if the motor is started
  if (drone_status == started) {
    // max_throttle value is 1700
    if (throttle > max_throttle) throttle = max_throttle;                                                                       // limit the throttle
    esc_1 = throttle + delta_PWM_x + delta_PWM_y - delta_PWM_z;
    esc_2 = throttle - delta_PWM_x + delta_PWM_y + delta_PWM_z;
    esc_3 = throttle - delta_PWM_x - delta_PWM_y - delta_PWM_z;
    esc_4 = throttle + delta_PWM_x - delta_PWM_y + delta_PWM_z;

    // limit the esc values
    if (esc_1 > 1950) esc_1 = 1950;
    if (esc_1 < 1090) esc_1 = 1090;
    if (esc_2 > 1950) esc_2 = 1950;
    if (esc_2 < 1090) esc_2 = 1090;
    if (esc_3 > 1950) esc_3 = 1950;
    if (esc_3 < 1090) esc_3 = 1090;
    if (esc_4 > 1950) esc_4 = 1950;
    if (esc_4 < 1090) esc_4 = 1090;
  }
  else {
    esc_1 = 1000;
    esc_2 = 1000;
    esc_3 = 1000;
    esc_4 = 1000;
  }

  // ARM the quadcopter, the ARM should in manual control mode, in autonomous flight mode, the quadcopter can be armed
  if (flight_mode < 2 && channel_7 > 1500) {                                        // For security the left lever of FlySky fs-i6 can be lower to stop propellers
    esc_1 = 1000;
    esc_2 = 1000;
    esc_3 = 1000;
    esc_4 = 1000;

    TIMER4_BASE->CCR1 = esc_1;                                                       //Set the throttle receiver input pulse to the ESC 1 output pulse.
    TIMER4_BASE->CCR4 = esc_2;                                                       //Set the throttle receiver input pulse to the ESC 2 output pulse.
    TIMER4_BASE->CCR3 = esc_3;                                                       //Set the throttle receiver input pulse to the ESC 3 output pulse.
    TIMER4_BASE->CCR2 = esc_4;                                                       //Set the throttle receiver input pulse to the ESC 4 output pulse.
  }

  if (channel_7 <= 1500) {
    TIMER4_BASE->CCR1 = esc_1;                                                       //Set the throttle receiver input pulse to the ESC 1 output pulse.
    TIMER4_BASE->CCR4 = esc_2;                                                       //Set the throttle receiver input pulse to the ESC 2 output pulse.
    TIMER4_BASE->CCR3 = esc_3;                                                       //Set the throttle receiver input pulse to the ESC 3 output pulse.
    TIMER4_BASE->CCR2 = esc_4;                                                       //Set the throttle receiver input pulse to the ESC 4 output pulse.
    TIMER4_BASE->CNT = 5000;                                                         //Inizialize the conunter of Timer4 to update PWM signal
  }

//  myFile = SD.open("DATI.txt", FILE_WRITE);
//  if (channel_8 > 1500) {
//    //myFile.close();
//    log_starting = 1;
//  }
//  if (myFile) {
//    print_on();
//    //print_on();
//  }

  send_telemetry_data();

//  Serial.println(angle_roll);
//  Serial.print(',');
//  Serial.println(angle_pitch);

  while (micros() - loop_timer < 4000);                                            //We wait until 2500us are passed to have 400 Hz frequency
  loop_timer = micros();                                                           //We update loop_timer variable to know elapsed time from the loop beginning
}
