// functions used by the compass

// at startup the registers of the compass need to be set
void setup_compass(void) {
  _writeReg(0x0B, 0x01);                    // it is recommended that the 0x0B is written by 0x01
  setMode(0x01, 0x0C, 0x10, 0x00);          // set the compass to continuous mode, output data rate 200Hz, full-scale 8G and over sample 512;
}



//void set_compass_Calibration(int16_t x_min, int16_t x_max, int16_t y_min, int16_t y_max, int16_t z_min, int16_t z_max) {
//  _calibrationUse = true;
//
//  _vCalibration[0][0] = x_min;
//  _vCalibration[0][1] = x_max;
//  _vCalibration[1][0] = y_min;
//  _vCalibration[1][1] = y_max;
//  _vCalibration[2][0] = z_min;
//  _vCalibration[2][1] = z_max;
//}



//void _applyCalibration(void) {
//  int x_offset = (_vCalibration[0][0] + _vCalibration[0][1]) / 2;
//  int y_offset = (_vCalibration[1][0] + _vCalibration[1][1]) / 2;
//  int z_offset = (_vCalibration[2][0] + _vCalibration[2][1]) / 2;
//  int x_avg_delta = (_vCalibration[0][1] - _vCalibration[0][0]) / 2;
//  int y_avg_delta = (_vCalibration[1][1] - _vCalibration[1][0]) / 2;
//  int z_avg_delta = (_vCalibration[2][1] - _vCalibration[2][0]) / 2;
//
//  int avg_delta = (x_avg_delta + y_avg_delta + z_avg_delta) / 3;
//
//  float x_scale = (float)avg_delta / x_avg_delta;
//  float y_scale = (float)avg_delta / y_avg_delta;
//  float z_scale = (float)avg_delta / z_avg_delta;
//
//  _vCalibrated[0] = (_vRaw[0] - x_offset) * x_scale;
//  _vCalibrated[1] = (_vRaw[1] - y_offset) * y_scale;
//  _vCalibrated[2] = (_vRaw[2] - z_offset) * z_scale;
//}

void read_compass(void) {
  Wire.beginTransmission(compass_address);
  Wire.write(0x00);
  int8_t err = Wire.endTransmission();

  if (!err) {
    Wire.requestFrom(compass_address, (byte)6);
    _vRaw[0] = (int16_t)(Wire.read() | Wire.read() << 8);            // data output x
    _vRaw[1] = (int16_t)(Wire.read() | Wire.read() << 8);            // data output y
    _vRaw[2] = (int16_t)(Wire.read() | Wire.read() << 8);            // data output z

    //    if (_calibrationUse) {
    //      _applyCalibration();
    //    }
  }
}

void Azimuth_calc(void) {
  compass_x = _vRaw[0];
  compass_y = -1 * _vRaw[1];
  compass_z = -1 * _vRaw[2];

  // calculate the horizontal component Xh Yh for later calculate heading
  compass_x_horizontal = (float)compass_x * cos(angle_pitch * degree2rad) + (float)compass_y * sin(angle_roll * degree2rad) * sin(angle_pitch * degree2rad) + (float)compass_z * cos(angle_roll * degree2rad) * sin(angle_pitch * degree2rad);
  compass_y_horizontal = (float)compass_y * cos(angle_roll * degree2rad) - (float)compass_z * sin(angle_roll * degree2rad);

  // calculate the actual heading after getting the horizontal component
  if (compass_x_horizontal == 0) {
    if (compass_y_horizontal < 0) actual_compass_heading = 90;
    if (compass_y_horizontal > 0) actual_compass_heading = 270;
  } else if (compass_x_horizontal < 0) {
    actual_compass_heading = 180 - (atan(compass_y_horizontal / compass_x_horizontal)) * rad2degree;
  } else {
    if (compass_y_horizontal < 0) actual_compass_heading = -1 * (atan(compass_y_horizontal / compass_x_horizontal)) * rad2degree;
    if (compass_y_horizontal > 0) actual_compass_heading = 360 - (atan(compass_y_horizontal / compass_x_horizontal)) * rad2degree;
  }

  // add the declination angle
  actual_compass_heading += declination;
  if (actual_compass_heading < 0) actual_compass_heading += 360;
  else if (actual_compass_heading >= 360) actual_compass_heading -= 360;
}

void _writeReg(byte r, byte v) {
  Wire.beginTransmission(compass_address);
  Wire.write(r);
  Wire.write(v);
  Wire.endTransmission();
}

void setMode(byte mode, byte odr, byte rng, byte osr) {
  _writeReg(0x09, mode | odr | rng | osr);
}

// the following subrouting calculates the smallest difference between two heading values
float course_deviation(float course_b, float course_c) {
  course_a = course_b - course_c;
  if (course_a < -180 || course_a > 180) {
    if (course_c > 180)base_course_mirrored = course_c - 180;
    else base_course_mirrored = course_c + 180;
    if (course_b > 180)actual_course_mirrored = course_b - 180;
    else actual_course_mirrored = course_b + 180;
    course_a = actual_course_mirrored - base_course_mirrored;
  }
  return course_a;
}
