

void read_barometer(void) {
  barometer_counter ++;                                                         // initial is 0, 

  if (barometer_counter == 1) {                                                 // When the barometer_counter variable is 1.
    //Request temperature data
    Wire.beginTransmission(MS5611_address);                                     // Open a connection with the MS5611.
    Wire.write(0x54);                                                           // Send a 0x58 to indicate that we want to request the temperature data.
    Wire.endTransmission();                                                     // End the transmission with the MS5611.
  }

  if (barometer_counter == 2) {                                              
    //poll temperature data from MS-5611
    Wire.beginTransmission(MS5611_address);                                     //Open a connection with the MS5611
    Wire.write(0x00);                                                           //Send a 0 to indicate that we want to poll the requested data.
    Wire.endTransmission();                                                     //End the transmission with the MS5611.
    Wire.requestFrom(MS5611_address, 3);
    raw_temperature = Wire.read() << 16 | Wire.read() << 8 | Wire.read();
  }

  if (barometer_counter == 3) {
    //Request pressure data
    Wire.beginTransmission(MS5611_address);                                     // Open a connection with the MS5611
    Wire.write(0x44);                                                           // Send a 0x48 to indicate that we want to request the pressure data.
    Wire.endTransmission();
  }

  if (barometer_counter == 4) {
    // reset the barometer counter variable
    barometer_counter = 0;

    //poll pressure data from MS-5611
    Wire.beginTransmission(MS5611_address);                                  //Open a connection with the MS5611.
    Wire.write(0x00);                                                        //Send a 0 to indicate that we want to poll the requested data.
    Wire.endTransmission();                                                  //End the transmission with the MS5611.
    Wire.requestFrom(MS5611_address, 3);                                     //Poll 3 data bytes from the MS5611.
    raw_pressure = Wire.read() << 16 | Wire.read() << 8 | Wire.read();

    //Calculate pressure as explained in the datasheet of the MS-5611.
    dT = C[5];
    dT <<= 8;
    dT *= -1;
    dT += raw_temperature;
    TEMP = 2000 + (dT * (int32_t)C[6]) / pow(2, 23);
    OFF = OFF_T1 + ((int64_t)dT * (int64_t)C[4]) / pow(2, 7);
    SENS = SENS_T1 + ((int64_t)dT * (int64_t)C[3]) / pow(2, 8);

    // temperature compensation, compsesation is required when temperature is less than 20
    if (TEMP < 2000) {
      T2 = dT * dT / pow(2, 31);
      OFF2 = 2.5 * (TEMP - 2000) * (TEMP - 2000);
      SENS2 = 1.25 * (TEMP - 2000) * (TEMP - 2000);

      if (TEMP < -1500) {
        OFF2 = OFF2 + 7 * (TEMP + 1500) * (TEMP + 1500);
        SENS2 = SENS2 + 5.5 * (TEMP + 1500) * (TEMP + 1500);
      }
    }
    else {
      T2 = 0;
      OFF2 = 0;
      SENS2 = 0;
    }

    TEMP = TEMP - T2;
    OFF = OFF - OFF2;
    SENS = SENS - SENS2;
    
    // calculate the absolute pressure
    P = ((raw_pressure * SENS) / pow(2, 21) - OFF) / pow(2, 15);

    // calculate the altitude relative to the sea level according to the absolute pressure
    actual_altitude = 44330.77 * (1.0 - pow((float)P / sea_level_pressure, 0.19026));
    
    
    
    actual_altitude_estimated = KalmanFilter.updateEstimate(actual_altitude);



    // calculate the velocity using the absolute altitude, the calculated velocity can be used to determined if the drone is up or down
    velocity_total_average -= velocity_buffer[velocity_rotating_mem_location];                                  
    velocity_buffer[velocity_rotating_mem_location] = (previous_altitude_estimated - actual_altitude_estimated) * 62.5;                      
    velocity_total_average += velocity_buffer[velocity_rotating_mem_location];                                  
    previous_altitude_estimated = actual_altitude_estimated;                                                       
    velocity_rotating_mem_location++;                                                                        
    if (velocity_rotating_mem_location == 20) velocity_rotating_mem_location = 0;                            
    z_axis_velocity = velocity_total_average / 20.0;

    // calculate the z axis coordinate, 
    z_actual = ground_altitude - actual_altitude_estimated;
    
    // if the drone is in autonomous flight mode
    if (flight_mode >= 2 && takeoff_detected == 1) {
      // if the altitude setpoint is not set
      if (setpoint_altitude == 0) {
        setpoint_altitude = z_actual;                       // set the current z axis coordinate as the altitude setpoint
      }

      // calculate the LQR output of the altitude controller
      z_setpoint = setpoint_altitude;
      z_error = z_setpoint - z_actual;                      // calculate the error state

      // the following section the LQR controller command is computed
      thrust_cmd = K_altitude(0, 0) * z_error - K_altitude(0, 1) * z_axis_velocity;

      // convert the physical thrust to the PWM pulse width value
      throttle_LQR = -1 * thrust_cmd * 28.4091;
      

      
    }
    else if (flight_mode < 2 && setpoint_altitude != 0) {
      // reset all the controller variables
      setpoint_altitude = 0;
      z_setpoint = 0;
      z_actual = 0;
      z_error = 0;
      thrust_cmd = 0;
      throttle_LQR = 0;
    }
  }
}
