
void gyro_setup(void) {
  Wire.beginTransmission(gyro_address);                        //Start communication with the MPU-6050.
  Wire.write(0x6B);                                            //We want to write to the PWR_MGMT_1 register (6B hex).
  Wire.write(0x00);                                            //Set the register bits as 00000000 to activate the gyro.
  Wire.endTransmission();                                      //End the transmission with the gyro.

  Wire.beginTransmission(gyro_address);                        //Start communication with the MPU-6050.
  Wire.write(0x1B);                                            //We want to write to the GYRO_CONFIG register (1B hex).
  Wire.write(0x08);                                            //Set the register bits as 00001000 (500dps full scale).
  Wire.endTransmission();                                      //End the transmission with the gyro.

  Wire.beginTransmission(gyro_address);                        //Start communication with the MPU-6050.
  Wire.write(0x1C);                                            //We want to write to the ACCEL_CONFIG register (1C hex).
  Wire.write(0x10);                                            //Set the register bits as 00010000 (+/- 8g full scale range).
  Wire.endTransmission();                                      //End the transmission with the gyro.

  Wire.beginTransmission(gyro_address);                        //Start communication with the MPU-6050.
  Wire.write(0x1A);                                            //We want to write to the CONFIG register (1A hex).
  Wire.write(0x03);                                            //Set the register bits as 00000011 (Set Digital Low Pass Filter to ~43Hz).
  Wire.endTransmission();                                      //End the transmission with the gyro.
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//This subroutine handles the calibration of the gyro. It stores the avarage gyro offset of 2000 readings.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void calibrate_gyro(void) {
  gyro_x_cal = 0;
  gyro_y_cal = 0;
  gyro_z_cal = 0;
  for (cal_gyro_int = 1; cal_gyro_int <= 3000 ; cal_gyro_int++) {                      //Take 3000 readings for calibration.
    gyro_signalen();                                                                   //Read the gyro output.
    gyro_x_cal += gyro_x;                                                              //Ad roll value to gyro_roll_cal.
    gyro_y_cal += gyro_y;                                                              //Ad pitch value to gyro_pitch_cal.
    gyro_z_cal += gyro_z;                                                              //Ad yaw value to gyro_yaw_cal.
    delay(4);                                                                        //Small delay to simulate a 400Hz loop during calibration.
  }
  gyro_x_cal /= 3000;                                                                  //Divide the roll total by 2000.
  gyro_y_cal /= 3000;                                                                  //Divide the pitch total by 2000.
  gyro_z_cal /= 3000;                                                                  //Divide the yaw total by 2000.
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//This part reads the raw gyro and accelerometer data from the MPU-6050
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void gyro_signalen(void) {
  Wire.beginTransmission(gyro_address);                         //Start communication with the gyro.
  Wire.write(0x3B);                                             //Start reading @ register 0x3B and auto increment with every read.
  Wire.endTransmission();                                       //End the transmission.
  Wire.requestFrom(gyro_address, 14);                           //Request 14 bytes from the MPU 6050.
  acc_x = Wire.read() << 8 | Wire.read();                      //Add the low and high byte to the acc_x variable.
  acc_y = Wire.read() << 8 | Wire.read();                      //Add the low and high byte to the acc_y variable.
  acc_z = Wire.read() << 8 | Wire.read();                      //Add the low and high byte to the acc_z variable.
  temperature = Wire.read() << 8 | Wire.read();                //Add the low and high byte to the temperature variable.
  gyro_x = Wire.read() << 8 | Wire.read();                     //Read high and low part of the angular data.
  gyro_y = Wire.read() << 8 | Wire.read();                     //Read high and low part of the angular data.
  gyro_z = Wire.read() << 8 | Wire.read();                     //Read high and low part of the angular data.
  gyro_y *= -1;                                                  //Invert the direction of the axis.
  gyro_z *= -1;                                                  //Invert the direction of the axis.

  // substract the bias of the acc
  acc_x -= acc_x_manual_cal_value;
  acc_y -= acc_y_manual_cal_value;

  // subtract the bias of the gyro
  if (cal_gyro_int >= 3000) {
    gyro_x -= gyro_x_cal;                                        //Subtact the manual gyro roll calibration value.
    gyro_y -= gyro_y_cal;                                        //Subtact the manual gyro pitch calibration value.
    gyro_z -= gyro_z_cal;                                        //Subtact the manual gyro yaw calibration value.
  }
}


void angle_calc(void) {                                          //Gyro angle calculations . Note 0.00003817 = 1 / (400Hz x 65.5)
  angle_pitch  += (float)gyro_y * 0.00006107;                            //Calculate the traveled pitch angle and add this to the angle_pitch variable
  angle_roll   += (float)gyro_x * 0.00006107;                             //Calculate the traveled roll angle and add this to the angle_roll variable
  angle_yaw    += (float)gyro_z * 0.00006107;                              //Calculate the traveled yaw angle and add this to the angle_yaw variable.
  
  if (angle_yaw < 0) angle_yaw += 360;                           //If the compass heading becomes smaller then 0, 360 is added to keep it in the 0 till 360 degrees range.
  else if (angle_yaw >= 360) angle_yaw -= 360;                   //If the compass heading becomes larger then 360, 360 is subtracted to keep it in the 0 till 360 degrees range.
  
  //0.000000666 = 0.00003817 * (3.142(PI) / 180degr) The Arduino sin function is in radians
  angle_pitch -= angle_roll * sin((float)gyro_z * 0.000001066);                    //If the IMU has yawed transfer the roll angle to the pitch angel
  angle_roll += angle_pitch * sin((float)gyro_z * 0.000001066);                    //If the IMU has yawed transfer the pitch angle to the roll angel

  angle_yaw -= course_deviation(angle_yaw, actual_compass_heading) / 1200.0;
  if (angle_yaw < 0) angle_yaw += 360;
  else if (angle_yaw >= 360) angle_yaw -= 360;

  //Accelerometer angle calculations
  acc_total_vector = sqrt((acc_x * acc_x) + (acc_y * acc_y) + (acc_z * acc_z));     //Calculate the total accelerometer vector.
  if (abs(acc_y) < acc_total_vector) {                                              //Prevent the asin function to produce a NaN.
    angle_roll_acc = asin((float)acc_y / acc_total_vector) * rad2degree;                //Calculate the roll angle.
  }
  if (abs(acc_x) < acc_total_vector) {                                              //Prevent the asin function to produce a NaN.
    angle_pitch_acc = asin((float)acc_x / acc_total_vector) * rad2degree;               //Calculate the pitch angle.
  }

  // complementary fliter, changed the coefficient from 0.995 to 0.95 to increase the response speed                                                          
  angle_pitch = angle_pitch * 0.9996 + angle_pitch_acc * 0.0004;                //Correct the drift of the gyro pitch angle with the accelerometer pitch angle.
  angle_roll = angle_roll * 0.9996 + angle_roll_acc * 0.0004;                   //Correct the drift of the gyro roll angle with the accelerometer roll angle.

  //angle_pitch = angle_pitch * 0.995 + angle_pitch_acc * 0.005;
  //angle_roll = angle_roll * 0.995 + angle_pitch_acc * 0.005;
 
}
