
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//   functions used by the GPS module
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void gps_setup(void) {

  Serial2.begin(9600);
  delay(250);

  //Disable GPGSV messages by using the ublox protocol.
  uint8_t Disable_GPGSV[11] = {0xB5, 0x62, 0x06, 0x01, 0x03, 0x00, 0xF0, 0x03, 0x00, 0xFD, 0x15};
  Serial2.write(Disable_GPGSV, 11);
  delay(350);   //A small delay is added to give the GPS some time to respond @ 9600bps.

  //Set the refresh rate to 5Hz by using the ublox protocol.
  uint8_t Set_to_5Hz[14] = {0xB5, 0x62, 0x06, 0x08, 0x06, 0x00, 0xC8, 0x00, 0x01, 0x00, 0x01, 0x00, 0xDE, 0x6A};
  Serial2.write(Set_to_5Hz, 14);
  delay(350);   //A small delay is added to give the GPS some time to respond @ 9600bps.

  //Set the baud rate to 57.6kbps by using the ublox protocol.
  uint8_t Set_to_57kbps[28] = {0xB5, 0x62, 0x06, 0x00, 0x14, 0x00, 0x01, 0x00, 0x00, 0x00, 0xD0, 0x08, 0x00, 0x00,
                               0x00, 0xE1, 0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE2, 0xE1
                              };
  Serial2.write(Set_to_57kbps, 28);
  delay(200);

  Serial2.begin(57600);
  delay(200);
}



void read_gps(void) {
  while (Serial2.available() && new_line_found == 0) {                                                   //Stay in this loop as long as there is serial information from the GPS available.
    char read_serial_byte = Serial2.read();                                                              //Load a new serial byte in the read_serial_byte variable.
    if (read_serial_byte == '$') {                                                                       //If the new byte equals a $ character.
      for (message_counter = 0; message_counter <= 99; message_counter ++) {                             //Clear the old data from the incomming buffer array.
        incomming_message[message_counter] = '-';                                                        //Write a - at every position.
      }
      message_counter = 0;                                                                               //Reset the message_counter variable because we want to start writing at the begin of the array.
    }
    else if (message_counter <= 99) message_counter ++;                                                   //If the received byte does not equal a $ character, increase the message_counter variable.
    incomming_message[message_counter] = read_serial_byte;                                               //Write the new received byte to the new position in the incomming_message array.
    if (read_serial_byte == '*') new_line_found = 1;                                                     //Every NMEA line end with a *. If this character is detected the new_line_found variable is set to 1.
  }

  //If the software has detected a new NMEA line it will check if it's a valid line that can be used.
  if (new_line_found == 1) {                                                                             //If a new NMEA line is found.
    new_line_found = 0;                                                                                  //Reset the new_line_found variable for the next line.
    if (incomming_message[4] == 'L' && incomming_message[5] == 'L' && incomming_message[7] == ',') {     //When there is no GPS fix or latitude/longitude information available.
      digitalWrite(PC13, !digitalRead(PC13));                                                            //Change the LED on the STM32 to indicate GPS reception.
      //Set some variables to 0 if no valid information is found by the GPS module. This is needed for GPS lost when flying.
      l_lat_gps = 0;
      l_lon_gps = 0;
    
      lat_gps_actual = 0;
      lon_gps_actual = 0;
      
      lat_gps_previous = 0;
      lon_gps_previous = 0;
      
      number_used_sats = 0;
    }
    
    //If the line starts with GA and if there is a GPS fix we can scan the line for the latitude, longitude and number of satellites.
    if (incomming_message[4] == 'G' && incomming_message[5] == 'A' && (incomming_message[44] == '1' || incomming_message[44] == '2')) {
      lat_gps_actual = ((int)incomming_message[19] - 48) *  (long)10000000;                              //Filter the minutes for the GGA line multiplied by 10.
      lat_gps_actual += ((int)incomming_message[20] - 48) * (long)1000000;                               //Filter the minutes for the GGA line multiplied by 10.
      lat_gps_actual += ((int)incomming_message[22] - 48) * (long)100000;                                //Filter the minutes for the GGA line multiplied by 10.
      lat_gps_actual += ((int)incomming_message[23] - 48) * (long)10000;                                 //Filter the minutes for the GGA line multiplied by 10.
      lat_gps_actual += ((int)incomming_message[24] - 48) * (long)1000;                                  //Filter the minutes for the GGA line multiplied by 10.
      lat_gps_actual += ((int)incomming_message[25] - 48) * (long)100;                                   //Filter the minutes for the GGA line multiplied by 10.
      lat_gps_actual += ((int)incomming_message[26] - 48) * (long)10;                                    //Filter the minutes for the GGA line multiplied by 10.
      lat_gps_actual /= (long)6;                                                                         //To convert the minutes to degrees we need to divide the minutes by 6(the minutes have already multiplied by 10);
      lat_gps_actual += ((int)incomming_message[17] - 48) *  (long)100000000;                            //Add the degrees multiplied by 10.
      lat_gps_actual += ((int)incomming_message[18] - 48) *  (long)10000000;                             //Add the degrees multiplied by 10.
      lat_gps_actual /= 10;                                                                              //Divide everything by 10.

      lon_gps_actual = ((int)incomming_message[33] - 48) *  (long)10000000;                              //Filter the minutes for the GGA line multiplied by 10.
      lon_gps_actual += ((int)incomming_message[34] - 48) * (long)1000000;                               //Filter the minutes for the GGA line multiplied by 10.
      lon_gps_actual += ((int)incomming_message[36] - 48) * (long)100000;                                //Filter the minutes for the GGA line multiplied by 10.
      lon_gps_actual += ((int)incomming_message[37] - 48) * (long)10000;                                 //Filter the minutes for the GGA line multiplied by 10.
      lon_gps_actual += ((int)incomming_message[38] - 48) * (long)1000;                                  //Filter the minutes for the GGA line multiplied by 10.
      lon_gps_actual += ((int)incomming_message[39] - 48) * (long)100;                                   //Filter the minutes for the GGA line multiplied by 10.
      lon_gps_actual += ((int)incomming_message[40] - 48) * (long)10;                                    //Filter the minutes for the GGA line multiplied by 10.
      lon_gps_actual /= (long)6;                                                                         //To convert the minutes to degrees we need to divide the minutes by 6.
      lon_gps_actual += ((int)incomming_message[30] - 48) * (long)1000000000;                            //Add the degrees multiplied by 10.
      lon_gps_actual += ((int)incomming_message[31] - 48) * (long)100000000;                             //Add the degrees multiplied by 10.
      lon_gps_actual += ((int)incomming_message[32] - 48) * (long)10000000;                              //Add the degrees multiplied by 10.
      lon_gps_actual /= 10;                                                                              //Divide everything by 10.                                                

      number_used_sats = ((int)incomming_message[46] - 48) * (long)10;                                   //Filter the number of satillites from the GGA line.
      number_used_sats += (int)incomming_message[47] - 48;                                               //Filter the number of satillites from the GGA line.

      if (lat_gps_previous == 0 && lon_gps_previous == 0) {                                              //If this is the first time the GPS code is used.
        lat_gps_previous = lat_gps_actual;                                                               //Set the lat_gps_previous variable to the lat_gps_actual variable.
        lon_gps_previous = lon_gps_actual;                                                               //Set the lon_gps_previous variable to the lon_gps_actual variable.
      }

      lat_gps_loop_add = (float)(lat_gps_actual - lat_gps_previous) / 10.0;                              //Divide the difference between the new and previous latitude by ten.
      lon_gps_loop_add = (float)(lon_gps_actual - lon_gps_previous) / 10.0;                              //Divide the difference between the new and previous longitude by ten.

      l_lat_gps = lat_gps_previous;                                                                      //Set the l_lat_gps variable to the previous latitude value.
      l_lon_gps = lon_gps_previous;                                                                      //Set the l_lon_gps variable to the previous longitude value.

      lat_gps_previous = lat_gps_actual;                                                                 //Remember the new latitude value in the lat_gps_previous variable for the next loop.
      lon_gps_previous = lon_gps_actual;                                                                 //Remember the new longitude value in the lat_gps_previous variable for the next loop.

      // GPS simulation
      // the GPS refresh rate is 5Hz, which is 200ms
      //Between every 2 GPS measurments, 9 GPS values are simulated. the time between every two simulation is 20ms,
      gps_add_counter = 5;                                                                               //Set the gps_add_counter variable to 5 as a count down loop timer
      new_gps_data_counter = 9;                                                                          //Set the new_gps_data_counter to 9. This is the number of simulated values between 2 GPS measurements.
      lat_gps_add = 0;                                                                                   //Reset the lat_gps_add variable.
      lon_gps_add = 0;                                                                                   //Reset the lon_gps_add variable.
      new_gps_data_available = 1;                                                                        //Set the new_gps_data_available to indicate that there is new data available.
    }
  }

  // After 5 program loops 5 x 4ms = 20ms the gps_add_counter is 0. one GPS position simulation
  if (gps_add_counter == 0 && new_gps_data_counter > 0) {                                                 //If gps_add_counter is 0 and there are new GPS simulations needed.
    new_gps_data_available = 1;                                                                           //Set the new_gps_data_available to indicate that there is new data available.
    new_gps_data_counter --;                                                                              //Decrement the new_gps_data_counter so there will only be 9 simulations
    gps_add_counter = 5;                                                                                  //Set the gps_add_counter variable to 5 as a count down loop timer

    // use the l_lat_gps and l_lon_gps to store the value of the simulated current gps position
    lat_gps_add += lat_gps_loop_add;                                                                      //Add the simulated part to a buffer float variable because the l_lat_gps can only hold integers.
    if (abs(lat_gps_add) >= 1) {                                                                          //If the absolute value of lat_gps_add is larger then 1.
      l_lat_gps += (int)lat_gps_add;                                                                      //Increment the lat_gps_add value with the lat_gps_add value as an integer. So no decimal part.
      lat_gps_add -= (int)lat_gps_add;                                                                    //Subtract the lat_gps_add value as an integer so the decimal value remains.
    }

    lon_gps_add += lon_gps_loop_add;                                                                      //Add the simulated part to a buffer float variable because the l_lat_gps can only hold integers.
    if (abs(lon_gps_add) >= 1) {                                                                          //If the absolute value of lat_gps_add is larger then 1.
      l_lon_gps += (int)lon_gps_add;                                                                      //Increment the lat_gps_add value with the lat_gps_add value as an integer. So no decimal part.
      lon_gps_add -= (int)lon_gps_add;                                                                    //Subtract the lat_gps_add value as an integer so the decimal value remains.
    }
  }

  
  // run every 20ms (5 main program loop)
  if (new_gps_data_available) {                                                                           //If there is a new set of GPS data available.
    if (number_used_sats < 8) digitalWrite(PC13, !digitalRead(PC13));                          //Change the LED on the STM32 to indicate GPS reception.
    else digitalWrite(PC13, LOW);                                                              //Turn the LED on the STM solid on (LED function is inverted). Check the STM32 schematic.
    gps_watchdog_timer = millis();                                                                        //Reset the GPS watch dog tmer.
    new_gps_data_available = 0;                                                                           //Reset the new_gps_data_available variable.

    // if in autonomous flight mode and the waypoint is not set
    if (flight_mode >= 2 && waypoint_set == 0) {                                                          // If the flight mode is 3 (GPS hold) and no waypoints are set.
      waypoint_set = 1;                                                                                   // Indicate that the waypoints are set.
      l_lat_waypoint = l_lat_gps;                                                                         // Remember the current latitude as GPS hold waypoint.
      l_lon_waypoint = l_lon_gps;                                                                         // Remember the current longitude as GPS hold waypoint.
    }

    if (flight_mode >= 2 && waypoint_set == 1) {                                                          //If the GPS hold mode and the waypoints are stored.
      //GPS stick move adjustments
      if (flight_mode == 2 && takeoff_detected == 1 && fly_to_new_waypoint == 0) {                        // if in GPS hold mode, not in the waypoint fly mode
        l_lat_gps_float_adjust -= 0.0015 * (((channel_2 - 1500) * cos(gps_man_adjust_heading * degree2rad)) + ((channel_1 - 1500) * cos((gps_man_adjust_heading - 90) * degree2rad)));                                                            //North correction
        l_lon_gps_float_adjust += (0.0015 * (((channel_1 - 1500) * cos(gps_man_adjust_heading * degree2rad)) + ((channel_2 - 1500) * cos((gps_man_adjust_heading + 90) * degree2rad)))) / cos(((float)l_lat_gps / 1000000.0) * degree2rad);       //East correction
      }
      
      if (l_lat_gps_float_adjust > 1) {
        l_lat_waypoint++;
        l_lat_gps_float_adjust--;
      }
      if (l_lat_gps_float_adjust < -1) {
        l_lat_waypoint--;
        l_lat_gps_float_adjust++;
      }

      if (l_lon_gps_float_adjust > 1) {
        l_lon_waypoint++;
        l_lon_gps_float_adjust--;
      }
      if (l_lon_gps_float_adjust < -1) {
        l_lon_waypoint--;
        l_lon_gps_float_adjust++;
      }

      ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      //    LQR X-Y position contorller
      ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      // x and y axis error in meters
      x_error = (l_lat_waypoint - l_lat_gps) / 1000000.0 * dist_per_lat_degree;
      y_error = (l_lon_waypoint - l_lon_gps) / 1000000.0 * dist_per_lat_degree * cos((float)l_lat_gps / 1000000.0 * degree2rad);

      x_axis_velocity = (x_error_previous - x_error) * 50;
      y_axis_velocity = (y_error_previous - y_error) * 50;

      x_error_previous = x_error;                                                             //Remember the error for the next loop.
      y_error_previous = y_error;                                                             //Remember the error for the next loop.

      // when the nose of the drone is not heading to the north, a vertical rotation are required to adjust the x and y error state
      x_error_adjust = x_error * cos(gps_man_adjust_heading * degree2rad) + y_error * sin(gps_man_adjust_heading * degree2rad);
      y_error_adjust = -1 * x_error * sin(gps_man_adjust_heading * degree2rad) + y_error * cos(gps_man_adjust_heading * degree2rad);

      error_position = {x_error_adjust,
                        y_error_adjust,
                        -1 * x_axis_velocity,
                        -1 * y_axis_velocity};
      roll_pitch_desired = K_position * error_position;

      // saturation of the roll and pitch angle, limit the roll and pitch to -30~30 degrees
      roll_angle_desired  = roll_pitch_desired(1, 0) * rad2degree;
      pitch_angle_desired = roll_pitch_desired(0, 0) * rad2degree;

      // limit the angls to 30 degrees
      if (roll_angle_desired > 20) roll_angle_desired = 20;
      if (roll_angle_desired < -20) roll_angle_desired = -20;
      if (pitch_angle_desired > 20) pitch_angle_desired = 20;
      if (pitch_angle_desired < -20) pitch_angle_desired = -20;
    }
  }

  if (gps_watchdog_timer + 1000 < millis()) {                                                             //If the watchdog timer is exceeded the GPS signal is missing.
    if (flight_mode >= 2) {                                                                               //If flight mode is set to 3 (GPS hold).
      flight_mode = 1;                                                                                    //Set the flight mode to manually control
      error = 4;                                                                                          //Output an error.
    }
  }

  if (flight_mode < 2 && waypoint_set > 0) {                                                              //If the GPS hold mode is disabled and the waypoints are set.
    
    if (waypoint_set == 1) {
      waypoint_set = 0;
    }
    
    roll_angle_desired = 0;                                                                                  //Reset the gps_roll_adjust variable to disable the correction.
    pitch_angle_desired = 0;                                                                                 //Reset the gps_pitch_adjust variable to disable the correction.

    //Reset all the variables 
    l_lat_waypoint = 0;
    l_lon_waypoint = 0;

    // reset all the used variables
    x_error = 0;
    x_error_adjust = 0;
    x_error_previous = 0;
    x_axis_velocity = 0;
    y_error = 0;
    y_error_adjust = 0;
    y_error_previous = 0;
    y_axis_velocity = 0;

    error_position = {0,
                      0,
                      0,
                      0};

    roll_pitch_desired = {0,
                          0};

  }
}
