//////////////////////////////////////////////////////////////////
//   LQR attitude controller
////////////////////////////////////////////////////////////////

void LQR_attitude(void) {
  

  error_state = {(roll_sp - angle_roll) * degree2rad,                          
                 (pitch_sp - angle_pitch) * degree2rad,                        
                 0,
                 0 - gyro_x_input * degree2rad,
                 0 - gyro_y_input * degree2rad,
                 (yaw_sp - gyro_z_input) * degree2rad};                             // control the anguler speed

  delta_PWM = K_LQR * error_state;

  if (delta_PWM(0,0) > 300) delta_PWM(0,0) = 300; 
  if (delta_PWM(0,0) < -300) delta_PWM(0,0) = -300;

  if (delta_PWM(1,0) > 300) delta_PWM(1,0) = 300; 
  if (delta_PWM(1,0) < -300) delta_PWM(1,0) = -300;

  if (delta_PWM(2,0) > 200) delta_PWM(2,0) = 200;  
  if (delta_PWM(2,0) < -200) delta_PWM(2,0) = -200;

  delta_PWM_x = delta_PWM(0,0);
  delta_PWM_y = delta_PWM(1,0);
  delta_PWM_z = delta_PWM(2,0);
  
}
