clear
close all
clc

V = 2;              % selecter model
mass = 1.7;         % drone mass
g = 9.81;
L = 0.15;
Ix = 0.023;
Iy = 0.028;
Iz = 0.02;
angle = 45;         % angle between the body of the quadcopter and the body frame
b = 5e-6;           % lift coefficient
Jr = 1e-6;          % inertia of moment of the motor rotor
tau = 0.02;         % time constant of the motor
n_F = 0.0088;       % linear relationship of the PWM signal and thrust produced by the motor
n_T = 0.00001336;   % linear relationship of the PWM signal and thrque produced by the motor

B4 = 4*L*sind(angle)/Ix*n_F;
B5 = 4*L*sind(angle)/Iy*n_F;
B6 = 4/Iz*n_T;

I = [Ix; Iy; Iz];

% measure noise covariance
Rn = 1e-4;
ts = 0.004;

%% ATTITUDE LQR CONTROLLER
A = [zeros(3,3) eye(3,3); zeros(3,3) [0 0 0; 0 0 0; 0 0 0]];
B = [zeros(3,3); [B4 0 0; 0 B5 0; 0 0 B6]];
C = [1 0 0 0 0 0;
     0 1 0 0 0 0;
     0 0 1 0 0 0];


% attitude LQR controller with integration
% A_bar = [A zeros(6,3);
%          -C zeros(3,3)];
% B_bar = [B; zeros(3,3)];
% R = eye(3)*1e-6; 
% Q = diag([0.05 0.07 0.1 0.001 0.001 0.1 1 1 1]);
% K_attitude_bar = lqr(A_bar, B_bar, Q, R);
% 
% K_attitude = K_attitude_bar(:,1:6);
% K_i_attitude = K_attitude_bar(:,7:9);

% Q = diag([0.05 0.07 0.1 0.001 0.001 0.1])


% attitude LQR controller without integration
R = eye(3)*1e-6;
Q = diag([0.05 0.1 0.1 0.001 0.001 0.1]); 
K_attitude = lqr(A, B, Q, R);

%% ALTITUDE LQR CONTROLLER WITH INTEGRATION
A_h = [0 1; 0 0];
B_h = [0; 1/mass];
C_h = [1 0];

A_h_bar = [A_h zeros(2,1);
           -C_h 0];
B_h_bar = [B_h; 0];


% with integration
% R_h = 0.01;
% Q_h = diag([10, 0.5 100]);
% 
% K_altitude_bar = lqr(A_h_bar, B_h_bar, Q_h, R_h);
% 
% K_altitude = K_altitude_bar(:,1:2);
% K_i_altitude = K_altitude_bar(:,3);


% without integration
R_h = 0.01;
Q_h = diag([10, 0.5]);

%Q_h = diag([10000, 0.5]);
K_altitude = lqr(A_h, B_h, Q_h, R_h);





%% POSITION LQR CONTROLLER
A_p = [0 0 1 0;
       0 0 0 1;
       0 0 0 0;
       0 0 0 0];

B_p = [0 0;
       0 0;
       -g 0;
       0 g];

R_p = eye(2)*500;
Q_p = diag([15 15 1 1]);
K_position = lqr(A_p, B_p, Q_p, R_p);


open('lqr_drone_sim.slx')

% handle=get_param('lqr_drone_sim','handle');
% print(handle,'-dsvg','MyModel');
% winopen MyModel.svg;


%% trajectory
wpt = [ 0,0,0; 0,0,-3; 5,0,-3; 0,-5,-3;-5,0,-3;0,5,-3;5,0,-3;0,0,-3;0,0,0];
ToA = [ 0, 5, 10, 15, 20, 25, 30, 35, 40];
[ pos_ref, vel_ref, t_ref ] = trajplann3(wpt,ToA);
figure(1)
plot(t_ref,pos_ref(:,1), t_ref,pos_ref(:,2), t_ref,pos_ref(:,3));
grid on
legend('x','y','z')
title('position')
figure(2)
plot(t_ref,vel_ref(:,1), t_ref,vel_ref(:,2), t_ref,vel_ref(:,3));
grid on
legend('$u_{NED}$','$v_{NED}$','$w_{NED}$');
title('velocity')


%% plot

% x-position
figure(3)
plot(out.tout, out.x_sp.data, 'r','LineStyle','--','LineWidth',1.5)
hold on 
grid on
plot(out.tout, out.x_act.data, 'g', 'LineWidth',1.5)
xlabel('$time[t]$', 'Interpreter','latex','FontSize',15)
ylabel('$x[m]$','Interpreter','latex','FontSize',15)
legend('reference','response')

% y-position
figure(4)
plot(out.tout, out.y_sp.data, 'r','LineStyle','--','LineWidth',1.5)
hold on 
grid on
plot(out.tout, out.y_act.data, 'g','LineWidth',1.5)
xlabel('$time[t]$', 'Interpreter','latex','FontSize',15)
ylabel('$y[m]$','Interpreter','latex','FontSize',15)
legend('reference','response')

% z-altitude
figure(5)
plot(out.tout, out.z_sp.data, 'r','LineStyle','--','LineWidth',1.5)
hold on 
grid on
plot(out.tout, out.z_act.data, 'g','LineWidth',1.5)
xlabel('$time[t]$', 'Interpreter','latex','FontSize',15)
ylabel('$z[m]$','Interpreter','latex','FontSize',15)
legend('reference','response')

% x-velocity
figure(6)
plot(out.tout, out.x_velocity_sp.data, 'r', 'LineStyle','--','LineWidth',1.5)
hold on 
grid on
plot(out.tout, out.x_velocity_act.data, 'g', 'LineWidth',1.5)
xlabel('$time[t]$', 'Interpreter','latex','FontSize',15)
ylabel('$v_x[m/s]$','Interpreter','latex','FontSize',15)
legend('reference','response')

% y-velocity
figure(7)
plot(out.tout, out.y_velocity_sp.data, 'r', 'LineStyle','--','LineWidth',1.5)
hold on 
grid on
plot(out.tout, out.y_velocity_act.data, 'g', 'LineWidth',1.5)
xlabel('$time[t]$', 'Interpreter','latex','FontSize',15)
ylabel('$v_y[m/s]$','Interpreter','latex','FontSize',15)
legend('reference','response')

figure(8)
plot(t_ref, vel_ref(:,3), 'r', 'LineStyle','--','LineWidth',1.5)
hold on 
grid on
plot(out.tout, out.z_velocity_act.data, 'g', 'LineWidth',1.5)
xlabel('$time[t]$', 'Interpreter','latex','FontSize',15)
ylabel('$v_z[m/s]$','Interpreter','latex','FontSize',15)
legend('reference','response','Location','best')



%% attitude step signal response
figure(9)
plot(out.tout, out.attitude_sp.data(:,1),'r','LineStyle','--','LineWidth',1.5)
hold on
grid on
plot(out.tout, out.attitude_act.data(:,1),'g','LineWidth',1.5)
xlabel('$time[t]$', 'Interpreter','latex','FontSize',15)
ylabel('$roll-angle[degree]$','Interpreter','latex','FontSize',15)
legend('reference','response')


figure(10)
plot(out.tout, out.attitude_sp.data(:,2),'r','LineStyle','--','LineWidth',1.5)
hold on
grid on
plot(out.tout, out.attitude_act.data(:,2),'g','LineWidth',1.5)
xlabel('$time[t]$', 'Interpreter','latex','FontSize',15)
ylabel('$pitch-angle[degree]$','Interpreter','latex','FontSize',15)
legend('reference','response')


figure(11)
plot(out.tout, out.attitude_sp.data(:,3),'r','LineStyle','--','LineWidth',1.5)
hold on
grid on
plot(out.tout, out.attitude_act.data(:,3),'g','LineWidth',1.5)
xlabel('$time[t]$', 'Interpreter','latex','FontSize',15)
ylabel('$yaw-angle[degree]$','Interpreter','latex','FontSize',15)
legend('reference','response')



