clear 
close all
clc

T = readtable("Log_2022-05-03_165033.csv");

T_torque_thrust = T(1717:2756, ["ESCSignal__s_", "Torque_N_m_", "Thrust_N_"]);

toDelete = isnan(T_torque_thrust.ESCSignal__s_);
T_torque_thrust(toDelete,:) = [];

for i = 0:1:634
    index = find(T_torque_thrust(:,1).ESCSignal__s_ == (1000+i));
    torque = sum(T_torque_thrust(index,:).Torque_N_m_,1)/length(index);
    thrust = sum(T_torque_thrust(index,:).Thrust_N_,1)/length(index);
    data(i+1,1) = (1000+i);
    data(i+1,2) = torque;
    data(i+1,3) = thrust;
end

delete_nan = isnan(data(:,2));
data(delete_nan,:) = [];

data_final = data(21:end,:);

%% least square
N = length(data_final);
Phi = [data_final(:,1),ones(N,1)];
z_torque = -data_final(:,2);
p_torque = Phi\z_torque;

z_thrust = -data_final(:,3);
p_thrust = Phi\z_thrust;

%% plot

figure(1)
scatter(data_final(:,1), -data_final(:,2))
grid on
xlabel('$PWM(us)$','Interpreter','latex','FontSize',15);
ylabel('$torque(N*m)$','Interpreter','latex','FontSize',15)
title('$torque-PWM$','Interpreter','latex','FontSize',15)


signal = linspace(1100,1650,550);
torque_hat = p_torque(1)*signal + p_torque(2);
figure(2)
scatter(data_final(:,1), -data_final(:,2))
hold on
grid on
plot(signal,torque_hat,'r','LineWidth',2)
xlabel('$PWM(us)$','Interpreter','latex','FontSize',15);
ylabel('$torque(N*m)$','Interpreter','latex','FontSize',15)
title('$torque-PWM$','Interpreter','latex','FontSize',15)


figure(3)
scatter(data_final(:,1),-data_final(:,3))
grid on
xlabel('$PWM(us)$','Interpreter','latex','FontSize',15);
ylabel('$thrust(N)$','Interpreter','latex','FontSize',15);
title('$thrust-PWM$','Interpreter','latex','FontSize',15)

thrust_hat = p_thrust(1)*signal + p_thrust(2);
figure(4)
scatter(data_final(:,1), -data_final(:,3))
hold on
grid on
plot(signal,thrust_hat,'r','LineWidth',2)
xlabel('$PWM(us)$','Interpreter','latex','FontSize',15);
ylabel('$thrust(N)$','Interpreter','latex','FontSize',15);
title('$thrust-PWM$','Interpreter','latex','FontSize',15)
