clc
clear all
close all

load 'ps3_V05_dV15_CameraB_pB24_1.txt'
ps1_V05_dV1_CameraB_chiusa_1=ps3_V05_dV15_CameraB_pB24_1;

Pa=0.101325*1e6;
fs=1000;
m_T=(0.75+0.13);
D=16e-3;
d=6e-3;
Aa=pi*D^2/4;
Ab=pi*(D^2-d^2)/4;
F_LVDT=4.53;

PA=ps1_V05_dV1_CameraB_chiusa_1(:,1).*1e5+Pa;
PB=ps1_V05_dV1_CameraB_chiusa_1(:,2).*1e5+Pa;  
QA=-ps1_V05_dV1_CameraB_chiusa_1(:,3);
QB=-ps1_V05_dV1_CameraB_chiusa_1(:,4);
Flc=ps1_V05_dV1_CameraB_chiusa_1(:,5);
X=ps1_V05_dV1_CameraB_chiusa_1(:,6)*1e-3; %Posizione, m
Xd=ps1_V05_dV1_CameraB_chiusa_1(:,7)*0.2601; %Velocit m/s
V=ps1_V05_dV1_CameraB_chiusa_1(:,8);
time=(0:size(PA,1)-1)*1/fs;

Acc=diff(Xd)/(time(2)-time(1));
Acc=[Acc; Acc(end)];

Fi=m_T*Acc;
Fp=(PA-Pa)*Aa-(PB-Pa)*Ab;
Ff=Fp-Fi-F_LVDT; 



figure
plot(time(1:20:end),PA(1:20:end),'bo','LineWidth',1.5,'markersize',10),hold on
plot(time(1:20:end),PB(1:20:end),'ro','LineWidth',1.5,'markersize',10)
ylabel('P [$Pa$]','interpreter','latex'),xlabel('t [$s$]','interpreter','latex')
legend('$P_{r}$ Exp. Data','$P_{f}$ Exp. Data','FontSize',20,'interpreter','latex')
grid on,zoom on,
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)

figure
plot(time(1:20:end),X(1:20:end),'bo','LineWidth',1.5,'markersize',10)
ylabel('x [$m$]','interpreter','latex'),xlabel('t [$s$]','interpreter','latex')
grid on,zoom on,
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)

figure
plot(time(1:20:end),Xd(1:20:end),'-bo','LineWidth',1.5,'markersize',10)
ylabel('$\dot{x}$ [$m/s$]','interpreter','latex'),xlabel('t [$s$]','interpreter','latex')
grid on,zoom on,
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)

figure
plot(time(1:20:end),Ff(1:20:end),'-bo','LineWidth',1.5,'markersize',10)
ylabel('F$_{friction}$ [$N$]','interpreter','latex'),xlabel('t [$s$]','interpreter','latex')
grid on,zoom on,
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)

figure
plot(Xd(1:20:end),Ff(1:20:end),'-bo','LineWidth',1.5,'markersize',10)
ylabel('F$_{friction}$ [$N$]','interpreter','latex'),xlabel('$\dot{x}$ [$m/s$]','interpreter','latex')
grid on,zoom on,
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)

figure
plot(time(1:20:end),QA(1:20:end),'bo','LineWidth',1.5,'markersize',10),hold on
ylabel('Q$_{r}$ [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('t [$s$]','interpreter','latex')
grid on,zoom on,
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)

