close all
clear all
clc

Ts=293;              %Temperatura ambiente durante la prova [K]
k=1.4;               % Rapporto calori specifici
Rg=287.053;          %Costante dell'aria [J/kg/K]
Pa=0.101325;          %Pressione ambiente durante la prova
rho=Pa*1e6/(Rg*Ts);
cd_ISO=0.87;
bS=1/0.4;
b=0.46;
Ps=0.7+Pa;%MPa
cG=60000/rho;%da kg/s a l/min 
fs=100;
k=1.4;
Coeff_Al4=[0.041;0.125;0.24;0.36;0.5;0.63;0.765;0.8614;0.9463;1]; 
Coeff_Al_SC4=[0.044;0.12;0.23;0.36;0.493;0.635;0.76;0.85;0.94;1];
A_SCARICOMAN4=ones(10,1);
A_CARICOMAN4=ones(10,1);

load 'Scarico_7bar_55V_bocca4.txt'
Q4_55VS=Scarico_7bar_55V_bocca4(:,2);
Pserb_55VS=Scarico_7bar_55V_bocca4(:,3)*0.1+Pa;
load 'Scarico_7bar_6V_bocca4.txt'
Q4_6VS=Scarico_7bar_6V_bocca4(:,2);
Pserb_6VS=Scarico_7bar_6V_bocca4(:,3)*0.1+Pa;

time=(0:size(Q4_6VS,1)-1)*1/fs;
timeaddS=(0:size(Q4_55VS,1)-1)*1/fs;

load 'Scarico_7bar_65V_bocca4.txt'
Q4_65VS=Scarico_7bar_65V_bocca4(:,2);
Pserb_65VS=Scarico_7bar_65V_bocca4(:,3)*0.1+Pa;
load 'Scarico_7bar_7V_bocca4.txt'
Q4_7VS=Scarico_7bar_7V_bocca4(:,2);
Pserb_7VS=Scarico_7bar_7V_bocca4(:,3)*0.1+Pa;
load 'Scarico_7bar_75V_bocca4.txt'
Q4_75VS=Scarico_7bar_75V_bocca4(:,2);
Pserb_75VS=Scarico_7bar_75V_bocca4(:,3)*0.1+Pa;
load 'Scarico_7bar_8V_bocca4.txt'
Q4_8VS=Scarico_7bar_8V_bocca4(:,2);
Pserb_8VS=Scarico_7bar_8V_bocca4(:,3)*0.1+Pa;
load 'Scarico_7bar_85V_bocca4.txt'
Q4_85VS=Scarico_7bar_85V_bocca4(:,2);
Pserb_85VS=Scarico_7bar_85V_bocca4(:,3)*0.1+Pa;
load 'Scarico_7bar_9V_bocca4.txt'
Q4_9VS=Scarico_7bar_9V_bocca4(:,2);
Pserb_9VS=Scarico_7bar_9V_bocca4(:,3)*0.1+Pa;
load 'Scarico_7bar_95V_bocca4.txt'
Q4_95VS=Scarico_7bar_95V_bocca4(:,2);
Pserb_95VS=Scarico_7bar_95V_bocca4(:,3)*0.1+Pa;
load 'Scarico_7bar_10V_bocca4.txt'
Q4_10VS=Scarico_7bar_10V_bocca4(:,2);
Pserb_10VS=Scarico_7bar_10V_bocca4(:,3)*0.1+Pa;




%CARICO
load 'Apertura_7bar_55V_bocca4.txt'
Q4_55V=Apertura_7bar_55V_bocca4(:,2);
Pserb_55V=Apertura_7bar_55V_bocca4(:,3)*0.1+Pa;
load 'Apertura_7bar_6V_bocca4.txt'
Q4_6V=Apertura_7bar_6V_bocca4(:,2);
Pserb_6V=Apertura_7bar_6V_bocca4(:,3)*0.1+Pa;

timeadd=(0:size(Q4_6V,1)-1)*1/fs; 
time=(0:size(Q4_55V,1)-1)*1/fs; 


load 'Apertura_7bar_65V_bocca4.txt'
Q4_65V=Apertura_7bar_65V_bocca4(:,2);
Pserb_65V=Apertura_7bar_65V_bocca4(:,3)*0.1+Pa;
load 'Apertura_7bar_7V_bocca4.txt'
Q4_7V=Apertura_7bar_7V_bocca4(:,2);
Pserb_7V=Apertura_7bar_7V_bocca4(:,3)*0.1+Pa;
load 'Apertura_7bar_75V_bocca4.txt'
Q4_75V=Apertura_7bar_75V_bocca4(:,2);
Pserb_75V=Apertura_7bar_75V_bocca4(:,3)*0.1+Pa;
load 'Apertura_7bar_8V_bocca4.txt'
Q4_8V=Apertura_7bar_8V_bocca4(:,2);
Pserb_8V=Apertura_7bar_8V_bocca4(:,3)*0.1+Pa;
load 'Apertura_7bar_85V_bocca4.txt'
Q4_85V=Apertura_7bar_85V_bocca4(:,2);
Pserb_85V=Apertura_7bar_85V_bocca4(:,3)*0.1+Pa;
load 'Apertura_7bar_9V_bocca4.txt'
Q4_9V=Apertura_7bar_9V_bocca4(:,2);
Pserb_9V=Apertura_7bar_9V_bocca4(:,3)*0.1+Pa;
load 'Apertura_7bar_95V_bocca4.txt'
Q4_95V=Apertura_7bar_95V_bocca4(:,2);
Pserb_95V=Apertura_7bar_95V_bocca4(:,3)*0.1+Pa;
load 'Apertura_7bar_10V_bocca4.txt'
Q4_10V=Apertura_7bar_10V_bocca4(:,2);
Pserb_10V=Apertura_7bar_10V_bocca4(:,3)*0.1+Pa;
timeadd=(0:size(Q4_10V,1)-1)*1/fs;


massimi=[max(Q4_55V),max(Q4_6V),max(Q4_65V),max(Q4_7V),max(Q4_75V),max(Q4_8V),max(Q4_85V),max(Q4_9V),max(Q4_95V),max(Q4_10V)]';
for i=1:length(massimi)
A(i,1)=(massimi(i,1)/cG)/(cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6); % m^2
R(i,1)=sqrt(A(i,1)/pi); % m
end
A_max=max(A);

massimi=[max(abs(Q4_55VS)),max(abs(Q4_6VS)),max(abs(Q4_65VS)),max(abs(Q4_7VS)),max(abs(Q4_75VS)),max(abs(Q4_8VS)),max(abs(Q4_85VS)),max(abs(Q4_9VS)),max(abs(Q4_95VS)),max(abs(Q4_10VS))]';
for i=1:length(massimi)
AS(i,1)=(massimi(i,1)/cG)/(cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6); % m^2
R(i,1)=sqrt(AS(i,1)/pi); % m
end
A_maxS=max(AS);
V=linspace(5.5,10,10);

%% Confronto Qth/QISO

%V=6
for i=1:length(Pserb_6VS)
    A_effS=AS(2,1);
    R_manS=3.2e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN4(2,1)=A_manS;
    A_eqS=(4.425e-07)*V(1,2)-2.374e-06;
    A_eqmanS=(5.211e-07)*V(1,2)-2.745e-06;
    A_AlS=A_maxS*Coeff_Al_SC4(2,1);
%Subsonico
if Pserb_6VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_6VS(i)*1e6*A_effS*sqrt(1-((Pserb_6VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_6VS(i)*1e6*A_manS*sqrt(1-((Pserb_6VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_6VS(i)*1e6*A_eqS*sqrt(1-((Pserb_6VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_6VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_6VS(i)/Pa-bS)/(1-bS))^2);
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_6VS(i)*1e6*A_AlS*sqrt(1-((Pserb_6VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_6VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_6VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_6VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_6VS(i)*1e6*A_eqmanS;
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_6VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_6VS=G_ISOtS';
G_man_6VS=G_mantS';
G_eq_6VS=G_eqtS';
G_eqman_6VS=G_eqmantS';
G_Al_6VS=G_AltS';
end

for i=1:length(Pserb_6V)
    A_eff=A(2,1);
    R_man=2.8e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN4(2,1)=A_man;
    A_eq=(4.492e-07)*V(1,2)-2.405e-06;
    A_eqman=(4.01e-07)*V(1,2)-2.125e-06;
    A_Al=A_max*Coeff_Al4(2,1);
%Subsonico
if Pserb_6V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_6V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_6V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_6V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_6V(i)/Ps-b)/(1-b))^2);
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_6V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman;
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_6V=G_ISOt';
G_man_6V=G_mant';
G_eq_6V=G_eqt';
G_eqman_6V=G_eqmant';
G_Al_6V=G_Alt';
end


figure
plot(Pserb_6VS./Pa,Q4_6VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_6V./Pa,G_ISO_6V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_6VS./Pa,G_man_6VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_6VS./Pa,G_eq_6VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_6VS./Pa,G_eqman_6VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_6VS./Pa,G_Al_6VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_6V./Ps,Q4_6V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_6V./Ps,G_ISO_6V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_6V./Ps,G_man_6V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_6V./Ps,G_eq_6V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_6V./Ps,G_eqman_6V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_6V./Ps,G_Al_6V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{man}$','$Q_{eq.\ coeff}$','$Q_{eq.\ man}$','$Q_{coeff}$','FontSize',20,'interpreter','latex')

%V=65
for i=1:length(Pserb_65VS)
    A_effS=AS(3,1);
    R_manS=4.3e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN4(3,1)=A_manS;
    A_eqS=(4.425e-07)*V(1,3)-2.374e-06; 
    A_eqmanS=(5.211e-07)*V(1,3)-2.745e-06;
    A_AlS=A_maxS*Coeff_Al_SC4(3,1);
%Subsonico
if Pserb_65VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_65VS(i)*1e6*A_effS*sqrt(1-((Pserb_65VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_65VS(i)*1e6*A_manS*sqrt(1-((Pserb_65VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_65VS(i)*1e6*A_eqS*sqrt(1-((Pserb_65VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_65VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_65VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_65VS(i)*1e6*A_AlS*sqrt(1-((Pserb_65VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_65VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_65VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_65VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_65VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_65VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_65VS=G_ISOtS';
G_man_65VS=G_mantS';
G_eq_65VS=G_eqtS';
G_eqman_65VS=G_eqmantS';
G_Al_65VS=G_AltS';
end

for i=1:length(Pserb_65V)
    A_eff=A(3,1);
    R_man=3.8e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN4(3,1)=A_man;
    A_eq=(4.492e-07)*V(1,3)-2.405e-06;
    A_eqman=(4.01e-07)*V(1,3)-2.125e-06;
    A_Al=A_max*Coeff_Al4(3,1);
%Subsonico
if Pserb_65V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_65V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_65V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_65V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_65V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_65V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman; 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_65V=G_ISOt';
G_man_65V=G_mant';
G_eq_65V=G_eqt';
G_eqman_65V=G_eqmant';
G_Al_65V=G_Alt';
end


figure
plot(Pserb_65VS./Pa,Q4_65VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_65V./Pa,G_ISO_65V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_65VS./Pa,G_man_65VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_65VS./Pa,G_eq_65VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_65VS./Pa,G_eqman_65VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_65VS./Pa,G_Al_65VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_65V./Ps,Q4_65V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_65V./Ps,G_ISO_65V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_65V./Ps,G_man_65V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_65V./Ps,G_eq_65V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_65V./Ps,G_eqman_65V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_65V./Ps,G_Al_65V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{man}$','$Q_{eq.\ coeff}$','$Q_{eq.\ man}$','$Q_{coeff}$','FontSize',20,'interpreter','latex')

%V=7
for i=1:length(Pserb_7VS)
    A_effS=AS(4,1);
    R_manS=5.33e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN4(4,1)=A_manS;
    A_eqS=(4.425e-07)*V(1,4)-2.374e-06; 
    A_eqmanS=(5.211e-07)*V(1,4)-2.745e-06;
    A_AlS=A_maxS*Coeff_Al_SC4(4,1);
%Subsonico
if Pserb_7VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_7VS(i)*1e6*A_effS*sqrt(1-((Pserb_7VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_7VS(i)*1e6*A_manS*sqrt(1-((Pserb_7VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_7VS(i)*1e6*A_eqS*sqrt(1-((Pserb_7VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_7VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_7VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_7VS(i)*1e6*A_AlS*sqrt(1-((Pserb_7VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_7VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_7VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_7VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_7VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_7VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_7VS=G_ISOtS';
G_man_7VS=G_mantS';
G_eq_7VS=G_eqtS';
G_eqman_7VS=G_eqmantS';
G_Al_7VS=G_AltS';
end

for i=1:length(Pserb_7V)
    A_eff=A(4,1);
    R_man=4.66e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN4(4,1)=A_man;
    A_eq=(4.492e-07)*V(1,4)-2.405e-06;
    A_eqman=(4.01e-07)*V(1,4)-2.125e-06;
    A_Al=A_max*Coeff_Al4(4,1);
%Subsonico
if Pserb_7V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_7V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_7V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_7V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_7V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_7V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman; 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_7V=G_ISOt';
G_man_7V=G_mant';
G_eq_7V=G_eqt';
G_eqman_7V=G_eqmant';
G_Al_7V=G_Alt';
end


figure
plot(Pserb_7VS./Pa,Q4_7VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_7V./Pa,G_ISO_7V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_7VS./Pa,G_man_7VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_7VS./Pa,G_eq_7VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_7VS./Pa,G_eqman_7VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_7VS./Pa,G_Al_7VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_7V./Ps,Q4_7V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_7V./Ps,G_ISO_7V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_7V./Ps,G_man_7V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_7V./Ps,G_eq_7V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_7V./Ps,G_eqman_7V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_7V./Ps,G_Al_7V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{man}$','$Q_{eq.\ coeff}$','$Q_{eq.\ man}$','$Q_{coeff}$','FontSize',20,'interpreter','latex')

%V=7.5
for i=1:length(Pserb_75VS)
    A_effS=AS(5,1);
    R_manS=6.2e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN4(5,1)=A_manS;
    A_eqS=(4.425e-07)*V(1,5)-2.374e-06; 
    A_eqmanS=(5.211e-07)*V(1,5)-2.745e-06;
    A_AlS=A_maxS*Coeff_Al_SC4(5,1);
%Subsonico
if Pserb_75VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_75VS(i)*1e6*A_effS*sqrt(1-((Pserb_75VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_75VS(i)*1e6*A_manS*sqrt(1-((Pserb_75VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_75VS(i)*1e6*A_eqS*sqrt(1-((Pserb_75VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_75VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_75VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_75VS(i)*1e6*A_AlS*sqrt(1-((Pserb_75VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_75VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_75VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_75VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_75VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_75VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_75VS=G_ISOtS';
G_man_75VS=G_mantS';
G_eq_75VS=G_eqtS';
G_eqman_75VS=G_eqmantS';
G_Al_75VS=G_AltS';
end

for i=1:length(Pserb_75V)
    A_eff=A(5,1);
    R_man=5.44e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN4(5,1)=A_man;
    A_eq=(4.492e-07)*V(1,5)-2.405e-06;
    A_eqman=(4.01e-07)*V(1,5)-2.125e-06;
    A_Al=A_max*Coeff_Al4(5,1);
%Subsonico
if Pserb_75V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_75V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_75V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_75V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_75V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_75V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman;
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_75V=G_ISOt';
G_man_75V=G_mant';
G_eq_75V=G_eqt';
G_eqman_75V=G_eqmant';
G_Al_75V=G_Alt';
end


figure
plot(Pserb_75VS./Pa,Q4_75VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_75V./Pa,G_ISO_75V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_75VS./Pa,G_man_75VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_75VS./Pa,G_eq_75VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_75VS./Pa,G_eqman_75VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_75VS./Pa,G_Al_75VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_75V./Ps,Q4_75V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_75V./Ps,G_ISO_75V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_75V./Ps,G_man_75V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_75V./Ps,G_eq_75V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_75V./Ps,G_eqman_75V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_75V./Ps,G_Al_75V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{man}$','$Q_{eq.\ coeff}$','$Q_{eq.\ man}$','$Q_{coeff}$','FontSize',20,'interpreter','latex')

%V=8
for i=1:length(Pserb_8VS)
    A_effS=AS(6,1);
    R_manS=6.9e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN4(6,1)=A_manS;
    A_eqS=(4.425e-07)*V(1,6)-2.374e-06; 
    A_eqmanS=(5.211e-07)*V(1,6)-2.745e-06;
    A_AlS=A_maxS*Coeff_Al_SC4(6,1);
%Subsonico
if Pserb_8VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_8VS(i)*1e6*A_effS*sqrt(1-((Pserb_8VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_8VS(i)*1e6*A_manS*sqrt(1-((Pserb_8VS(i)/Pa-bS)/(1-bS))^2);
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_8VS(i)*1e6*A_eqS*sqrt(1-((Pserb_8VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_8VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_8VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_8VS(i)*1e6*A_AlS*sqrt(1-((Pserb_8VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_8VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_8VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_8VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_8VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_8VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_8VS=G_ISOtS';
G_man_8VS=G_mantS';
G_eq_8VS=G_eqtS';
G_eqman_8VS=G_eqmantS';
G_Al_8VS=G_AltS';
end

for i=1:length(Pserb_8V)
    A_eff=A(6,1);
    R_man=6.12e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN4(6,1)=A_man;
    A_eq=(4.492e-07)*V(1,6)-2.405e-06;
    A_eqman=(4.01e-07)*V(1,6)-2.125e-06;
    A_Al=A_max*Coeff_Al4(6,1);
%Subsonico
if Pserb_8V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_8V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_8V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_8V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_8V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_8V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman;
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_8V=G_ISOt';
G_man_8V=G_mant';
G_eq_8V=G_eqt';
G_eqman_8V=G_eqmant';
G_Al_8V=G_Alt';
end


figure
plot(Pserb_8VS./Pa,Q4_8VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_8V./Pa,G_ISO_8V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_8VS./Pa,G_man_8VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_8VS./Pa,G_eq_8VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_8VS./Pa,G_eqman_8VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_8VS./Pa,G_Al_8VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_8V./Ps,Q4_8V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_8V./Ps,G_ISO_8V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_8V./Ps,G_man_8V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_8V./Ps,G_eq_8V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_8V./Ps,G_eqman_8V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_8V./Ps,G_Al_8V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{man}$','$Q_{eq.\ coeff}$','$Q_{eq.\ man}$','$Q_{coeff}$','FontSize',20,'interpreter','latex')

%V=8.5
for i=1:length(Pserb_85VS)
    A_effS=AS(7,1);
    R_manS=7.6e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN4(7,1)=A_manS;
    A_eqS=(4.425e-07)*V(1,7)-2.374e-06; 
    A_eqmanS=(5.211e-07)*V(1,7)-2.745e-06;
    A_AlS=A_maxS*Coeff_Al_SC4(7,1);
%Subsonico
if Pserb_85VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_85VS(i)*1e6*A_effS*sqrt(1-((Pserb_85VS(i)/Pa-bS)/(1-bS))^2);
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_85VS(i)*1e6*A_manS*sqrt(1-((Pserb_85VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_85VS(i)*1e6*A_eqS*sqrt(1-((Pserb_85VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_85VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_85VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_85VS(i)*1e6*A_AlS*sqrt(1-((Pserb_85VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_85VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_85VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_85VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_85VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_85VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_85VS=G_ISOtS';
G_man_85VS=G_mantS';
G_eq_85VS=G_eqtS';
G_eqman_85VS=G_eqmantS';
G_Al_85VS=G_AltS';
end

for i=1:length(Pserb_85V)
    A_eff=A(7,1);
    R_man=6.72e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN4(7,1)=A_man;
    A_eq=(4.492e-07)*V(1,7)-2.405e-06;
    A_eqman=(4.01e-07)*V(1,7)-2.125e-06;
    A_Al=A_max*Coeff_Al4(7,1);
%Subsonico
if Pserb_85V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_85V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_85V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_85V(i)/Ps-b)/(1-b))^2);
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_85V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_85V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman; 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_85V=G_ISOt';
G_man_85V=G_mant';
G_eq_85V=G_eqt';
G_eqman_85V=G_eqmant';
G_Al_85V=G_Alt';
end


figure
plot(Pserb_85VS./Pa,Q4_85VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_85V./Pa,G_ISO_85V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_85VS./Pa,G_man_85VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_85VS./Pa,G_eq_85VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_85VS./Pa,G_eqman_85VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_85VS./Pa,G_Al_85VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_85V./Ps,Q4_85V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_85V./Ps,G_ISO_85V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_85V./Ps,G_man_85V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_85V./Ps,G_eq_85V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_85V./Ps,G_eqman_85V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_85V./Ps,G_Al_85V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{man}$','$Q_{eq.\ coeff}$','$Q_{eq.\ man}$','$Q_{coeff}$','FontSize',20,'interpreter','latex')

%V=9
for i=1:length(Pserb_9VS)
    A_effS=AS(8,1);
    R_manS=8e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN4(8,1)=A_manS;
    A_eqS=(4.425e-07)*V(1,8)-2.374e-06; 
    A_eqmanS=(5.211e-07)*V(1,8)-2.745e-06;
    A_AlS=A_maxS*Coeff_Al_SC4(8,1);
%Subsonico
if Pserb_9VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_9VS(i)*1e6*A_effS*sqrt(1-((Pserb_9VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_9VS(i)*1e6*A_manS*sqrt(1-((Pserb_9VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_9VS(i)*1e6*A_eqS*sqrt(1-((Pserb_9VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_9VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_9VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_9VS(i)*1e6*A_AlS*sqrt(1-((Pserb_9VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_9VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_9VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_9VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_9VS(i)*1e6*A_eqmanS;
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_9VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_9VS=G_ISOtS';
G_man_9VS=G_mantS';
G_eq_9VS=G_eqtS';
G_eqman_9VS=G_eqmantS';
G_Al_9VS=G_AltS';
end

for i=1:length(Pserb_9V)
    A_eff=A(8,1);
    R_man=7e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN4(8,1)=A_man;
    A_eq=(4.492e-07)*V(1,8)-2.405e-06;
    A_eqman=(4.01e-07)*V(1,8)-2.125e-06;
    A_Al=A_max*Coeff_Al4(8,1);
%Subsonico
if Pserb_9V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_9V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_9V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_9V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_9V(i)/Ps-b)/(1-b))^2);
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_9V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman;
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_9V=G_ISOt';
G_man_9V=G_mant';
G_eq_9V=G_eqt';
G_eqman_9V=G_eqmant';
G_Al_9V=G_Alt';
end


figure
plot(Pserb_9VS./Pa,Q4_9VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_9V./Pa,G_ISO_9V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_9VS./Pa,G_man_9VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_9VS./Pa,G_eq_9VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_9VS./Pa,G_eqman_9VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_9VS./Pa,G_Al_9VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_9V./Ps,Q4_9V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_9V./Ps,G_ISO_9V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_9V./Ps,G_man_9V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_9V./Ps,G_eq_9V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_9V./Ps,G_eqman_9V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_9V./Ps,G_Al_9V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{man}$','$Q_{eq.\ coeff}$','$Q_{eq.\ man}$','$Q_{coeff}$','FontSize',20,'interpreter','latex')

%V=95
for i=1:length(Pserb_95VS)
    A_effS=AS(9,1);
    R_manS=8.25e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN4(9,1)=A_manS;
    A_eqS=(4.425e-07)*V(1,9)-2.374e-06; 
    A_eqmanS=(5.211e-07)*V(1,9)-2.745e-06;
    A_AlS=A_maxS*Coeff_Al_SC4(9,1);
%Subsonico
if Pserb_95VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_95VS(i)*1e6*A_effS*sqrt(1-((Pserb_95VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_95VS(i)*1e6*A_manS*sqrt(1-((Pserb_95VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_95VS(i)*1e6*A_eqS*sqrt(1-((Pserb_95VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_95VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_95VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_95VS(i)*1e6*A_AlS*sqrt(1-((Pserb_95VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_95VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_95VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_95VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_95VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_95VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_95VS=G_ISOtS';
G_man_95VS=G_mantS';
G_eq_95VS=G_eqtS';
G_eqman_95VS=G_eqmantS';
G_Al_95VS=G_AltS';
end

for i=1:length(Pserb_95V)
    A_eff=A(9,1);
    R_man=7.27e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN4(9,1)=A_man;
    A_eq=(4.492e-07)*V(1,9)-2.405e-06;
    A_eqman=(4.01e-07)*V(1,9)-2.125e-06;
    A_Al=A_max*Coeff_Al4(9,1);
%Subsonico
if Pserb_95V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_95V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_95V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_95V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_95V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_95V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman; 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_95V=G_ISOt';
G_man_95V=G_mant';
G_eq_95V=G_eqt';
G_eqman_95V=G_eqmant';
G_Al_95V=G_Alt';
end


figure
plot(Pserb_95VS./Pa,Q4_95VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_95V./Pa,G_ISO_95V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_95VS./Pa,G_man_95VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_95VS./Pa,G_eq_95VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_95VS./Pa,G_eqman_95VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_95VS./Pa,G_Al_95VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_95V./Ps,Q4_95V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_95V./Ps,G_ISO_95V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_95V./Ps,G_man_95V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_95V./Ps,G_eq_95V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_95V./Ps,G_eqman_95V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_95V./Ps,G_Al_95V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{man}$','$Q_{eq.\ coeff}$','$Q_{eq.\ man}$','$Q_{coeff}$','FontSize',20,'interpreter','latex')

%V=10
for i=1:length(Pserb_10VS)
    A_effS=AS(10,1);
    R_manS=8.65e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN4(10,1)=A_manS;
    A_eqS=(4.425e-07)*V(1,10)-2.374e-06;
    A_eqmanS=(5.211e-07)*V(1,10)-2.745e-06;
    A_AlS=A_maxS*Coeff_Al_SC4(10,1);
%Subsonico
if Pserb_10VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_10VS(i)*1e6*A_effS*sqrt(1-((Pserb_10VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_10VS(i)*1e6*A_manS*sqrt(1-((Pserb_10VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_10VS(i)*1e6*A_eqS*sqrt(1-((Pserb_10VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_10VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_10VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_10VS(i)*1e6*A_AlS*sqrt(1-((Pserb_10VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_10VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_10VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_10VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_10VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_10VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_10VS=G_ISOtS';
G_man_10VS=G_mantS';
G_eq_10VS=G_eqtS';
G_eqman_10VS=G_eqmantS';
G_Al_10VS=G_AltS';
end

for i=1:length(Pserb_10V)
    A_eff=A(10,1);
    R_man=7.44e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN4(10,1)=A_man;
    A_eq=(4.492e-07)*V(1,10)-2.405e-06;
    A_eqman=(4.01e-07)*V(1,10)-2.125e-06;
    A_Al=A_max*Coeff_Al4(10,1);
%Subsonico
if Pserb_10V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_10V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_10V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_10V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_10V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_10V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman; 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_10V=G_ISOt';
G_man_10V=G_mant';
G_eq_10V=G_eqt';
G_eqman_10V=G_eqmant';
G_Al_10V=G_Alt';
end


figure
plot(Pserb_10VS./Pa,Q4_10VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_10V./Pa,G_ISO_10V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_10VS./Pa,G_man_10VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_10VS./Pa,G_eq_10VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_10VS./Pa,G_eqman_10VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_10VS./Pa,G_Al_10VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_10V./Ps,Q4_10V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_10V./Ps,G_ISO_10V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_10V./Ps,G_man_10V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_10V./Ps,G_eq_10V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_10V./Ps,G_eqman_10V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_10V./Ps,G_Al_10V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{man}$','$Q_{eq.\ coeff}$','$Q_{eq.\ man}$','$Q_{coeff}$','FontSize',20,'interpreter','latex')


%V=5.5
for i=1:length(Pserb_55VS)
    A_effS=AS(1,1);
    R_manS=1.96e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN4(1,1)=A_manS;
    A_eqS=(4.425e-07)*V(1,1)-2.374e-06; 
    A_eqmanS=(5.211e-07)*V(1,1)-2.745e-06;
    A_AlS=A_maxS*Coeff_Al_SC4(1,1);
%Subsonico
if Pserb_55VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_55VS(i)*1e6*A_effS*sqrt(1-((Pserb_55VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_55VS(i)*1e6*A_manS*sqrt(1-((Pserb_55VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_55VS(i)*1e6*A_eqS*sqrt(1-((Pserb_55VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_55VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_55VS(i)/Pa-bS)/(1-bS))^2);
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_55VS(i)*1e6*A_AlS*sqrt(1-((Pserb_55VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_55VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_55VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_55VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_55VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_55VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_55VS=G_ISOtS';
G_man_55VS=G_mantS';
G_eq_55VS=G_eqtS';
G_eqman_55VS=G_eqmantS';
G_Al_55VS=G_AltS';
end

for i=1:length(Pserb_55V)
    A_eff=A(1,1);
    R_man=1.7e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN4(1,1)=A_man;
    A_eq=(4.492e-07)*V(1,1)-2.405e-06;
    A_eqman=(4.01e-07)*V(1,1)-2.125e-06;
    A_Al=A_max*Coeff_Al4(1,1);
%Subsonico
if Pserb_55V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_55V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_55V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_55V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_55V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_55V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff; 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman;
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; %

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_55V=G_ISOt';
G_man_55V=G_mant';
G_eq_55V=G_eqt';
G_eqman_55V=G_eqmant';
G_Al_55V=G_Alt';
end


figure
plot(Pserb_55VS./Pa,Q4_55VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_55V./Pa,G_ISO_55V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_55VS./Pa,G_man_55VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_55VS./Pa,G_eq_55VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_55VS./Pa,G_eqman_55VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_55VS./Pa,G_Al_55VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_55V./Ps,Q4_55V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_55V./Ps,G_ISO_55V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_55V./Ps,G_man_55V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_55V./Ps,G_eq_55V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_55V./Ps,G_eqman_55V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_55V./Ps,G_Al_55V.*cG,'MarkerSize',5,'linewidth',2),hold on
ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{man}$','$Q_{eq.\ coeff}$','$Q_{eq.\ man}$','$Q_{coeff}$','FontSize',20,'interpreter','latex')

%%
V=linspace(5.5,10,10);


myfittype = fittype('m*V+q',...
    'dependent',{'A_CARICOMAN4'},'independent',{'V'},...
    'coefficients',{'m','q'})
myfit = fit(V',A_CARICOMAN4,myfittype)

figure
plot(V,A_CARICOMAN4,'bo','MarkerSize',12,'linewidth',3), hold on 
plot(myfit,V,A_CARICOMAN4,'b')
ylabel('$A_{4}$ [$m^2$]','interpreter','latex'), xlabel(' V [$V$] ','interpreter','latex')
grid on, zoom on,  title('Sezione passaggio uscita 4')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)


myfittype1 = fittype('m*V+q',...
    'dependent',{'A_SCARICOMAN4'},'independent',{'V'},...
    'coefficients',{'m','q'})
myfit1 = fit(V',A_SCARICOMAN4,myfittype1)

figure
plot(V,A_SCARICOMAN4,'bo','MarkerSize',12,'linewidth',3), hold on 
plot(myfit1,V,A_SCARICOMAN4,'b')
ylabel('$A_{4}$ [$m^2$]','interpreter','latex'), xlabel(' V [$V$] ','interpreter','latex')
grid on, zoom on,  title('Sezione passaggio uscita 4')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)



