close all
clear all
clc

Ts=293;              %Temperatura ambiente durante la prova [K]
k=1.4;               % Rapporto calori specifici
Rg=287.053;          %Costante dell'aria [J/kg/K]
Pa=0.101325;          %Pressione ambiente durante la prova
rho=Pa*1e6/(Rg*Ts);
cd_ISO=0.87;
bS=1/0.4;
b=0.46;
Ps=0.4+Pa;%MPa
cG=60000/rho;%da kg/s a l/min 
fs=100;
k=1.4;
Coeff_Al2=[1;0.944;0.8712;0.7748;0.6594;0.5301;0.38;0.24;0.12;0.0315];
Coeff_Al_SC2=[1;0.9431;0.865;0.76;0.635;0.5;0.365;0.227;0.12;0.04];
A_SCARICOMAN2=ones(10,1);
A_CARICOMAN2=ones(11,1);

load 'Scarico_4bar_0V_bocca2.txt'
Q2_0VS=Scarico_4bar_0V_bocca2(:,1);
Pserb_0VS=Scarico_4bar_0V_bocca2(:,3)*0.1+Pa;
load 'Scarico_4bar_05V_bocca2.txt'
Q2_05VS=Scarico_4bar_05V_bocca2(:,1);
Pserb_05VS=Scarico_4bar_05V_bocca2(:,3)*0.1+Pa;

time=(0:size(Q2_05VS,1)-1)*1/fs;

load 'Scarico_4bar_1V_bocca2.txt'
Q2_1VS=Scarico_4bar_1V_bocca2(:,1);
Pserb_1VS=Scarico_4bar_1V_bocca2(:,3)*0.1+Pa;
load 'Scarico_4bar_15V_bocca2.txt'
Q2_15VS=Scarico_4bar_15V_bocca2(:,1);
Pserb_15VS=Scarico_4bar_15V_bocca2(:,3)*0.1+Pa;
load 'Scarico_4bar_2V_bocca2.txt'
Q2_2VS=Scarico_4bar_2V_bocca2(:,1);
Pserb_2VS=Scarico_4bar_2V_bocca2(:,3)*0.1+Pa;
load 'Scarico_4bar_25V_bocca2.txt'
Q2_25VS=Scarico_4bar_25V_bocca2(:,1);
Pserb_25VS=Scarico_4bar_25V_bocca2(:,3)*0.1+Pa;
load 'Scarico_4bar_3V_bocca2.txt'
Q2_3VS=Scarico_4bar_3V_bocca2(:,1);
Pserb_3VS=Scarico_4bar_3V_bocca2(:,3)*0.1+Pa;
load 'Scarico_4bar_35V_bocca2.txt'
Q2_35VS=Scarico_4bar_35V_bocca2(:,1);
Pserb_35VS=Scarico_4bar_35V_bocca2(:,3)*0.1+Pa;
load 'Scarico_4bar_4V_bocca2.txt'
Q2_4VS=Scarico_4bar_4V_bocca2(:,1);
Pserb_4VS=Scarico_4bar_4V_bocca2(:,3)*0.1+Pa;
load 'Scarico_4bar_45V_bocca2.txt'
Q2_45VS=Scarico_4bar_45V_bocca2(:,1);
Pserb_45VS=Scarico_4bar_45V_bocca2(:,3)*0.1+Pa;
timeaddS=(0:size(Q2_45VS,1)-1)*1/fs;

load 'Scarico_4bar_5V_bocca2.txt'
Q2_5VS=Scarico_4bar_5V_bocca2(:,1);
Pserb_5VS=Scarico_4bar_5V_bocca2(:,3)*0.1+Pa;

%CARICO
load 'Apertura_4bar_0V_bocca2.txt'
Q2_0V=Apertura_4bar_0V_bocca2(:,1);
Pserb_0V=Apertura_4bar_0V_bocca2(:,3)*0.1+Pa;
load 'Apertura_4bar_05V_bocca2.txt'
Q2_05V=Apertura_4bar_05V_bocca2(:,1);
Pserb_05V=Apertura_4bar_05V_bocca2(:,3)*0.1+Pa;

time=(0:size(Q2_05V,1)-1)*1/fs;

load 'Apertura_4bar_1V_bocca2.txt'
Q2_1V=Apertura_4bar_1V_bocca2(:,1);
Pserb_1V=Apertura_4bar_1V_bocca2(:,3)*0.1+Pa;
load 'Apertura_4bar_15V_bocca2.txt'
Q2_15V=Apertura_4bar_15V_bocca2(:,1);
Pserb_15V=Apertura_4bar_15V_bocca2(:,3)*0.1+Pa;
load 'Apertura_4bar_2V_bocca2.txt'
Q2_2V=Apertura_4bar_2V_bocca2(:,1);
Pserb_2V=Apertura_4bar_2V_bocca2(:,3)*0.1+Pa;
load 'Apertura_4bar_25V_bocca2.txt'
Q2_25V=Apertura_4bar_25V_bocca2(:,1);
Pserb_25V=Apertura_4bar_25V_bocca2(:,3)*0.1+Pa;
load 'Apertura_4bar_3V_bocca2.txt'
Q2_3V=Apertura_4bar_3V_bocca2(:,1);
Pserb_3V=Apertura_4bar_3V_bocca2(:,3)*0.1+Pa;
load 'Apertura_4bar_35V_bocca2.txt'
Q2_35V=Apertura_4bar_35V_bocca2(:,1);
Pserb_35V=Apertura_4bar_35V_bocca2(:,3)*0.1+Pa;
load 'Apertura_4bar_4V_bocca2.txt'
Q2_4V=Apertura_4bar_4V_bocca2(:,1);
Pserb_4V=Apertura_4bar_4V_bocca2(:,3)*0.1+Pa;
load 'Apertura_4bar_45V_bocca2.txt'
Q2_45V=Apertura_4bar_45V_bocca2(:,1);
Pserb_45V=Apertura_4bar_45V_bocca2(:,3)*0.1+Pa;
timeadd=(0:size(Q2_45V,1)-1)*1/fs;

load 'Apertura_4bar_5V_bocca2.txt'
Q2_5V=Apertura_4bar_5V_bocca2(:,1);
Pserb_5V=Apertura_4bar_5V_bocca2(:,3)*0.1+Pa;

massimi=[max(Q2_0V),max(Q2_05V),max(Q2_1V),max(Q2_15V),max(Q2_2V),max(Q2_25V),max(Q2_3V),max(Q2_35V),max(Q2_4V),max(Q2_45V),max(Q2_5V)]';
for i=1:length(massimi)
A(i,1)=(massimi(i,1)/cG)/(cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6); % m^2
R(i,1)=sqrt(A(i,1)/pi); % m
end
A_max=max(A);

massimi=[max(abs(Q2_0VS)),max(abs(Q2_05VS)),max(abs(Q2_1VS)),max(abs(Q2_15VS)),max(abs(Q2_2VS)),max(abs(Q2_25VS)),max(abs(Q2_3VS)),max(abs(Q2_35VS)),max(abs(Q2_4VS)),max(abs(Q2_45VS)),max(abs(Q2_5VS))]';
for i=1:length(massimi)
AS(i,1)=(massimi(i,1)/cG)/(cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6); % m^2
R(i,1)=sqrt(AS(i,1)/pi); % m
end
A_maxS=max(AS);
V=linspace(0,5,11);

%% Confronto Qth/QISO

%V=0.0
for i=1:length(Pserb_0VS)
    A_effS=AS(1,1);
    R_manS=8.46e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN2(1,1)=A_manS;
    A_eqS=(-4.147e-07)*V(1,1)+1.965e-06; 
    A_eqmanS=(-4.929e-07)*V(1,1)+2.372e-06;
    A_AlS=A_maxS*Coeff_Al_SC2(1,1);
%Subsonico
if Pserb_0VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_0VS(i)*1e6*A_effS*sqrt(1-((Pserb_0VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_0VS(i)*1e6*A_manS*sqrt(1-((Pserb_0VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_0VS(i)*1e6*A_eqS*sqrt(1-((Pserb_0VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_0VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_0VS(i)/Pa-bS)/(1-bS))^2);
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_0VS(i)*1e6*A_AlS*sqrt(1-((Pserb_0VS(i)/Pa-bS)/(1-bS))^2);
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_0VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_0VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_0VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_0VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_0VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_0VS=G_ISOtS';
G_man_0VS=G_mantS';
G_eq_0VS=G_eqtS';
G_eqman_0VS=G_eqmantS';
G_Al_0VS=G_AltS';
end

for i=1:length(Pserb_0V)
    A_eff=A(1,1);
    R_man=7.7e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN2(1,1)=A_man;
    A_eq=(-4.431e-07)*V(1,1)+2.112e-06;
    A_eqman=(-3.953e-07)*V(1,1)+1.913e-06;
    A_Al=A_max*Coeff_Al2(1,1);
%Subsonico
if Pserb_0V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_0V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_0V(i)/Ps-b)/(1-b))^2);
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_0V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_0V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_0V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff; 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman;
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_0V=G_ISOt';
G_man_0V=G_mant';
G_eq_0V=G_eqt';
G_eqman_0V=G_eqmant';
G_Al_0V=G_Alt';
end


figure
plot(Pserb_0VS./Pa,Q2_0VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_0V./Pa,G_ISO_0V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_0VS./Pa,G_man_0VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_0VS./Pa,G_eq_0VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_0VS./Pa,G_eqman_0VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_0VS./Pa,G_Al_0VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_0V./Ps,Q2_0V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_0V./Ps,G_ISO_0V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_0V./Ps,G_man_0V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_0V./Ps,G_eq_0V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_0V./Ps,G_eqman_0V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_0V./Ps,G_Al_0V.*cG,'MarkerSize',5,'linewidth',2),hold on
ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{manuale}$','$Q_{retta}$','$Q_{eq\ manuale}$','$Q_{coeff sovr}$','FontSize',20,'interpreter','latex')

%V=0.5
for i=1:length(Pserb_05VS)
    A_effS=AS(2,1);
    R_manS=8.22e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN2(2,1)=A_manS;
    A_eqS=(-4.147e-07)*V(1,2)+1.965e-06;
    A_eqmanS=(-4.929e-07)*V(1,2)+2.372e-06;
    A_AlS=A_maxS*Coeff_Al_SC2(2,1);
%Subsonico
if Pserb_05VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_05VS(i)*1e6*A_effS*sqrt(1-((Pserb_05VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_05VS(i)*1e6*A_manS*sqrt(1-((Pserb_05VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_05VS(i)*1e6*A_eqS*sqrt(1-((Pserb_05VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_05VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_05VS(i)/Pa-bS)/(1-bS))^2);
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_05VS(i)*1e6*A_AlS*sqrt(1-((Pserb_05VS(i)/Pa-bS)/(1-bS))^2);
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_05VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_05VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_05VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_05VS(i)*1e6*A_eqmanS;
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_05VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_05VS=G_ISOtS';
G_man_05VS=G_mantS';
G_eq_05VS=G_eqtS';
G_eqman_05VS=G_eqmantS';
G_Al_05VS=G_AltS';
end

for i=1:length(Pserb_05V)
    A_eff=A(2,1);
    R_man=7.3e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN2(2,1)=A_man;
    A_eq=(-4.431e-07)*V(1,2)+2.112e-06;
    A_eqman=(-3.953e-07)*V(1,2)+1.913e-06;
    A_Al=A_max*Coeff_Al2(2,1);
%Subsonico
if Pserb_05V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_05V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_05V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_05V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_05V(i)/Ps-b)/(1-b))^2);
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_05V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man;
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman;
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al;

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_05V=G_ISOt';
G_man_05V=G_mant';
G_eq_05V=G_eqt';
G_eqman_05V=G_eqmant';
G_Al_05V=G_Alt';
end


figure
plot(Pserb_05VS./Pa,Q2_05VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_05V./Pa,G_ISO_05V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_05VS./Pa,G_man_05VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_05VS./Pa,G_eq_05VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_05VS./Pa,G_eqman_05VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_05VS./Pa,G_Al_05VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_05V./Ps,Q2_05V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_05V./Ps,G_ISO_05V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_05V./Ps,G_man_05V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_05V./Ps,G_eq_05V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_05V./Ps,G_eqman_05V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_05V./Ps,G_Al_05V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{manuale}$','$Q_{retta}$','$Q_{eq\ manuale}$','$Q_{coeff sovr}$','FontSize',20,'interpreter','latex')

%V=1
for i=1:length(Pserb_1VS)
    A_effS=AS(3,1);
    R_manS=7.85e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN2(3,1)=A_manS;
    A_eqS=(-4.147e-07)*V(1,3)+1.965e-06; 
    A_eqmanS=(-4.929e-07)*V(1,3)+2.372e-06;
    A_AlS=A_maxS*Coeff_Al_SC2(3,1);
%Subsonico
if Pserb_1VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_1VS(i)*1e6*A_effS*sqrt(1-((Pserb_1VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_1VS(i)*1e6*A_manS*sqrt(1-((Pserb_1VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_1VS(i)*1e6*A_eqS*sqrt(1-((Pserb_1VS(i)/Pa-bS)/(1-bS))^2);
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_1VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_1VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_1VS(i)*1e6*A_AlS*sqrt(1-((Pserb_1VS(i)/Pa-bS)/(1-bS))^2);
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_1VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_1VS(i)*1e6*A_manS;
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_1VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_1VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_1VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_1VS=G_ISOtS';
G_man_1VS=G_mantS';
G_eq_1VS=G_eqtS';
G_eqman_1VS=G_eqmantS';
G_Al_1VS=G_AltS';
end

for i=1:length(Pserb_1V)
    A_eff=A(3,1);
    R_man=6.96e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN2(3,1)=A_man;
    A_eq=(-4.431e-07)*V(1,3)+2.112e-06;
    A_eqman=(-3.953e-07)*V(1,3)+1.913e-06;
    A_Al=A_max*Coeff_Al2(3,1);
%Subsonico
if Pserb_1V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_1V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_1V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_1V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_1V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_1V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman; 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_1V=G_ISOt';
G_man_1V=G_mant';
G_eq_1V=G_eqt';
G_eqman_1V=G_eqmant';
G_Al_1V=G_Alt';
end


figure
plot(Pserb_1VS./Pa,Q2_1VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_1V./Pa,G_ISO_1V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_1VS./Pa,G_man_1VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_1VS./Pa,G_eq_1VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_1VS./Pa,G_eqman_1VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_1VS./Pa,G_Al_1VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_1V./Ps,Q2_1V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_1V./Ps,G_ISO_1V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_1V./Ps,G_man_1V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_1V./Ps,G_eq_1V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_1V./Ps,G_eqman_1V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_1V./Ps,G_Al_1V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{manuale}$','$Q_{retta}$','$Q_{eq\ manuale}$','$Q_{coeff sovr}$','FontSize',20,'interpreter','latex')

%V=1.5
for i=1:length(Pserb_15VS)
    A_effS=AS(4,1);
    R_manS=7.47e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN2(4,1)=A_manS;
    A_eqS=(-4.147e-07)*V(1,4)+1.965e-06; 
    A_eqmanS=(-4.929e-07)*V(1,4)+2.372e-06;
    A_AlS=A_maxS*Coeff_Al_SC2(4,1);
%Subsonico
if Pserb_15VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_15VS(i)*1e6*A_effS*sqrt(1-((Pserb_15VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_15VS(i)*1e6*A_manS*sqrt(1-((Pserb_15VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_15VS(i)*1e6*A_eqS*sqrt(1-((Pserb_15VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_15VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_15VS(i)/Pa-bS)/(1-bS))^2);
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_15VS(i)*1e6*A_AlS*sqrt(1-((Pserb_15VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_15VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_15VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_15VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_15VS(i)*1e6*A_eqmanS;
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_15VS(i)*1e6*A_AlS;

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_15VS=G_ISOtS';
G_man_15VS=G_mantS';
G_eq_15VS=G_eqtS';
G_eqman_15VS=G_eqmantS';
G_Al_15VS=G_AltS';
end

for i=1:length(Pserb_15V)
    A_eff=A(4,1);
    R_man=6.76e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN2(4,1)=A_man;
    A_eq=(-4.431e-07)*V(1,4)+2.112e-06;
    A_eqman=(-3.953e-07)*V(1,4)+1.913e-06;
    A_Al=A_max*Coeff_Al2(4,1);
%Subsonico
if Pserb_15V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_15V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_15V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_15V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_15V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_15V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman; 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_15V=G_ISOt';
G_man_15V=G_mant';
G_eq_15V=G_eqt';
G_eqman_15V=G_eqmant';
G_Al_15V=G_Alt';
end


figure
plot(Pserb_15VS./Pa,Q2_15VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_15V./Pa,G_ISO_15V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_15VS./Pa,G_man_15VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_15VS./Pa,G_eq_15VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_15VS./Pa,G_eqman_15VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_15VS./Pa,G_Al_15VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_15V./Ps,Q2_15V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_15V./Ps,G_ISO_15V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_15V./Ps,G_man_15V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_15V./Ps,G_eq_15V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_15V./Ps,G_eqman_15V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_15V./Ps,G_Al_15V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{manuale}$','$Q_{retta}$','$Q_{eq\ manuale}$','$Q_{coeff sovr}$','FontSize',20,'interpreter','latex')

%V=2.0
for i=1:length(Pserb_2VS)
    A_effS=AS(5,1);
    R_manS=6.77e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN2(5,1)=A_manS;
    A_eqS=(-4.147e-07)*V(1,5)+1.965e-06; 
    A_eqmanS=(-4.929e-07)*V(1,5)+2.372e-06;
    A_AlS=A_maxS*Coeff_Al_SC2(5,1);
%Subsonico
if Pserb_2VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_2VS(i)*1e6*A_effS*sqrt(1-((Pserb_2VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_2VS(i)*1e6*A_manS*sqrt(1-((Pserb_2VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_2VS(i)*1e6*A_eqS*sqrt(1-((Pserb_2VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_2VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_2VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_2VS(i)*1e6*A_AlS*sqrt(1-((Pserb_2VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_2VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_2VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_2VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_2VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_2VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_2VS=G_ISOtS';
G_man_2VS=G_mantS';
G_eq_2VS=G_eqtS';
G_eqman_2VS=G_eqmantS';
G_Al_2VS=G_AltS';
end

for i=1:length(Pserb_2V)
    A_eff=A(5,1);
    R_man=6.2e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN2(5,1)=A_man;
    A_eq=(-4.431e-07)*V(1,5)+2.112e-06;
    A_eqman=(-3.953e-07)*V(1,5)+1.913e-06;
    A_Al=A_max*Coeff_Al2(5,1);
%Subsonico
if Pserb_2V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_2V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_2V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_2V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_2V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_2V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman;
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_2V=G_ISOt';
G_man_2V=G_mant';
G_eq_2V=G_eqt';
G_eqman_2V=G_eqmant';
G_Al_2V=G_Alt';
end


figure
plot(Pserb_2VS./Pa,Q2_2VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_2V./Pa,G_ISO_2V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_2VS./Pa,G_man_2VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_2VS./Pa,G_eq_2VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_2VS./Pa,G_eqman_2VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_2VS./Pa,G_Al_2VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_2V./Ps,Q2_2V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_2V./Ps,G_ISO_2V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_2V./Ps,G_man_2V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_2V./Ps,G_eq_2V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_2V./Ps,G_eqman_2V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_2V./Ps,G_Al_2V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{manuale}$','$Q_{retta}$','$Q_{eq\ manuale}$','$Q_{coeff sovr}$','FontSize',20,'interpreter','latex')

%V=2.5
for i=1:length(Pserb_25VS)
    A_effS=AS(6,1);
    R_manS=6.12e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN2(6,1)=A_manS;
    A_eqS=(-4.147e-07)*V(1,6)+1.965e-06; 
    A_eqmanS=(-4.929e-07)*V(1,6)+2.372e-06;
    A_AlS=A_maxS*Coeff_Al_SC2(6,1);
%Subsonico
if Pserb_25VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_25VS(i)*1e6*A_effS*sqrt(1-((Pserb_25VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_25VS(i)*1e6*A_manS*sqrt(1-((Pserb_25VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_25VS(i)*1e6*A_eqS*sqrt(1-((Pserb_25VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_25VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_25VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_25VS(i)*1e6*A_AlS*sqrt(1-((Pserb_25VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_25VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_25VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_25VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_25VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_25VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_25VS=G_ISOtS';
G_man_25VS=G_mantS';
G_eq_25VS=G_eqtS';
G_eqman_25VS=G_eqmantS';
G_Al_25VS=G_AltS';
end

for i=1:length(Pserb_25V)
    A_eff=A(6,1);
    R_man=5.4e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN2(6,1)=A_man;
    A_eq=(-4.431e-07)*V(1,6)+2.112e-06;
    A_eqman=(-3.953e-07)*V(1,6)+1.913e-06;
    A_Al=A_max*Coeff_Al2(6,1);
%Subsonico
if Pserb_25V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_25V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_25V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_25V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_25V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_25V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman;
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_25V=G_ISOt';
G_man_25V=G_mant';
G_eq_25V=G_eqt';
G_eqman_25V=G_eqmant';
G_Al_25V=G_Alt';
end


figure
plot(Pserb_25VS./Pa,Q2_25VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_25V./Pa,G_ISO_25V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_25VS./Pa,G_man_25VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_25VS./Pa,G_eq_25VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_25VS./Pa,G_eqman_25VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_25VS./Pa,G_Al_25VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_25V./Ps,Q2_25V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_25V./Ps,G_ISO_25V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_25V./Ps,G_man_25V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_25V./Ps,G_eq_25V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_25V./Ps,G_eqman_25V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_25V./Ps,G_Al_25V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{manuale}$','$Q_{retta}$','$Q_{eq\ manuale}$','$Q_{coeff sovr}$','FontSize',20,'interpreter','latex')

%V=3.0
for i=1:length(Pserb_3VS)
    A_effS=AS(7,1);
    R_manS=5.23e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN2(7,1)=A_manS;
    A_eqS=(-4.147e-07)*V(1,7)+1.965e-06; 
    A_eqmanS=(-4.929e-07)*V(1,7)+2.372e-06;
    A_AlS=A_maxS*Coeff_Al_SC2(7,1);
%Subsonico
if Pserb_3VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_3VS(i)*1e6*A_effS*sqrt(1-((Pserb_3VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_3VS(i)*1e6*A_manS*sqrt(1-((Pserb_3VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_3VS(i)*1e6*A_eqS*sqrt(1-((Pserb_3VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_3VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_3VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_3VS(i)*1e6*A_AlS*sqrt(1-((Pserb_3VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_3VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_3VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_3VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_3VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_3VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_3VS=G_ISOtS';
G_man_3VS=G_mantS';
G_eq_3VS=G_eqtS';
G_eqman_3VS=G_eqmantS';
G_Al_3VS=G_AltS';
end

for i=1:length(Pserb_3V)
    A_eff=A(7,1);
    R_man=4.69e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN2(7,1)=A_man;
    A_eq=(-4.431e-07)*V(1,7)+2.112e-06;
    A_eqman=(-3.953e-07)*V(1,7)+1.913e-06;
    A_Al=A_max*Coeff_Al2(7,1);
%Subsonico
if Pserb_3V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_3V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_3V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_3V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_3V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_3V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman; 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_3V=G_ISOt';
G_man_3V=G_mant';
G_eq_3V=G_eqt';
G_eqman_3V=G_eqmant';
G_Al_3V=G_Alt';
end


figure
plot(Pserb_3VS./Pa,Q2_3VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_3V./Pa,G_ISO_3V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_3VS./Pa,G_man_3VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_3VS./Pa,G_eq_3VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_3VS./Pa,G_eqman_3VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_3VS./Pa,G_Al_3VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_3V./Ps,Q2_3V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_3V./Ps,G_ISO_3V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_3V./Ps,G_man_3V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_3V./Ps,G_eq_3V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_3V./Ps,G_eqman_3V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_3V./Ps,G_Al_3V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{manuale}$','$Q_{retta}$','$Q_{eq\ manuale}$','$Q_{coeff sovr}$','FontSize',20,'interpreter','latex')

%V=3.5
for i=1:length(Pserb_35VS)
    A_effS=AS(8,1);
    R_manS=4.27e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN2(8,1)=A_manS;
    A_eqS=(-4.147e-07)*V(1,8)+1.965e-06; 
    A_eqmanS=(-4.929e-07)*V(1,8)+2.372e-06;
    A_AlS=A_maxS*Coeff_Al_SC2(8,1);
%Subsonico
if Pserb_35VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_35VS(i)*1e6*A_effS*sqrt(1-((Pserb_35VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_35VS(i)*1e6*A_manS*sqrt(1-((Pserb_35VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_35VS(i)*1e6*A_eqS*sqrt(1-((Pserb_35VS(i)/Pa-bS)/(1-bS))^2);
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_35VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_35VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_35VS(i)*1e6*A_AlS*sqrt(1-((Pserb_35VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_35VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_35VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_35VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_35VS(i)*1e6*A_eqmanS;
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_35VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_35VS=G_ISOtS';
G_man_35VS=G_mantS';
G_eq_35VS=G_eqtS';
G_eqman_35VS=G_eqmantS';
G_Al_35VS=G_AltS';
end

for i=1:length(Pserb_35V)
    A_eff=A(8,1);
    R_man=3.92e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN2(8,1)=A_man;
    A_eq=(-4.431e-07)*V(1,8)+2.112e-06;
    A_eqman=(-3.953e-07)*V(1,8)+1.913e-06;
    A_Al=A_max*Coeff_Al2(8,1);
%Subsonico
if Pserb_35V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_35V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_35V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_35V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_35V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_35V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman;
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_35V=G_ISOt';
G_man_35V=G_mant';
G_eq_35V=G_eqt';
G_eqman_35V=G_eqmant';
G_Al_35V=G_Alt';
end


figure
plot(Pserb_35VS./Pa,Q2_35VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_35V./Pa,G_ISO_35V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_35VS./Pa,G_man_35VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_35VS./Pa,G_eq_35VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_35VS./Pa,G_eqman_35VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_35VS./Pa,G_Al_35VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_35V./Ps,Q2_35V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_35V./Ps,G_ISO_35V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_35V./Ps,G_man_35V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_35V./Ps,G_eq_35V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_35V./Ps,G_eqman_35V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_35V./Ps,G_Al_35V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{manuale}$','$Q_{retta}$','$Q_{eq\ manuale}$','$Q_{coeff sovr}$','FontSize',20,'interpreter','latex')

%V=4
for i=1:length(Pserb_4VS)
    A_effS=AS(9,1);
    R_manS=3.2e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN2(9,1)=A_manS;
    A_eqS=(-4.147e-07)*V(1,9)+1.965e-06; 
    A_eqmanS=(-4.929e-07)*V(1,9)+2.372e-06;
    A_AlS=A_maxS*Coeff_Al_SC2(9,1);
%Subsonico
if Pserb_4VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_4VS(i)*1e6*A_effS*sqrt(1-((Pserb_4VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_4VS(i)*1e6*A_manS*sqrt(1-((Pserb_4VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_4VS(i)*1e6*A_eqS*sqrt(1-((Pserb_4VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_4VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_4VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_4VS(i)*1e6*A_AlS*sqrt(1-((Pserb_4VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_4VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_4VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_4VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_4VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_4VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_4VS=G_ISOtS';
G_man_4VS=G_mantS';
G_eq_4VS=G_eqtS';
G_eqman_4VS=G_eqmantS';
G_Al_4VS=G_AltS';
end

for i=1:length(Pserb_4V)
    A_eff=A(9,1);
    R_man=2.92e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN2(9,1)=A_man;
    A_eq=(-4.431e-07)*V(1,9)+2.112e-06;
    A_eqman=(-3.953e-07)*V(1,9)+1.913e-06;
    A_Al=A_max*Coeff_Al2(9,1);
%Subsonico
if Pserb_4V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_4V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_4V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_4V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_4V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_4V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman; 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_4V=G_ISOt';
G_man_4V=G_mant';
G_eq_4V=G_eqt';
G_eqman_4V=G_eqmant';
G_Al_4V=G_Alt';
end


figure
plot(Pserb_4VS./Pa,Q2_4VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_4V./Pa,G_ISO_4V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_4VS./Pa,G_man_4VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_4VS./Pa,G_eq_4VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_4VS./Pa,G_eqman_4VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_4VS./Pa,G_Al_4VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_4V./Ps,Q2_4V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_4V./Ps,G_ISO_4V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_4V./Ps,G_man_4V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_4V./Ps,G_eq_4V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_4V./Ps,G_eqman_4V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_4V./Ps,G_Al_4V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{manuale}$','$Q_{retta}$','$Q_{eq\ manuale}$','$Q_{coeff sovr}$','FontSize',20,'interpreter','latex')

%V=4.5
for i=1:length(Pserb_45VS)
    A_effS=AS(10,1);
    R_manS=1.8e-4;
    A_manS=pi*R_manS^2;
    A_SCARICOMAN2(10,1)=A_manS;
    A_eqS=(-4.147e-07)*V(1,10)+1.965e-06;
    A_eqmanS=(-4.929e-07)*V(1,10)+2.372e-06;
    A_AlS=A_maxS*Coeff_Al_SC2(10,1);
%Subsonico
if Pserb_45VS(i)/Pa<bS;
g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_45VS(i)*1e6*A_effS*sqrt(1-((Pserb_45VS(i)/Pa-bS)/(1-bS))^2); 
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_45VS(i)*1e6*A_manS*sqrt(1-((Pserb_45VS(i)/Pa-bS)/(1-bS))^2); 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_45VS(i)*1e6*A_eqS*sqrt(1-((Pserb_45VS(i)/Pa-bS)/(1-bS))^2); 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_45VS(i)*1e6*A_eqmanS*sqrt(1-((Pserb_45VS(i)/Pa-bS)/(1-bS))^2); 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_45VS(i)*1e6*A_AlS*sqrt(1-((Pserb_45VS(i)/Pa-bS)/(1-bS))^2); 
else
%Sonico

g_ISOS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_45VS(i)*1e6*A_effS;
g_manS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_45VS(i)*1e6*A_manS; 
g_eqS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_45VS(i)*1e6*A_eqS; 
g_eqmanS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_45VS(i)*1e6*A_eqmanS; 
g_AlS=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Pserb_45VS(i)*1e6*A_AlS; 

end

G_ISOtS(i)=-g_ISOS;
G_mantS(i)=-g_manS;
G_eqtS(i)=-g_eqS;
G_eqmantS(i)=-g_eqmanS;
G_AltS(i)=-g_AlS;

G_ISO_45VS=G_ISOtS';
G_man_45VS=G_mantS';
G_eq_45VS=G_eqtS';
G_eqman_45VS=G_eqmantS';
G_Al_45VS=G_AltS';
end

for i=1:length(Pserb_45V)
    A_eff=A(10,1);
    R_man=1.9e-4;
    A_man=pi*R_man^2;
    A_CARICOMAN2(10,1)=A_man;
    A_eq=(-4.431e-07)*V(1,10)+2.112e-06;
    A_eqman=(-3.953e-07)*V(1,10)+1.913e-06;
    A_Al=A_max*Coeff_Al2(10,1);
%Subsonico
if Pserb_45V(i)/Ps>b;
g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff*sqrt(1-((Pserb_45V(i)/Ps-b)/(1-b))^2); 
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man*sqrt(1-((Pserb_45V(i)/Ps-b)/(1-b))^2); 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq*sqrt(1-((Pserb_45V(i)/Ps-b)/(1-b))^2); 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman*sqrt(1-((Pserb_45V(i)/Ps-b)/(1-b))^2); 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al*sqrt(1-((Pserb_45V(i)/Ps-b)/(1-b))^2); 
else
%Sonico

g_ISO=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eff;
g_man=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_man; 
g_eq=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eq; 
g_eqman=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_eqman; 
g_Al=cd_ISO*sqrt(293/Ts)*0.686/sqrt(Rg*Ts)*Ps*1e6*A_Al; 

end

G_ISOt(i)=g_ISO;
G_mant(i)=g_man;
G_eqt(i)=g_eq;
G_eqmant(i)=g_eqman;
G_Alt(i)=g_Al;

G_ISO_45V=G_ISOt';
G_man_45V=G_mant';
G_eq_45V=G_eqt';
G_eqman_45V=G_eqmant';
G_Al_45V=G_Alt';
end


figure
plot(Pserb_45VS./Pa,Q2_45VS,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_45V./Pa,G_ISO_45V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_45VS./Pa,G_man_45VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_45VS./Pa,G_eq_45VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_45VS./Pa,G_eqman_45VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_45VS./Pa,G_Al_45VS.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_45V./Ps,Q2_45V,'o','MarkerSize',5,'linewidth',1.3),hold on % SPERIMENTALE
% plot(Pserb_45V./Ps,G_ISO_45V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_45V./Ps,G_man_45V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_45V./Ps,G_eq_45V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_45V./Ps,G_eqman_45V.*cG,'MarkerSize',5,'linewidth',2),hold on
plot(Pserb_45V./Ps,G_Al_45V.*cG,'MarkerSize',5,'linewidth',2),hold on

ylabel('Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex'),xlabel('$P_{2}/P_{1}$ ','interpreter','latex')
grid on,zoom on,   %title('Confronto curve portata 0.0 $V$','interpreter','latex')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)  
legend('$Q_{sperimentale}$','$Q_{manuale}$','$Q_{retta}$','$Q_{eq\ manuale}$','$Q_{coeff sovr}$','FontSize',20,'interpreter','latex')

%%
A_CARICOMAN2(11,1)=0;

myfittype = fittype('m*V+q',...
    'dependent',{'A_CARICOMAN2'},'independent',{'V'},...
    'coefficients',{'m','q'})
myfit = fit(V',A_CARICOMAN2,myfittype)

figure
plot(V,A_CARICOMAN2,'bo','MarkerSize',12,'linewidth',3), hold on 
plot(myfit,V,A_CARICOMAN2,'b')
ylabel('$A_{2}$ [$m^2$]','interpreter','latex'), xlabel(' V [$V$] ','interpreter','latex')
grid on, zoom on,  title('Sezione passaggio uscita 2')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)



A_SCARICOMAN2(11,1)=0;

myfittype1 = fittype('m*V+q',...
    'dependent',{'A_SCARICOMAN2'},'independent',{'V'},...
    'coefficients',{'m','q'})
myfit1 = fit(V',A_SCARICOMAN2,myfittype1)

figure
plot(V,A_SCARICOMAN2,'bo','MarkerSize',12,'linewidth',3), hold on 
plot(myfit1,V,A_SCARICOMAN2,'b')
ylabel('$A_{2}$ [$m^2$]','interpreter','latex'), xlabel(' V [$V$] ','interpreter','latex')
grid on, zoom on,  title('Sezione passaggio uscita 4')
set(gca,'FontName','Times New Roman'),set(gca,'FontSize',25)



