close all
clear all
clc

Filenames=dir('Caratterizzazione Valvola FESTO 5-3\*.txt');
faq=100;
Pa=0.101325;%P ambiente
Ps=0.2+Pa;%P supply
N=0:0.5:5;

%Carico serbatoio
for ii=1:11      
    dati=load((fullfile(Filenames(ii).folder, Filenames(ii).name)));
    Q_2=dati(:,1);
    Q_3=dati(:,2);
    Pserb=0.1.*(dati(:,3))+Pa;
    time=(0:size(dati,1)-1)*1/faq;
    massimi(1,ii)=max(abs(Q_2));

       
    figure
    subplot(2,1,1)
    plot(time,Pserb,'linewidth', 3.5)
    xlabel('t [$s$]','interpreter','latex'), ylabel('P [$MPa$]','interpreter','latex')
    yticks([0 0.1 0.2 0.3 0.4])
    ylim([0 0.4])
%     title(Filenames(ii).name, 'interpreter', 'none')
    grid on,zoom on
    set(gca,'FontName','Times New Roman'),set(gca,'FontSize',21)

    subplot(2,1,2)
    plot(time,Q_2,'linewidth', 3.5)
    xlabel('t [$s$]','interpreter','latex'), ylabel(' Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex')
    grid on,zoom on
    set(gca,'FontName','Times New Roman'),set(gca,'FontSize',21)
 
figure
    plot(Pserb/Ps,Q_2,'linewidth', 3.5)
    xlabel('P$_{A}$/P$_{S}$','interpreter','latex'), ylabel('  Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex')
    grid on,zoom on
    set(gca,'FontName','Times New Roman'),set(gca,'FontSize',21)       
end

%Scarico serbatoio

for ii=12:22      
    dati=load((fullfile(Filenames(ii).folder, Filenames(ii).name)));
    Q_2=dati(:,1);
    Q_3=dati(:,2);
    Pserb=0.1.*(dati(:,3))+Pa;
    time=(0:size(dati,1)-1)*1/faq;
    massimi(1,ii)=max(abs(Q_2));

       
    figure
    subplot(2,1,1)
    plot(time,Pserb,'linewidth', 3.5)
    xlabel('t [$s$]','interpreter','latex'), ylabel('P [$MPa$]','interpreter','latex')
    yticks([0 0.1 0.2 0.3 0.4])
    ylim([0 0.4])
%     title(Filenames(ii).name, 'interpreter', 'none')
    grid on,zoom on
    set(gca,'FontName','Times New Roman'),set(gca,'FontSize',21)
    subplot(2,1,2)
    plot(time,Q_2,'linewidth', 3.5)
    xlabel('t [$s$]','interpreter','latex'), ylabel(' Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex')
    grid on,zoom on
    set(gca,'FontName','Times New Roman'),set(gca,'FontSize',21)
    
    figure% ugello
    plot(Pa./Pserb,Q_2,'linewidth', 3.5)
    xlabel('P$_{0}$/P$_{A}$','interpreter','latex'), ylabel(' Q [$l/min\ ANR\ 20^\circ \ C$]','interpreter','latex')
    grid on,zoom on
    set(gca,'FontName','Times New Roman'),set(gca,'FontSize',21)
    end
