s_LoadConstants

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PHYSICAL PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Computation of physical parameters

pp.Eg       = dd.BandGap;
pp.T        = dd.Temp;
pp.z        = dd.node;
pp.N        = dd.nn;
pp.eps      = dd.epsr*eps0;
pp.le       = dd.ElementLength;
pp.lb       = dd.ControlBox;
pp.vbo      = dd.VBO-dd.VBO(1);
pp.cbo      = (dd.VBO+pp.Eg)-(dd.VBO(1)+pp.Eg(1));
pp.mun      = dd.eMobility;
pp.mup      = dd.hMobility;
pp.E_SRH    = dd.EtrapSRH;
pp.taun_SRH = dd.tauSRH_n;
pp.taup_SRH = dd.tauSRH_p;
pp.meffn    = (dd.meff_e(1:end-1)*m0+dd.meff_e(2:end)*m0)/2;
pp.meffp    = (dd.meff_h(1:end-1)*m0+dd.meff_h(2:end)*m0)/2;

pp.Nc       = 2*(dd.meff_e*m0*kB*dd.Temp/(2*pi*hbar^2)).^1.5;
pp.Nv       = 2*(dd.meff_h*m0*kB*dd.Temp/(2*pi*hbar^2)).^1.5;
pp.ni       = sqrt(pp.Nc.*pp.Nv).*exp(-pp.Eg/(2*kB*dd.Temp));
pp.dop_tot  = dd.dop_D-dd.dop_A;
pp.Dn       = kB*pp.T/q*pp.mun;
pp.Dp       = kB*pp.T/q*pp.mup;
pp.nt       = pp.ni.*exp(pp.E_SRH/(kB*pp.T));
pp.pt       = pp.ni.*exp(-pp.E_SRH/(kB*pp.T));
