
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Unit conversion constants
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The engine of the code works with SI units; in this view, conversion
% constants are useful to insert numbers in more "confortable", yet less
% standard, units
cm = 1e-2;              % multiply to convert from cm to m
um = 1e-6;              % multiply to convert from um to m
nm = 1e-9;              % multiply to convert from nm to m
eV = 1.6021766208e-019; % multiply to convert from eV to J
sec = 1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Physical constants
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
q       = 1.6021766208e-019;  % elementary charge (C)
m0      = 9.10938291e-31;     % electron mass (kg)
kB      = 1.3806488e-23;      % Boltzmann constant (J/K)
h       = 6.626070040e-34;    % Planck constant (J*s)
hbar    = h/(2*pi);           % Reduced Planck constant (J*s)
c_light = 2.99792458e8;       % speed of light (m/s)
mu0     = 4*pi*1e-7;          % magnetic permeability (H/m)
eps0    = 1/(mu0*c_light^2);  % dielectric permittivity (F/m)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% List of material types
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
semiconductor = 0;
oxide         = 1;