function [phi,n,p] = f_neutrality(pp)
    % Neutrality solver for initial guess
    s_LoadConstants;
    
    ind_n    = (pp.dop_tot >= 0);
    ind_p    = (pp.dop_tot <  0);
    n        = zeros(size(pp.z));
    p        = zeros(size(pp.z));
    phi      = zeros(size(pp.z));
    n(ind_n) = (pp.dop_tot(ind_n)+sqrt(pp.dop_tot(ind_n).^2+4*pp.ni(ind_n).^2))/2;
    p(ind_n) = (pp.ni(ind_n).^2)./(n(ind_n));
    p(ind_p) = (-pp.dop_tot(ind_p)+sqrt(pp.dop_tot(ind_p).^2+4*pp.ni(ind_p).^2))/2;
    n(ind_p) = (pp.ni(ind_p).^2)./(p(ind_p));
    phi      = kB*pp.T/q*log(n./pp.Nc)+pp.cbo/q;

    % Conversion to sparse form
    phi      = sparse(phi);
    n        = sparse(n)  ;
    p        = sparse(p)  ;
end

