/**
 *
 * @param ruleForm 需要生成校验规则的对象
 * @param validator 校验规则函数
 * @returns 生成的校验规则
 */
const getFormRule = (ruleForm: any, validator: any) => {
  return Object.keys(ruleForm).reduce((prev, curr) => {
    // 排除这些不做校验。
    const exceptArr: any = []
    if (!exceptArr.includes(curr)) {
      return {
        ...prev,
        [curr]: {
          required: true,
          validator,
          trigger: ['blur', 'change']
        }
      }
    } else {
      return prev
    }
  }, {})
}

/**
 *
 * @param rule 校验规则
 * @param valueItem 校验对象（因为封装的缘故这里是一个对象）
 * @param callback 如果校验通过执行callback 不通过在其中传入一个new Error对象
 * @returns 可以没有返回值
 */
const checkInputNoEmpty = (rule: any, valueItem: any, callback: any) => {
  // 非数字输入状态下
  // 如果输入的值为0 直接return
  if (valueItem.value === '0' || valueItem.value === 0) {
    return callback(new Error('Please input the data without number 0'))
  } else if (!valueItem.value) {
    return callback(new Error('Please input or choose the data'))
  } else {
    callback()
  }
}

export {
  getFormRule,
  checkInputNoEmpty
}
